/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_010_PayBillFinArTest
extends FinBillBaseTest {
    private long cacheFinArBillId1;
    private long cacheFinArBillId2;
    private long payBillId;
    private long payApplyId;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_010-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(1L));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("AR_018_010-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u5168\u90e8\u4ed8\u6b3e\u5904\u74061\u6821\u9a8c")
    @Test
    public void fullPushPayTest1() {
        this.payApplyId = this.pushAndAuditApply(new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)});
        this.payBillId = this.pushAndAuditPay(this.payApplyId);
        this.pay(this.payBillId);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assetFinishedStatus(this.cacheFinArBillId1);
        this.assetFinishedStatus(this.cacheFinArBillId2);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.payBillId}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.payBillId}, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u5168\u90e8\u53d6\u6d88\u4ed8\u6b3e\u5904\u74061\u6821\u9a8c")
    @Test
    public void fullPushCancelPayTest1() {
        this.cancel(this.payBillId);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject finBill = this.getFinBill(this.cacheFinArBillId1);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObject finBill2 = this.getFinBill(this.cacheFinArBillId2);
        FinArBillTestChecker.validateHeadSettleAmt(finBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L));
        DynamicObjectCollection detailEntries2 = finBill2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObjectCollection planEntries2 = finBill2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries2.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries2.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.payBillId}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.payBillId}, true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u5168\u90e8\u4ed8\u6b3e\u5904\u74061\u5220\u9664\u6821\u9a8c")
    @Test
    public void fullPushDeletePayTest1() {
        this.deleteBill("cas_paybill", this.payBillId);
        this.deleteBill("ap_payapply", this.payApplyId);
        this.assetInitStatus(this.cacheFinArBillId1);
        this.assetInitStatus(this.cacheFinArBillId2);
    }

    private long pushAndAuditPay(long payApplyId) {
        List<DynamicObject> payBillList = BOTPHelper.push("ap_payapply", "cas_paybill", "670682874575363072", Collections.singletonList(payApplyId));
        KDAssert.assertTrue((payBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject payBill = payBillList.get(0);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        payBill = BusinessDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)"cas_paybill");
        payBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        return payBill.getLong("id");
    }

    private void pay(long payBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private void cancel(long payBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private long pushAndAuditApply(BigDecimal[] entryAmtArray) {
        List<DynamicObject> payApplyList = BOTPHelper.push("ar_finarbill", "ap_payapply", "753390670084846592", Arrays.asList(this.cacheFinArBillId1, this.cacheFinArBillId2));
        KDAssert.assertTrue((payApplyList.size() == 1 ? 1 : 0) != 0);
        DynamicObject payApplyBill = payApplyList.get(0);
        PayApplyBillTestHelper.setEntryAmt(payApplyBill, entryAmtArray);
        DynamicObject payType = BaseDataTestProvider.getPaymentType();
        for (DynamicObject payEntryRow : payApplyBill.getDynamicObjectCollection("entry")) {
            payEntryRow.set("e_paymenttype", (Object)payType);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (DynamicObject[])new DynamicObject[]{payApplyBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        payApplyBill = BusinessDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)"ap_payapply");
        payApplyBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payApplyBill});
        return payApplyBill.getLong("id");
    }

    @Override
    protected void assetInitStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L));
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L));
    }

    @Override
    protected void assetFinishedStatus(long finArBillId) {
        DynamicObject finBill = this.getFinBill(finArBillId);
        FinArBillTestChecker.validateHeadSettleAmt(finBill, BigDecimal.valueOf(-2000L), BigDecimal.valueOf(-2000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection detailEntries = finBill.getDynamicObjectCollection("entry");
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntryLockAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validateDetailEntrySettleAmt((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObjectCollection planEntries = finBill.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntryLockAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L), BigDecimal.ZERO, BigDecimal.ZERO);
        FinArBillTestChecker.validatePlanEntrySettleAmt((DynamicObject)planEntries.get(1), BigDecimal.valueOf(-1000L), BigDecimal.valueOf(-1000L), BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

