/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.CasRecBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.CasRecBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import kd.fi.arapcommon.unittest.scene.process.arfin.FinBillBaseTest;
import org.junit.Test;

public class AR018_011_PayBillReturnFinArTest
extends FinBillBaseTest {
    private long cacheFinArBillId1;
    private long cacheFinArBillId2;
    private long payApplyId;
    private long payBillId;
    private long casRecBillId;

    public void initData() {
        super.initData();
        FinArBillDataVO header = new FinArBillDataVO();
        header.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header.setExchangerate(BigDecimal.valueOf(1L));
        header.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header.setBillNo("AR_018_011-TEST-1");
        DynamicObject finArBill1 = FinArBillTestDataProvider.createAR018FinBill(header, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId1 = finArBill1.getLong("id");
        FinArBillDataVO header1 = new FinArBillDataVO();
        header1.setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        header1.setExchangerate(BigDecimal.valueOf(1L));
        header1.setOrg(BaseDataTestProvider.getPlanInitOrg());
        header1.setBillNo("AR_018_011-TEST-2");
        DynamicObject finArBill2 = FinArBillTestDataProvider.createAR018FinBill(header1, new BigDecimal[]{BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.cacheFinArBillId2 = finArBill2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8ba1\u5212\u884c\u5408\u5e76\u4e0b\u63a8-\u4ed8\u6b3e\u7533\u8bf7-\u5168\u90e8\u4ed8\u6b3e\u5904\u74061\u6821\u9a8c")
    @Test
    public void fullPushPayTest1() {
        this.payApplyId = this.pushAndAuditApply(new BigDecimal[]{BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(1000L)});
        this.payBillId = this.pushAndAuditPay(this.payApplyId);
        this.pay(this.payBillId);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId1}, new Long[]{this.payBillId}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.cacheFinArBillId2}, new Long[]{this.payBillId}, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u65b0\u589e\u6536\u6b3e\u5355-\u9000\u6b3e\u9000\u7968\u64cd\u4f5c\u6821\u9a8c")
    @Test
    public void casRecReturnTest1() {
        CasRecBillDataVO casRecBillHeader = CasRecBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setOrg(BaseDataTestProvider.getPlanInitOrg()).setBillNo("AR_018_011-TEST-REC").setPricetaxTotal(BigDecimal.valueOf(4000L));
        ArrayList<CasRecBillDataDetailVO> entries = new ArrayList<CasRecBillDataDetailVO>(16);
        CasRecBillDataDetailVO detailVO = new CasRecBillDataDetailVO();
        detailVO.setPriceTaxTotal(BigDecimal.valueOf(4000L));
        entries.add(detailVO);
        DynamicObject casRecBill = CasRecBillTestDataProvider.buildByEntryPriceTaxTotal(casRecBillHeader, entries);
        casRecBill.set("payertype", (Object)"bd_customer");
        casRecBill.set("customerf7", (Object)BaseDataTestProvider.getCustomer());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        this.casRecBillId = casRecBill.getLong("id");
        SimulatorTestHelper util = new SimulatorTestHelper(this);
        this.getModel().setValue("id", (Object)this.payBillId, 0);
        this.getModel().setValue("targetbilltype", (Object)"cas_paybill", 0);
        this.getModel().setValue("sourcebilltype", (Object)"ap_payapply", 0);
        this.getModel().setValue("billtype", (Object)"cas_paybill", 0);
        this.getView().getFormShowParameter().setCustomParam("billId", (Object)this.casRecBillId);
        String selectOne = "[{\"key\":\"entryentity\",\"methodName\":\"entryRowClick\",\"args\":[0],\"postData\":[{\"entryentity\":{\"fieldKey\":\"payee\",\"row\":0,\"selRows\":[0],\"isClientNewRow\":false,\"clientNewRows\":\"\",\"selDatas\":[]}},[]]}]";
        util.invokeAction(selectOne);
        try {
            this.getView().invokeOperation("returnmoney");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId1}, new Long[]{this.payBillId}, true);
        SettleRecordTestChecker.checkNotExist(new Long[]{this.cacheFinArBillId2}, new Long[]{this.payBillId}, true);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{this.payBillId}, new Long[]{this.casRecBillId}, false);
    }

    private long pushAndAuditPay(long payApplyId) {
        List<DynamicObject> payBillList = BOTPHelper.push("ap_payapply", "cas_paybill", "670682874575363072", Collections.singletonList(payApplyId));
        KDAssert.assertTrue((payBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject payBill = payBillList.get(0);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])new DynamicObject[]{payBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        payBill = BusinessDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)"cas_paybill");
        payBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payBill});
        return payBill.getLong("id");
    }

    private void pay(long payBillId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
    }

    private long pushAndAuditApply(BigDecimal[] entryAmtArray) {
        List<DynamicObject> payApplyList = BOTPHelper.push("ar_finarbill", "ap_payapply", "753390670084846592", Arrays.asList(this.cacheFinArBillId1, this.cacheFinArBillId2));
        KDAssert.assertTrue((payApplyList.size() == 1 ? 1 : 0) != 0);
        DynamicObject payApplyBill = payApplyList.get(0);
        PayApplyBillTestHelper.setEntryAmt(payApplyBill, entryAmtArray);
        DynamicObject payType = BaseDataTestProvider.getPaymentType();
        for (DynamicObject payEntryRow : payApplyBill.getDynamicObjectCollection("entry")) {
            payEntryRow.set("e_paymenttype", (Object)payType);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (DynamicObject[])new DynamicObject[]{payApplyBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        payApplyBill = BusinessDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)"ap_payapply");
        payApplyBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payApplyBill});
        return payApplyBill.getLong("id");
    }
}

