/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.arfin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR018_014_FinArToLiquidationTest
extends AbstractJUnitTestPlugIn {
    private static String finArBillNo_1 = "AR018_014_FinArBillNo_01";
    private static String finArBillNo_2 = "AR018_014_FinArBillNo_02";

    public void initData() {
        super.initData();
        FinArBillTestHelper.deleteBill("ar_finarbill", finArBillNo_1, finArBillNo_2);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u6708\u672b\u6e05\u7406\u5355\u5355\u5143\u6d4b\u8bd5")
    @Test
    public void case1() {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObject finarBillInfo_1 = FinArBillTestHelper.createFinArBill(finArBillNo_1, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_1 = finarBillInfo_1.getLong("id");
        idList.add(finArBillId_1);
        DynamicObject finarBillInfo_2 = FinArBillTestHelper.createFinArBill(finArBillNo_2, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), true, true);
        Long finArBillId_2 = finarBillInfo_2.getLong("id");
        idList.add(finArBillId_2);
        DynamicObject liquidationInfo = this.pushLiquidation(finArBillId_1, finArBillId_2, idList);
        liquidationInfo = this.auditLiquidation(finArBillId_1, finArBillId_2, idList, liquidationInfo);
        liquidationInfo = this.unAuditLiquidation(finArBillId_1, finArBillId_2, liquidationInfo);
        this.invalidLiquidation(finArBillId_1, finArBillId_2, liquidationInfo);
    }

    public void invalidLiquidation(Long finArBillId_1, Long finArBillId_2, DynamicObject liquidationInfo) {
        OperationResult invalidResult = OperationServiceHelper.executeOperate((String)"invalid", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_014_FinArToLiquidationTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u4f5c\u5e9f\u5931\u8d25\u3002\u539f\u56e0\uff1a" + invalidResult.getMessage()), (boolean)true, (boolean)invalidResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = billInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = billInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = billInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = billInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    public DynamicObject unAuditLiquidation(Long finArBillId_1, Long finArBillId_2, DynamicObject liquidationInfo) {
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_014_FinArToLiquidationTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unAuditResult.getMessage()), (boolean)true, (boolean)unAuditResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = billInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = billInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = billInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = billInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        return liquidationInfo;
    }

    public DynamicObject auditLiquidation(Long finArBillId_1, Long finArBillId_2, List<Long> idList, DynamicObject liquidationInfo) {
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_014_FinArToLiquidationTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = billInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(0)).getLong("id"), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_1, ((DynamicObject)detailEntryCol_1.get(1)).getLong("id"), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = billInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = billInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(0)).getLong("id"), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.checkSettleAmt(false, true, idList, finArBillId_2, ((DynamicObject)detailEntryCol_2.get(1)).getLong("id"), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = billInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L));
        return liquidationInfo;
    }

    public DynamicObject pushLiquidation(Long finArBillId_1, Long finArBillId_2, List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "ar_liquidation", "736793960093102080", idList);
        DynamicObject liquidationInfo = list.get(0);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_liquidation", (DynamicObject[])new DynamicObject[]{liquidationInfo}, (OperateOption)OperateOption.create());
        AR018_014_FinArToLiquidationTest.assertEquals((String)("\u6708\u672b\u6e05\u7406\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        DynamicObject billInfo_1 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_1, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_1 = billInfo_1.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_1.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_1 = billInfo_1.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_1.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject billInfo_2 = BusinessDataServiceHelper.loadSingle((Object)finArBillId_2, (String)"ar_finarbill");
        DynamicObjectCollection detailEntryCol_2 = billInfo_2.getDynamicObjectCollection("entry");
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(0), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        FinArBillTestChecker.checkArDetailAmt((DynamicObject)detailEntryCol_2.get(1), BigDecimal.valueOf(400L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L));
        DynamicObjectCollection planEntryCol_2 = billInfo_2.getDynamicObjectCollection("planentity");
        FinArBillTestChecker.checkArPlanAmt((DynamicObject)planEntryCol_2.get(0), BigDecimal.valueOf(800L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(0L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        return liquidationInfo;
    }
}

