/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP018_013_BusApBill2FinApBillAllVeirfyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6-\u6682\u4f30\u5e94\u4ed8\u5355\u90e8\u5206\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase1() throws InterruptedException {
        this.busApBillStratProcess(false, false);
        this.busApBillStratProcess(false, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6-\u6682\u4f30\u5e94\u4ed8\u5355\u90e8\u5206\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase2() throws InterruptedException {
        this.busApBillStratProcess(true, false);
        this.busApBillStratProcess(true, true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6-\u6682\u4f30\u5e94\u4ed8\u5355\u90e8\u5206\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase3() throws InterruptedException {
        this.woffOfUSD(false);
        this.woffOfUSD(true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AP018_013_BusApBill2FinApBillAllVeirfyTest.assertEquals((int)1, (int)1);
    }

    private void busApBillStratProcess(boolean isAmtBenchMark, boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busApBillNo1 = isAmtBenchMark ? "AP018_013_Case2_BusApBillNo1" : "AP018_013_Case1_BusApBillNo1";
        String busApBillNo2 = isAmtBenchMark ? "AP018_013_Case2_BusApBillNo2" : "AP018_013_Case1_BusApBillNo2";
        this.deleteBill(busApBillNo1);
        this.deleteBill(busApBillNo2);
        DynamicObject busApBill1 = BusBillTestHelper.getAuditBusApBill(busApBillNo1, isAmtBenchMark, false, new BigDecimal[]{isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)});
        DynamicObject busApBill2 = BusBillTestHelper.getAuditBusApBill(busApBillNo2, isAmtBenchMark, false, new BigDecimal[]{isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L)}, new BigDecimal[]{BigDecimal.valueOf(20L)});
        long busApBillId1 = busApBill1.getLong("id");
        long busApBillId2 = busApBill2.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("ap_busbill", Arrays.asList(busApBillId1, busApBillId2), "B", "AP" + DBServiceHelper.genGlobalLongId(), BigDecimal.ONE);
        ArrayList<Object> finApIds = new ArrayList<Object>(2);
        for (DynamicObject finApBill : finApBills) {
            finApIds.add(finApBill.getLong("id"));
            DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
            entry.forEach(row -> row.set("e_isallverify", (Object)Boolean.TRUE));
        }
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", finApBills);
        this.finApBillAuditCheckBusApBill(busApBillId1, busApBillId2);
        this.busApWoffBillCheck(busApBillId1, busApBillId2, finApIds, isAmtBenchMark);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", finApIds.toArray());
        this.finApBillUnAuditCheckBusApBill(busApBillId1, busApBillId2, isAmtBenchMark);
        boolean exist1 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "in", finApIds)});
        boolean exist2 = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "in", finApIds)});
        AP018_013_BusApBill2FinApBillAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busApBill1.getString("billno") + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist1);
        AP018_013_BusApBill2FinApBillAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busApBill2.getString("billno") + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist2);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", finApIds.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId1, busApBillId2});
    }

    private void woffOfUSD(boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busApBillNo = "AP018_013_Case3_BusApBillNo";
        this.deleteBill(busApBillNo);
        DynamicObject busApBill = BusBillTestHelper.getAuditBusApBill(busApBillNo, false, true, new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)});
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "B", "AP" + DBServiceHelper.genGlobalLongId(), BigDecimal.valueOf(6.5));
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        ((DynamicObject)finApBill.getDynamicObjectCollection("detailentry").get(0)).set("e_isallverify", (Object)Boolean.TRUE);
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new DynamicObject[]{finApBill});
        busApBill = BusinessDataServiceHelper.loadSingle((Object)busApBillId, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busApBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busApBill);
        DynamicObject woffBill = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
        BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
        BusBillTestChecker.headCheck(woffBill);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        boolean exist = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId)), new QFilter("srcfinbillid", "=", (Object)finApBillId)});
        AP018_013_BusApBill2FinApBillAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busApBill.getString("billno") + "\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
    }

    private void finApBillAuditCheckBusApBill(long busApBillId1, long busApBillId2) {
        DynamicObject busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        DynamicObject busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busApBill1);
        BusBillTestChecker.headCheck(busApBill2);
    }

    private void finApBillUnAuditCheckBusApBill(long busApBillId1, long busApBillId2, boolean isAmtBenchMark) {
        DynamicObject busApBill1 = BusinessDataServiceHelper.loadSingle((Object)busApBillId1, (String)"ap_busbill");
        DynamicObject busApBill2 = BusinessDataServiceHelper.loadSingle((Object)busApBillId2, (String)"ap_busbill");
        if (isAmtBenchMark) {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.ONE, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.ONE, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 0);
        } else {
            BusBillTestChecker.entryCheckByWoff(busApBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busApBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 0);
        }
        BusBillTestChecker.headCheck(busApBill1);
        BusBillTestChecker.headCheck(busApBill2);
    }

    private void busApWoffBillCheck(long busApBillId1, long busApBillId2, List<Object> finApIds, boolean isAmtBenchMark) {
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId1)), new QFilter("srcfinbillid", "in", finApIds)});
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busApBillId2)), new QFilter("srcfinbillid", "in", finApIds)});
        if (isAmtBenchMark) {
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 0);
        } else {
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 0);
        }
        BusBillTestChecker.headCheck(woffBill1);
        BusBillTestChecker.headCheck(woffBill2);
    }

    private void deleteBill(String billNo) {
        boolean exists = QueryServiceHelper.exists((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)"ap_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
    }
}

