/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.junit.Test;

public class AR020_001_BusArBillManualWoffTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u5168\u989d\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase1() {
        this.deleteBill("AP020_001_Case1_busArBillNo");
        this.deleteBill("AP020_001_Case1_AllWoffBillNo");
        String busArBillNo = "AP020_001_Case1_busArBillNo";
        String busArAllWoffBillNo = "AP020_001_Case1_AllWoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo, false, false, qtys, prices);
        long busArBillId = busArBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusArBill(null, "ar_busbill", Collections.singletonList(busArBillId), "C", busArAllWoffBillNo, "697561685841434624")[0];
        long woffBillId = woffBill.getLong("id");
        this.case1Check(busArBillId, woffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{woffBillId});
        this.case1Check(busArBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u90e8\u5206\u51b2\u56de\u540e\u51b2\u56de\u5355\u518d\u6b21\u5168\u989d\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase2() {
        String busArBillNo = "AP020_001_Case2_busArBillNo";
        String busArAllWoffBillNo = "AP020_002_Case2_PartWoffBillNo";
        String writeWoffBillNo = "AP020_002_Case2_WriWoffBillNo";
        this.deleteBill(busArBillNo);
        this.deleteBill(busArAllWoffBillNo);
        this.deleteBill(writeWoffBillNo);
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo, false, false, qtys, prices);
        long busArBillId = busArBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusArBill(BigDecimal.valueOf(999999L), "ar_busbill", Collections.singletonList(busArBillId), "C", busArAllWoffBillNo, "697561685841434624")[0];
        long woffBillId = woffBill.getLong("id");
        DynamicObject writeWoffBill = BusBillTestHelper.pushBusArBill(null, "ar_busbill", Collections.singletonList(woffBillId), "C", writeWoffBillNo, "697561685841434624")[0];
        long writeWoffBillId = writeWoffBill.getLong("id");
        this.case2Check(busArBillId, woffBillId, writeWoffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{writeWoffBillId});
        this.case2Check(busArBillId, woffBillId, writeWoffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{woffBillId});
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId});
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u57fa\u51c6\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase3() {
        this.deleteBill("AP020_001_Case3_busArBillNo");
        this.deleteBill("AP020_001_Case3_WoffBillNo");
        String busArBillNo = "AP020_001_Case3_busArBillNo";
        String busArWoffBillNo = "AP020_001_Case3_WoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo, true, false, qtys, prices);
        long busArBillId = busArBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusArBill(null, "ar_busbill", Collections.singletonList(busArBillId), "C", busArWoffBillNo, "697561685841434624")[0];
        long woffBillId = woffBill.getLong("id");
        this.case3Check(busArBillId, woffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{woffBillId});
        this.case3Check(busArBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6682\u4f30\u5e94\u6536\u5355\u91d1\u989d\u57fa\u51c6\u51b2\u56de\u6d4b\u8bd5")
    @Test
    public void testCase4() {
        this.deleteBill("AP020_001_Case4_busArBillNo");
        this.deleteBill("AP020_001_Case4_WoffBillNo");
        String busArBillNo = "AP020_001_Case4_busArBillNo";
        String busArWoffBillNo = "AP020_001_Case4_WoffBillNo";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo, false, true, qtys, prices);
        long busArBillId = busArBill.getLong("id");
        DynamicObject woffBill = BusBillTestHelper.pushBusArBill(null, "ar_busbill", Collections.singletonList(busArBillId), "C", busArWoffBillNo, "697561685841434624")[0];
        long woffBillId = woffBill.getLong("id");
        this.case4Check(busArBillId, woffBillId, false);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{woffBillId});
        this.case4Check(busArBillId, woffBillId, true);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId});
    }

    private void case4Check(long busArBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busArBill = BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case4_WoffBillNo \u6682\u4f30\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP020_001_Case4_WoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(650L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(2600L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busArBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ar_busbill");
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case4_WoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case4_WoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-2600L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void case3Check(long busArBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busArBill = BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case3_WoffBillNo \u6682\u4f30\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP020_001_Case3_WoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busArBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ar_busbill");
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case3_WoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case3_WoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void case2Check(long busArBillId, long woffBillId, long writeWoffBillId, boolean isWriteWoffBillUnAudit) {
        DynamicObject busArBill = BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
        DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ar_busbill");
        if (isWriteWoffBillUnAudit) {
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)writeWoffBillId)});
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_WriteWoffBillNo \u6682\u4f30\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 1);
            BusBillTestChecker.headCheck(busArBill);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L), 1);
            BusBillTestChecker.headCheck(woffBill);
        } else {
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_PartWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("writeoffbusiness"));
            DynamicObject writeWoffBill = BusinessDataServiceHelper.loadSingle((Object)writeWoffBillId, (String)"ar_busbill");
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 1);
            BusBillTestChecker.headCheck(busArBill);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill);
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_WriteWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_002_Case2_WriteWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), 1);
            BusBillTestChecker.headCheck(writeWoffBill);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill);
        }
    }

    private void case1Check(long busArBillId, long woffBillId, boolean isWoffBillUnAudit) {
        DynamicObject busArBill = BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
        if (isWoffBillUnAudit) {
            boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)woffBillId)});
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case1_AllWoffBillNo \u6682\u4f30\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u81ea\u52a8\u5220\u9664\u5931\u8d25", (boolean)false, (boolean)exists);
            BusBillTestChecker.busBillDeleteJournalCheck("AP020_001_Case1_AllWoffBillNo", false);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busArBill);
            DynamicObject woffBill = BusinessDataServiceHelper.loadSingle((Object)woffBillId, (String)"ar_busbill");
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case1_AllWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill.getBoolean("isadjust"));
            AR020_001_BusArBillManualWoffTest.assertEquals((String)"\u7f16\u53f7\u4e3a\uff1aAP020_001_Case1_AllWoffBillNo\u7684\u6682\u4f30\u5e94\u6536\u5355\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 1);
            BusBillTestChecker.headCheck(woffBill);
            BusBillTestChecker.busBillJournalCheck(woffBill);
        }
    }

    private void deleteBill(String billNo) {
        boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }
}

