/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR020_002_BusArBillAutoWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u591a\u5bf9\u591a--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase1() throws InterruptedException {
        this.busArStratProcess(true, false);
        this.busArStratProcess(false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase2() throws InterruptedException {
        this.amtBenchMarkTest(true);
        this.amtBenchMarkTest(false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u5f02\u5e01\u522b--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355--\u5355\u5230\u51b2\u56de")
    @Test
    public void testCase3() throws InterruptedException {
        this.busArStratProcess(true, true);
        this.busArStratProcess(false, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AR020_002_BusArBillAutoWoffTest.assertEquals((int)1, (int)1);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u9a8c\u8bc1\u6279\u91cf\u5ba1\u6838\u5c11\u51b2\u56de\u7684\u573a\u666f")
    @Test
    public void testCase5() throws InterruptedException {
        String busBillNo = "AR020_002_Case5_BusBillNo1";
        String finBillNo1 = "AR020_002_Case5_FinBillNo1";
        String finBillNo2 = "AR020_002_Case5_FinBillNo2";
        String finBillNo3 = "AR020_002_Case5_FinBillNo3";
        this.deleteBill(busBillNo, "ar_busbill");
        this.deleteBill(finBillNo1, "ar_finarbill");
        this.deleteBill(finBillNo2, "ar_finarbill");
        this.deleteBill(finBillNo3, "ar_finarbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busBill = BusBillTestHelper.getAuditBusArBill(busBillNo, false, false, qtys, prices);
        long busBillId = busBill.getLong("id");
        FinArBillTestHelper.setAR005(BaseDataTestProvider.getDetailInitOrg().getLong("id"), false);
        DynamicObject finArBill1 = FinArBillTestHelper.pushFinArBill("ar_busbill", Collections.singletonList(busBillId), "C", finBillNo1, BigDecimal.ONE)[0];
        long finBillId1 = finArBill1.getLong("id");
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(BigDecimal.ONE), 1);
        BusBillTestChecker.headCheck(busBill);
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId1)});
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L).multiply(BigDecimal.ONE), 1);
        DynamicObject finArBill2 = FinArBillTestHelper.pushFinArBill("ar_busbill", Collections.singletonList(busBillId), "B", finBillNo2, BigDecimal.ONE)[0];
        long finBillId2 = finArBill2.getLong("id");
        DynamicObject finArBill3 = FinArBillTestHelper.fullPushFinArBill("ar_busbill", Collections.singletonList(busBillId), "B", finBillNo3)[0];
        long finBillId3 = finArBill3.getLong("id");
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finBillId2, finBillId3});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.headCheck(busBill);
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId2)});
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-2.5), BigDecimal.valueOf(-25L), BigDecimal.valueOf(-25L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L).multiply(BigDecimal.ONE), 1);
        DynamicObject woffBill3 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busBillId)), new QFilter("srcfinbillid", "=", (Object)finBillId3)});
        BusBillTestChecker.entryCheckByWoff(woffBill3, BigDecimal.valueOf(-2.5), BigDecimal.valueOf(-25L), BigDecimal.valueOf(-25L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill3, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L).multiply(BigDecimal.ONE), 1);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finBillId1, finBillId2, finBillId3});
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L).multiply(BigDecimal.ONE), 0);
        BusBillTestChecker.entryCheckByWoff(busBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L).multiply(BigDecimal.ONE), 1);
        BusBillTestChecker.headCheck(busBill);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", new Object[]{finBillId1, finBillId2, finBillId3});
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busBillId});
    }

    private void busArStratProcess(boolean isNewWoff, boolean isUSD) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
        } else {
            ConfigCache.put("ap_stdconfig", "woffServiceV2", "true");
        }
        String busArBillNo1 = isUSD ? "AR020_002_Case3_busArBillNo1" : "AR020_002_Case1_busArBillNo1";
        String busArBillNo2 = isUSD ? "AR020_002_Case3_busArBillNo2" : "AR020_002_Case1_busArBillNo2";
        String finArBillNo1 = isUSD ? "AR020_002_Case3_finArBillNo1" : "AR020_002_Case1_finArBillNo1";
        String finArBillNo2 = isUSD ? "AR020_002_Case3_finArBillNo2" : "AR020_002_Case1_finArBillNo2";
        this.deleteBill(busArBillNo1, "ar_busbill");
        this.deleteBill(busArBillNo2, "ar_busbill");
        this.deleteBill(finArBillNo1, "ar_finarbill");
        this.deleteBill(finArBillNo2, "ar_finarbill");
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill1 = BusBillTestHelper.getAuditBusArBill(busArBillNo1, false, isUSD, qtys, prices);
        long busArBillId1 = busArBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busArBill2 = BusBillTestHelper.getAuditBusArBill(busArBillNo2, false, isUSD, qtys, prices);
        long busArBillId2 = busArBill2.getLong("id");
        Long[] finArIds1 = FinArBillTestHelper.pushFinArBillIds(BigDecimal.valueOf(999999L), "ar_busbill", Arrays.asList(busArBillId1, busArBillId2), "C", finArBillNo1, exchangeRate);
        this.finArBillAuditCheckbusArBill(busArBillId1, busArBillId2, true, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, finArIds1, false, exchangeRate);
        Long[] finArIds2 = FinArBillTestHelper.pushFinArBillIds(null, "ar_busbill", Arrays.asList(busArBillId1, busArBillId2), "C", finArBillNo2, exchangeRate);
        this.finArBillAuditCheckbusArBill(busArBillId1, busArBillId2, false, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, finArIds2, false, exchangeRate);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", Arrays.stream(finArIds2).toArray());
        this.finArBillUnAuditCheckbusArBill(busArBillId1, busArBillId2, true, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, finArIds2, true, exchangeRate);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", Arrays.stream(finArIds2).toArray());
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", Arrays.stream(finArIds1).toArray());
        this.finArBillUnAuditCheckbusArBill(busArBillId1, busArBillId2, false, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, finArIds1, true, exchangeRate);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", Arrays.stream(finArIds1).toArray());
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
    }

    private void amtBenchMarkTest(boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "woffServiceV2", "false");
        } else {
            ConfigCache.put("ap_stdconfig", "woffServiceV2", "true");
        }
        String busArBillNo1 = "AR020_002_Case2_busArBillNo1";
        String busArBillNo2 = "AR020_002_Case2_busArBillNo2";
        String finArBillNo = "AR020_002_Case2_finArBillNo";
        this.deleteBill(busArBillNo1, "ar_busbill");
        this.deleteBill(busArBillNo2, "ar_busbill");
        this.deleteBill(finArBillNo, "ar_finarbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill1 = BusBillTestHelper.getAuditBusArBill(busArBillNo1, true, false, qtys, prices);
        long busArBillId1 = busArBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(1L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busArBill2 = BusBillTestHelper.getAuditBusArBill(busArBillNo2, true, false, qtys, prices);
        long busArBillId2 = busArBill2.getLong("id");
        Long[] finArIds = FinArBillTestHelper.pushFinArBillIds(null, "ar_busbill", Arrays.asList(busArBillId1, busArBillId2), "C", finArBillNo, BigDecimal.ONE);
        busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 1);
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-30L), BigDecimal.valueOf(-30L), 0);
        BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-40L), BigDecimal.valueOf(-40L), 1);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", Arrays.stream(finArIds).toArray());
        boolean exists1 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        AR020_002_BusArBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
        boolean exists2 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        AR020_002_BusArBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", Arrays.stream(finArIds).toArray());
        busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(1L), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(1L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(1L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), 0);
        BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(1L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), 1);
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
    }

    private void finArBillAuditCheckbusArBill(long busArBillId1, long busArBillId2, boolean isFirstPush, BigDecimal exchangeRate) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        if (isFirstPush) {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(15L), BigDecimal.valueOf(450L), BigDecimal.valueOf(450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L).multiply(exchangeRate), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
    }

    private void finArBillUnAuditCheckbusArBill(long busArBillId1, long busArBillId2, boolean isFirstUnAudit, BigDecimal exchangeRate) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        if (isFirstUnAudit) {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(5L), BigDecimal.valueOf(50L), BigDecimal.valueOf(50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(15L), BigDecimal.valueOf(450L), BigDecimal.valueOf(450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L).multiply(exchangeRate), 1);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
        }
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
    }

    private void checkWoffBill(long busArBillId1, long busArBillId2, Long[] finArIds, boolean isReverse, BigDecimal exchangeRate) {
        if (isReverse) {
            boolean exists1 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
            AR020_002_BusArBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
            boolean exists2 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
            AR020_002_BusArBillAutoWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u5355\u5230\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        } else {
            DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-5L), BigDecimal.valueOf(-50L), BigDecimal.valueOf(-50L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-200L), BigDecimal.valueOf(-200L).multiply(exchangeRate), 1);
            DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-15L), BigDecimal.valueOf(-450L), BigDecimal.valueOf(-450L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-800L), BigDecimal.valueOf(-800L).multiply(exchangeRate), 1);
        }
    }

    private void deleteBill(String billNo, String entityKey) {
        boolean exists = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }
}

