/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR020_003_BusArBillWriteWoffTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u591a\u5bf9\u591a--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.busArStratProcess(true, false, false);
        this.busArStratProcess(false, false, false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6\u591a\u5bf9\u591a--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.busArStratProcess(true, true, false);
        this.busArStratProcess(false, true, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5f02\u5e01\u522b--\u6682\u4f30\u5e94\u6536\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u540e\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        this.busArStratProcess(true, false, true);
        this.busArStratProcess(false, false, true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AR020_003_BusArBillWriteWoffTest.assertEquals((int)1, (int)1);
    }

    private void busArStratProcess(boolean isNewWoff, boolean isAmtBenckMark, boolean isUSD) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busArBillNo1 = "AR020_003_Case1_busArBillNo1";
        String busArBillNo2 = "AR020_003_Case1_busArBillNo2";
        String finArBillNo = "AR020_003_Case1_finArBillNo";
        if (isAmtBenckMark) {
            busArBillNo1 = "AR020_003_Case2_busArBillNo1";
            busArBillNo2 = "AR020_003_Case2_busArBillNo2";
            finArBillNo = "AR020_003_Case2_finArBillNo";
        }
        if (isUSD) {
            busArBillNo1 = "AR020_003_Case3_busArBillNo1";
            busArBillNo2 = "AR020_003_Case3_busArBillNo2";
            finArBillNo = "AR020_003_Case3_finArBillNo";
        }
        this.deleteBill(busArBillNo1);
        this.deleteBill(busArBillNo2);
        this.deleteBill(finArBillNo);
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        BigDecimal[] qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject busArBill1 = BusBillTestHelper.getAuditBusArBill(busArBillNo1, isAmtBenckMark, isUSD, qtys, prices);
        long busArBillId1 = busArBill1.getLong("id");
        qtys = new BigDecimal[]{isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenckMark ? BigDecimal.ONE : BigDecimal.valueOf(40L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(30L), BigDecimal.valueOf(40L)};
        DynamicObject busArBill2 = BusBillTestHelper.getAuditBusArBill(busArBillNo2, isAmtBenckMark, isUSD, qtys, prices);
        long busArBillId2 = busArBill2.getLong("id");
        Object[] finArIds = FinArBillTestHelper.pushFinArBillIds(null, "ar_busbill", Arrays.asList(busArBillId1, busArBillId2), "C", finArBillNo, exchangeRate);
        ArrayList<Long> finArWriteBillIds = new ArrayList<Long>(2);
        for (Long l : finArIds) {
            FinArBillTestHelper.executeWriteOff(l);
            finArWriteBillIds.add(FinArBillTestHelper.getWriteOffBillId(l));
        }
        this.WriteCheckbusArBill(busArBillId1, busArBillId2, false, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, (Long[])finArIds, false, isAmtBenckMark, exchangeRate);
        this.checkWriteWoffBill(busArBillId1, busArBillId2, finArWriteBillIds, false, isAmtBenckMark, exchangeRate);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finArWriteBillIds.toArray());
        this.WriteCheckbusArBill(busArBillId1, busArBillId2, true, isAmtBenckMark, exchangeRate);
        this.checkWoffBill(busArBillId1, busArBillId2, (Long[])finArIds, true, isAmtBenckMark, exchangeRate);
        this.checkWriteWoffBill(busArBillId1, busArBillId2, finArWriteBillIds, true, isAmtBenckMark, exchangeRate);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finArIds);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finArIds);
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
    }

    private void WriteCheckbusArBill(long busArBillId1, long busArBillId2, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        if (isReverse) {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(busArBill1);
            BusBillTestChecker.headCheck(busArBill2);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.entryCheckByWoff(busArBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(40L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(busArBill1);
            BusBillTestChecker.headCheck(busArBill2);
        }
    }

    private void checkWoffBill(long busArBillId1, long busArBillId2, Long[] finArIds, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", (Object)finArIds)});
        if (isReverse) {
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-10L), isAmtBenchMark ? BigDecimal.valueOf(-10L) : BigDecimal.valueOf(-100L), isAmtBenchMark ? BigDecimal.valueOf(-10L) : BigDecimal.valueOf(-100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-20L), isAmtBenchMark ? BigDecimal.valueOf(-20L) : BigDecimal.valueOf(-400L), isAmtBenchMark ? BigDecimal.valueOf(-20L) : BigDecimal.valueOf(-400L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill1);
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)false, (boolean)woffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-30L), isAmtBenchMark ? BigDecimal.valueOf(-30L) : BigDecimal.valueOf(-900L), isAmtBenchMark ? BigDecimal.valueOf(-30L) : BigDecimal.valueOf(-900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, isAmtBenchMark ? BigDecimal.valueOf(-1L) : BigDecimal.valueOf(-40L), isAmtBenchMark ? BigDecimal.valueOf(-40L) : BigDecimal.valueOf(-1600L), isAmtBenchMark ? BigDecimal.valueOf(-40L) : BigDecimal.valueOf(-1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(woffBill2);
        } else {
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill1);
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)woffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            BusBillTestChecker.headCheck(woffBill2);
        }
    }

    private void checkWriteWoffBill(long busArBillId1, long busArBillId2, List<Long> writeOffBillIds, boolean isReverse, boolean isAmtBenchMark, BigDecimal exchangeRate) {
        if (isReverse) {
            boolean exists1 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busArBillId1), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u7684\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u9500\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists1);
            boolean exists2 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busArBillId2), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u8d22\u52a1\u5e94\u6536\u5355\u7684\u51b2\u9500\u5355\u53cd\u5ba1\u6838\u540e\u672a\u81ea\u52a8\u5220\u9664\u51b2\u9500\u51b2\u56de\u5355\u3002", (boolean)false, (boolean)exists2);
        } else {
            DynamicObject writeWoffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busArBillId1), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill1.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill1.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(10L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L), isAmtBenchMark ? BigDecimal.valueOf(10L) : BigDecimal.valueOf(100L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill1, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(20L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L), isAmtBenchMark ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(400L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(writeWoffBill1);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill1);
            DynamicObject writeWoffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)BaseDataTestProvider.getDetailInitOrg().getLong("id")), new QFilter("mostsrcbusbillid", "=", (Object)busArBillId2), new QFilter("srcfinbillid", "in", writeOffBillIds)});
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u56de\u5355\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill2.getBoolean("isadjust"));
            AR020_003_BusArBillWriteWoffTest.assertEquals((String)"\u51b2\u9500\u51b2\u56de\u5355\u8868\u5934\u51b2\u9500\u4e1a\u52a1\u6807\u8bc6\u6709\u8bef", (boolean)true, (boolean)writeWoffBill2.getBoolean("writeoffbusiness"));
            BusBillTestChecker.entryCheckByWoff(writeWoffBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(30L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L), isAmtBenchMark ? BigDecimal.valueOf(30L) : BigDecimal.valueOf(900L).multiply(exchangeRate), 0);
            BusBillTestChecker.entryCheckByWoff(writeWoffBill2, isAmtBenchMark ? BigDecimal.ONE : BigDecimal.valueOf(40L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L), isAmtBenchMark ? BigDecimal.valueOf(40L) : BigDecimal.valueOf(1600L).multiply(exchangeRate), 1);
            BusBillTestChecker.headCheck(writeWoffBill2);
            BusBillTestChecker.busBillJournalCheck(writeWoffBill2);
        }
    }

    private void deleteBill(String billNo) {
        boolean exists = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }
}

