/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.list.IListView;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SimulatorTestHelper;
import org.junit.Test;

public class AR020_017_BusArBill2RevCfmBillTest
extends AbstractJUnitTestPlugIn {
    private IListView listView = null;
    private SimulatorTestHelper util = new SimulatorTestHelper(this);
    private long orgId;

    public void initData() {
        super.initData();
        this.listView = (IListView)this.getView();
        this.orgId = BaseDataTestProvider.getUnInitOrg().getLong("id");
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6b63\u8d1f\u5206\u5f55\uff1a\u6682\u4f30\u5e94\u6536\u5355--\u6536\u5165\u786e\u8ba4\u5355")
    @Test
    public void testCase3() {
        IFormView busBillView1 = BusBillTestHelper.getQtyBenchmarkBusArBillViewBy2row(this.listView, this.util, this.orgId);
        IFormView busBillView2 = BusBillTestHelper.getQtyBenchmarkBusArBillViewBy2row(this.listView, this.util, this.orgId);
        DynamicObject busBill1 = busBillView1.getModel().getDataEntity(true);
        DynamicObject busBill2 = busBillView2.getModel().getDataEntity(true);
        List<Long> busBillIds = Arrays.asList(busBill1.getLong("id"), busBill2.getLong("id"));
        List<DynamicObject> revCfmBills1 = BOTPHelper.push("ar_busbill", "ar_revcfmbill", busBillIds);
        for (DynamicObject revCfmBill1 : revCfmBills1) {
            revCfmBill1.set("confirmrate", (Object)new BigDecimal(50));
            int precision = revCfmBill1.getDynamicObject("currency").getInt("amtprecision");
            DynamicObjectCollection entry = revCfmBill1.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal confirmamt = row.getBigDecimal("e_confirmamt");
                row.set("e_confirmamt", (Object)confirmamt.divide(BigDecimal.valueOf(2L)).setScale(precision));
            }
        }
        BusBillTestHelper.executeOperation("save", "ar_revcfmbill", revCfmBills1.toArray(new DynamicObject[0]));
        busBillView1.invokeOperation("refresh");
        busBillView2.invokeOperation("refresh");
        busBill1 = busBillView1.getModel().getDataEntity(true);
        busBill2 = busBillView2.getModel().getDataEntity(true);
        BusBillTestChecker.confirmAmtCheck(busBill1, new BigDecimal(50), new BigDecimal(50), 0);
        BusBillTestChecker.confirmAmtCheck(busBill1, new BigDecimal(-25), new BigDecimal(-25), 1);
        BusBillTestChecker.confirmAmtCheck(busBill2, new BigDecimal(50), new BigDecimal(50), 0);
        BusBillTestChecker.confirmAmtCheck(busBill2, new BigDecimal(-25), new BigDecimal(-25), 1);
        List<DynamicObject> revCfmBills2 = BOTPHelper.push("ar_busbill", "ar_revcfmbill", busBillIds);
        for (DynamicObject revCfmBill : revCfmBills2) {
            revCfmBill.set("confirmway", (Object)"AMOUNT");
        }
        BusBillTestHelper.executeOperation("save", "ar_revcfmbill", revCfmBills2.toArray(new DynamicObject[0]));
        busBillView1.invokeOperation("refresh");
        busBillView2.invokeOperation("refresh");
        busBill1 = busBillView1.getModel().getDataEntity(true);
        busBill2 = busBillView2.getModel().getDataEntity(true);
        BusBillTestChecker.confirmAmtCheck(busBill1, BigDecimal.ZERO, new BigDecimal(100), 0);
        BusBillTestChecker.confirmAmtCheck(busBill1, BigDecimal.ZERO, new BigDecimal(-50), 1);
        BusBillTestChecker.confirmAmtCheck(busBill2, BigDecimal.ZERO, new BigDecimal(100), 0);
        BusBillTestChecker.confirmAmtCheck(busBill2, BigDecimal.ZERO, new BigDecimal(-50), 1);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u7b97\u6cd5\u5c3e\u5dee\u6570\u636e")
    @Test
    public void testCase4() {
        IFormView busBillView1 = BusBillTestHelper.getQtyBenchmarkTailDiffData(this.listView, this.util, this.orgId);
        DynamicObject busBill1 = busBillView1.getModel().getDataEntity(true);
        List<Long> busBillIds = Collections.singletonList(busBill1.getLong("id"));
        List<DynamicObject> revCfmBills1 = BOTPHelper.push("ar_busbill", "ar_revcfmbill", busBillIds);
        BusBillTestHelper.executeOperation("save", "ar_revcfmbill", revCfmBills1.toArray(new DynamicObject[0]));
        for (DynamicObject revCfmBill1 : revCfmBills1) {
            DynamicObjectCollection entry = revCfmBill1.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal confirmamt = row.getBigDecimal("e_confirmamt");
                BigDecimal confirmtax = row.getBigDecimal("e_confirmtax");
                BigDecimal cfmpricetax = row.getBigDecimal("e_cfmpricetax");
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill1.getString("billno") + "\u7b2c" + (row.getInt("seq") + 1) + "\u884c\u5206\u5f55\u786e\u8ba4\u91d1\u989d\u8ba1\u7b97\u9519\u8bef"), (int)confirmamt.compareTo(new BigDecimal("88.5")), (int)0);
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill1.getString("billno") + "\u7b2c" + (row.getInt("seq") + 1) + "\u884c\u5206\u5f55\u786e\u8ba4\u7a0e\u989d\u8ba1\u7b97\u9519\u8bef"), (int)confirmtax.compareTo(new BigDecimal("11.5")), (int)0);
                KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + revCfmBill1.getString("billno") + "\u7b2c" + (row.getInt("seq") + 1) + "\u884c\u5206\u5f55\u786e\u8ba4\u4ef7\u7a0e\u5408\u8ba1\u8ba1\u7b97\u9519\u8bef"), (int)cfmpricetax.compareTo(new BigDecimal("100")), (int)0);
            }
        }
    }
}

