/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.busar;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import org.junit.Test;

public class AR020_018_BusArBilltoFinArAllVeirfyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    private long orgId;

    public void initData() {
        super.initData();
        this.orgId = BaseDataTestProvider.getDetailInitOrg().getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\uff1a\u6682\u4f30\u5e94\u6536\u5355-\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u5b8c\u5168\u6838\u9500\u4e3atrue")
    @Test
    public void testCase1() throws InterruptedException {
        this.busArBillStartProcess(false, false);
        this.busArBillStartProcess(false, true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91d1\u989d\u57fa\u51c6\uff1a\u6682\u4f30\u5e94\u6536\u5355-\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u5b8c\u5168\u6838\u9500\u4e3atrue")
    @Test
    public void testCase2() throws InterruptedException {
        this.busArBillStartProcess(true, false);
        this.busArBillStartProcess(true, true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6570\u91cf\u57fa\u51c6\u5f02\u5e01\u522b\uff1a\u6682\u4f30\u5e94\u6536\u5355-\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u5b8c\u5168\u6838\u9500\u4e3atrue")
    @Test
    public void testCase3() throws InterruptedException {
        this.woffOfUSD(false);
        this.woffOfUSD(true);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6e05\u9664StdConfig\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase4() {
        ConfigCache.clear();
        AR020_018_BusArBilltoFinArAllVeirfyTest.assertEquals((int)1, (int)1);
    }

    private void busArBillStartProcess(boolean isAmtBenchMark, boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busArBillNo1 = isAmtBenchMark ? "AR020_018_Case3_busArBillNo1" : "AR020_018_Case1_busArBillNo1";
        String busArBillNo2 = isAmtBenchMark ? "AR020_018_Case3_busArBillNo2" : "AR020_018_Case1_busArBillNo2";
        BigDecimal[] qtys = isAmtBenchMark ? new BigDecimal[]{BigDecimal.ONE} : new BigDecimal[]{BigDecimal.valueOf(10L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L)};
        DynamicObject busArBill1 = BusBillTestHelper.getAuditBusArBill(busArBillNo1, isAmtBenchMark, false, qtys, prices);
        long busArBillId1 = busArBill1.getLong("id");
        qtys = isAmtBenchMark ? new BigDecimal[]{BigDecimal.ONE} : new BigDecimal[]{BigDecimal.valueOf(20L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(20L)};
        DynamicObject busArBill2 = BusBillTestHelper.getAuditBusArBill(busArBillNo2, isAmtBenchMark, false, qtys, prices);
        long busArBillId2 = busArBill2.getLong("id");
        List<DynamicObject> finArBills = BOTPHelper.push("ar_busbill", "ar_finarbill", "674365182167762944", Arrays.asList(busArBillId1, busArBillId2));
        ArrayList<Long> finArBillIds = new ArrayList<Long>(2);
        for (DynamicObject finArBill : finArBills) {
            finArBillIds.add(finArBill.getLong("id"));
            DynamicObjectCollection entry = finArBill.getDynamicObjectCollection("entry");
            entry.forEach(row -> row.set("e_isallverify", (Object)Boolean.TRUE));
            if (isAmtBenchMark) {
                FinArBillTestHelper.setFinArDetailEntry((DynamicObject)entry.get(0), BigDecimal.valueOf(1L));
            } else {
                FinArBillTestHelper.setFinArDetailEntry((DynamicObject)entry.get(0), BigDecimal.valueOf(5L));
            }
            FinArBillTestHelper.recHeadAmt(finArBill);
        }
        BusBillTestHelper.executeOperation("save", "ar_finarbill", finArBills.toArray(new DynamicObject[0]));
        BusBillTestHelper.executeOperation("submit", "ar_finarbill", finArBillIds.toArray());
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", finArBillIds.toArray());
        Thread.sleep(20000L);
        this.finArBillAuditCheckBusArBill(busArBillId1, busArBillId2);
        this.busArWoffBillCheck(busArBillId1, busArBillId2, finArBillIds, isAmtBenchMark);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", finArBillIds.toArray());
        Thread.sleep(20000L);
        this.finArBillUnAuditCheckBusArBill(busArBillId1, busArBillId2, isAmtBenchMark);
        boolean exist1 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", finArBillIds)});
        boolean exist2 = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", finArBillIds)});
        AR020_018_BusArBilltoFinArAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busArBill1.getString("billno") + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist1);
        AR020_018_BusArBilltoFinArAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busArBill2.getString("billno") + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist2);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", finArBillIds.toArray());
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId1, busArBillId2});
    }

    private void woffOfUSD(boolean isNewWoff) throws InterruptedException {
        if (isNewWoff) {
            ConfigCache.put("ap_stdconfig", "newWoffService", "true");
        } else {
            ConfigCache.put("ap_stdconfig", "newWoffService", "false");
        }
        String busArBillNo1 = "AR020_018_Case1_busArBillNo1";
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo1, false, true, qtys, prices);
        long busArBillId = busArBill.getLong("id");
        List<DynamicObject> finArBills = BOTPHelper.push("ar_busbill", "ar_finarbill", "674365182167762944", Collections.singletonList(busArBillId));
        DynamicObject finArBill = finArBills.get(0);
        long finArBillId = finArBill.getLong("id");
        DynamicObjectCollection entry = finArBill.getDynamicObjectCollection("entry");
        ((DynamicObject)entry.get(0)).set("e_isallverify", (Object)Boolean.TRUE);
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)entry.get(0), BigDecimal.valueOf(5L));
        FinArBillTestHelper.recHeadAmt(finArBill);
        BusBillTestHelper.executeOperation("save", "ar_finarbill", new DynamicObject[]{finArBill});
        BusBillTestHelper.executeOperation("submit", "ar_finarbill", new Object[]{finArBillId});
        BusBillTestHelper.executeOperation("audit", "ar_finarbill", new Object[]{finArBillId});
        busArBill = BusinessDataServiceHelper.loadSingle((Object)busArBillId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busArBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busArBill);
        DynamicObject woffBill = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId)), new QFilter("srcfinbillid", "=", (Object)finArBillId)});
        BusBillTestChecker.entryCheckByWoff(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
        BusBillTestChecker.entryCheckByInvoice(woffBill, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-650L), 0);
        BusBillTestChecker.headCheck(woffBill);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ar_finarbill", new Object[]{finArBillId});
        boolean exist = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId)), new QFilter("srcfinbillid", "=", (Object)finArBillId)});
        AR020_018_BusArBilltoFinArAllVeirfyTest.assertEquals((String)("\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + busArBill.getString("billno") + "\u7684\u6682\u4f30\u5e94\u6536\u5355\u7684\u51b2\u56de\u5355\u672a\u5220\u9664"), (boolean)false, (boolean)exist);
        BusBillTestHelper.executeOperation("delete", "ar_finarbill", new Object[]{finArBillId});
        BusBillTestHelper.executeOperation("unaudit", "ar_busbill", new Object[]{busArBillId});
        BusBillTestHelper.executeOperation("delete", "ar_busbill", new Object[]{busArBillId});
    }

    private void finArBillAuditCheckBusArBill(long busArBillId1, long busArBillId2) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
    }

    private void finArBillUnAuditCheckBusArBill(long busArBillId1, long busArBillId2, boolean isAmtBenchMark) {
        DynamicObject busArBill1 = BusinessDataServiceHelper.loadSingle((Object)busArBillId1, (String)"ar_busbill");
        DynamicObject busArBill2 = BusinessDataServiceHelper.loadSingle((Object)busArBillId2, (String)"ar_busbill");
        if (isAmtBenchMark) {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.ONE, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.ONE, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 0);
        } else {
            BusBillTestChecker.entryCheckByWoff(busArBill1, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.valueOf(100L), 0);
            BusBillTestChecker.entryCheckByWoff(busArBill2, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.valueOf(400L), 0);
        }
        BusBillTestChecker.headCheck(busArBill1);
        BusBillTestChecker.headCheck(busArBill2);
    }

    private void busArWoffBillCheck(long busArBillId1, long busArBillId2, List<Long> finArBillIds, boolean isAmtBenchMark) {
        DynamicObject woffBill1 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId1)), new QFilter("srcfinbillid", "in", finArBillIds)});
        DynamicObject woffBill2 = BusinessDataServiceHelper.loadSingleFromCache((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgId), new QFilter("sourcebillid", "=", (Object)String.valueOf(busArBillId2)), new QFilter("srcfinbillid", "in", finArBillIds)});
        if (isAmtBenchMark) {
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill1, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-10L), BigDecimal.valueOf(-10L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill2, BigDecimal.valueOf(-1L), BigDecimal.valueOf(-20L), BigDecimal.valueOf(-20L), 0);
        } else {
            BusBillTestChecker.entryCheckByWoff(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill1, BigDecimal.valueOf(-10L), BigDecimal.valueOf(-100L), BigDecimal.valueOf(-100L), 0);
            BusBillTestChecker.entryCheckByWoff(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 0);
            BusBillTestChecker.entryCheckByInvoice(woffBill2, BigDecimal.valueOf(-20L), BigDecimal.valueOf(-400L), BigDecimal.valueOf(-400L), 0);
        }
        BusBillTestChecker.headCheck(woffBill1);
        BusBillTestChecker.headCheck(woffBill2);
    }
}

