/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.ominbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.OmInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.OmInBillDataTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.OmInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.util.StdConfig;
import org.junit.Test;

public class AP022_002_Omcmplin2BusAp2FinApTest
extends AbstractJUnitTestPlugIn {
    private String omInbillkey = null;

    @TestMethod(value=1)
    @DisplayName(value="\u5168\u5c40\u53c2\u6570\u51c6\u5907")
    @Test
    public void prepare() {
        this.omInbillkey = StdConfig.get("mdcinbillkey");
        if (this.omInbillkey != null) {
            DeleteServiceHelper.delete((String)"ap_stdconfig", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"mdcinbillkey")});
            ConfigCache.clear();
        }
        AP022_002_Omcmplin2BusAp2FinApTest.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u591a\u5bf9\u591a-\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase1() throws InterruptedException {
        this.purInBillStratProcess("AP022_002_im_mdcbill_1", false, false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u591a\u5bf9\u591a-\u59d4\u5916\u5b8c\u5de5\u9000\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase2() throws InterruptedException {
        this.purInBillStratProcess("AP022_002_im_mdcbill_2", true, false);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u591a\u5bf9\u591a-\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355\uff08\u5f02\u5e01\u522b\uff09-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase3() throws InterruptedException {
        this.purInBillStratProcess("AP022_002_im_mdcbill_3", false, true);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6570\u636e\u6062\u590d")
    @Test
    public void finish() {
        if (this.omInbillkey != null) {
            DynamicObject stdConfig = BusinessDataServiceHelper.newDynamicObject((String)"ap_stdconfig");
            stdConfig.set("key", (Object)"mdcinbillkey");
            stdConfig.set("value", (Object)this.omInbillkey);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stdConfig});
        }
        AP022_002_Omcmplin2BusAp2FinApTest.assertEquals((boolean)true, (boolean)true);
    }

    private void purInBillStratProcess(String billNo, boolean isReturn, boolean isUSD) throws InterruptedException {
        OmInBillDataVO omInBillDataVO = OmInBillDataVO.New().setBillStatus("C").setBillEntity("im_mdc_omcmplinbill").setBillNo(billNo);
        if (isUSD) {
            omInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            omInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        }
        if (!isReturn) {
            omInBillDataVO.setBizTypeNumber("WX110");
            omInBillDataVO.setInvSchemeNumber("601");
        } else {
            omInBillDataVO.setBizTypeNumber("WX1101");
            omInBillDataVO.setInvSchemeNumber("601-1");
        }
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        ArrayList<OmInBillDataDetailVO> detailVO1S = new ArrayList<OmInBillDataDetailVO>(2);
        detailVO1S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(10L)).setQuantity(BigDecimal.valueOf(10L).multiply(flag)).setSeq(1));
        detailVO1S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(20L)).setQuantity(BigDecimal.valueOf(20L).multiply(flag)).setSeq(2));
        DynamicObject omInBill1 = OmInBillDataTestDataProvider.buildByEntryPriceAndQty(omInBillDataVO, detailVO1S);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omInBill1});
        omInBill1 = QueryServiceHelper.queryOne((String)"im_mdc_omcmplinbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)omInBill1.getString("billno"))});
        long omInBill1Id = omInBill1.getLong("id");
        ArrayList<OmInBillDataDetailVO> detailVO2S = new ArrayList<OmInBillDataDetailVO>(2);
        detailVO2S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(30L)).setQuantity(BigDecimal.valueOf(30L).multiply(flag)).setSeq(1));
        detailVO2S.add(OmInBillDataDetailVO.New().setPrice(BigDecimal.valueOf(40L)).setQuantity(BigDecimal.valueOf(40L).multiply(flag)).setSeq(2));
        omInBillDataVO.setBillNo(billNo.concat("_t"));
        DynamicObject omInBill2 = OmInBillDataTestDataProvider.buildByEntryPriceAndQty(omInBillDataVO, detailVO2S);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{omInBill2});
        omInBill2 = QueryServiceHelper.queryOne((String)"im_mdc_omcmplinbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)omInBill2.getString("billno"))});
        long omInBill2Id = omInBill2.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_mdc_omcmplinbill", Arrays.asList(omInBill1Id, omInBill2Id), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "C", "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        Thread.sleep(30000L);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        this.finApBillAuditCheck(finApBill1Id, flag);
        this.finApBillAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill1Id, true, flag);
        finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        Thread.sleep(30000L);
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        this.finApBillAuditCheck(finApBill2Id, flag);
        this.finApBillAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill2Id, false, flag);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheck(finApBill2Id, flag);
        this.finApBillUnAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill2Id, true, flag);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheck(finApBill1Id, flag);
        this.finApBillUnAuditCheckOmInBill(omInBill1Id, omInBill2Id, finApBill1Id, false, flag);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
        DeleteServiceHelper.delete((String)"im_mdc_omcmplinbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)omInBill1Id)});
        DeleteServiceHelper.delete((String)"im_mdc_omcmplinbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)omInBill2Id)});
    }

    public void finApBillAuditCheck(long finApBillId, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(20L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(800L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    public void finApBillAuditCheckOmInBill(long omInBill1Id, long omInBill2Id, long finApBillId, boolean isFirst, BigDecimal flag) {
        DynamicObject omInBill1 = BusinessDataServiceHelper.loadSingle((Object)omInBill1Id, (String)"im_mdc_omcmplinbill");
        DynamicObject omInBill2 = BusinessDataServiceHelper.loadSingle((Object)omInBill2Id, (String)"im_mdc_omcmplinbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry1 = omInBill1.getDynamicObjectCollection("billentry");
        DynamicObjectCollection entry2 = omInBill2.getDynamicObjectCollection("billentry");
        DynamicObjectCollection entry3 = finApBill.getDynamicObjectCollection("detailentry");
        if (isFirst) {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill1, finApBill, false);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill2, finApBill, false);
        } else {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(40L).multiply(flag), BigDecimal.valueOf(40L).multiply(flag), 1);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill1Id, ((DynamicObject)entry1.get(0)).getLong("id"), finApBillId, ((DynamicObject)entry3.get(0)).getLong("id"), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), false);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill1Id, ((DynamicObject)entry1.get(1)).getLong("id"), finApBillId, ((DynamicObject)entry3.get(1)).getLong("id"), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), false);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill2Id, ((DynamicObject)entry2.get(0)).getLong("id"), finApBillId, ((DynamicObject)entry3.get(2)).getLong("id"), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), false);
            VerifyRecordTestChecker.verifyRecordCheck(omInBill2Id, ((DynamicObject)entry2.get(1)).getLong("id"), finApBillId, ((DynamicObject)entry3.get(3)).getLong("id"), BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), false);
        }
    }

    private void finApBillUnAuditCheck(long finApBillId, BigDecimal flag) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.ZERO, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.ZERO, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.ZERO, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.ZERO, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(800L).multiply(flag));
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    private void finApBillUnAuditCheckOmInBill(long omInBill1Id, long omInBill2Id, long finApBillId, boolean isFirst, BigDecimal flag) {
        DynamicObject omInBill1 = BusinessDataServiceHelper.loadSingle((Object)omInBill1Id, (String)"im_mdc_omcmplinbill");
        DynamicObject omInBill2 = BusinessDataServiceHelper.loadSingle((Object)omInBill2Id, (String)"im_mdc_omcmplinbill");
        if (isFirst) {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
        } else {
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            OmInBillTestChecker.entryCheckByQty(omInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            OmInBillTestChecker.entryCheckByQty(omInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
        VerifyRecordTestChecker.checkVerifyRecordExists(omInBill1Id, finApBillId, false, false);
        VerifyRecordTestChecker.checkVerifyRecordExists(omInBill2Id, finApBillId, false, false);
    }
}

