/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurInBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP020_022_PurInBill2BusAp2FinApAllVerifyTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355\uff08\u90e8\u5206\u4e0b\u63a8\uff09\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase1() throws InterruptedException {
        this.purInBillStratProcess(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u9000\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355\uff08\u90e8\u5206\u4e0b\u63a8\uff09\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase2() throws InterruptedException {
        this.purInBillStratProcess(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5f02\u5e01\u522b-\u91c7\u8d2d\u5165\u5e93\u5355-\u6682\u4f30\u5e94\u4ed8\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355\uff08\u90e8\u5206\u4e0b\u63a8\uff09\uff0c\u5b8c\u5168\u6838\u9500\u6253\u5f00\u540e\u5ba1\u6838\u8d22\u52a1\u5e94\u4ed8\u5355")
    @Test
    public void testCase3() throws InterruptedException {
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        purInBillDataVO.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purInBillDataVO.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purInBill = PurInBillTestHelper.getAuditStatusPurinBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purInBillDataVO);
        long purInBillId = purInBill.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Collections.singletonList(purInBillId), "APUB" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "B", "AP" + DBServiceHelper.genGlobalLongId(), BigDecimal.valueOf(6.5));
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        entry.forEach(row -> row.set("e_isallverify", (Object)Boolean.TRUE));
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new DynamicObject[]{finApBill});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(5L), 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        VerifyRecordTestChecker.verifyRecordCheck(purInBill, finApBill, false);
        Thread.sleep(40000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
        DeleteServiceHelper.delete((String)"im_purinbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)purInBillId)});
    }

    private void purInBillStratProcess(boolean isReturn) throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{isReturn ? BigDecimal.valueOf(-10L) : BigDecimal.valueOf(10L), isReturn ? BigDecimal.valueOf(-20L) : BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purInBill1 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, new PurInBillDataVO());
        long purInBill1Id = purInBill1.getLong("id");
        qtys = new BigDecimal[]{isReturn ? BigDecimal.valueOf(-15L) : BigDecimal.valueOf(15L), isReturn ? BigDecimal.valueOf(-30L) : BigDecimal.valueOf(30L)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        PurInBillDataVO purInBillDataVO = new PurInBillDataVO();
        if (isReturn) {
            purInBillDataVO.setBizTypeNumber("1101");
            purInBillDataVO.setInvSchemeNumber("1101");
        }
        DynamicObject purInBill2 = PurInBillTestHelper.getAuditStatusPurinBill(qtys, prices, purInBillDataVO);
        long purInBill2Id = purInBill2.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Arrays.asList(purInBill1Id, purInBill2Id), "APUB" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "B", "AP" + DBServiceHelper.genGlobalLongId(), BigDecimal.ONE);
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        entry.forEach(row -> row.set("e_isallverify", (Object)Boolean.TRUE));
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new DynamicObject[]{finApBill});
        Thread.sleep(30000L);
        this.finApBillAuditCheck(finApBillId, isReturn);
        this.finApBillAuditCheckPurInBill(purInBill1Id, purInBill2Id, finApBillId, isReturn);
        Thread.sleep(40000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        Thread.sleep(30000L);
        this.finApBillUnAuditCheck(finApBillId, isReturn);
        this.finApBillUnAuditCheckPurinBill(purInBill1Id, purInBill2Id, finApBillId);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "ap_busbill", new Object[]{busApBillId});
        BusBillTestHelper.executeOperation("delete", "ap_busbill", new Object[]{busApBillId});
        DeleteServiceHelper.delete((String)"im_purinbill", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList(purInBill1Id, purInBill2Id))});
    }

    private void finApBillAuditCheckPurInBill(long purInBill1Id, long purInBill2Id, long finApBillId, boolean isReturn) {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBill2Id, (String)"im_purinbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        VerifyRecordTestChecker.verifyRecordCheck(purInBill1, finApBill, false);
        VerifyRecordTestChecker.verifyRecordCheck(purInBill2, finApBill, false);
    }

    private void finApBillAuditCheck(long finApBillId, boolean isReturn) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    private void finApBillUnAuditCheck(long finApBillId, boolean isReturn) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.ZERO, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.ZERO, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.ZERO, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.ZERO, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag));
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    private void finApBillUnAuditCheckPurinBill(long purInBill1Id, long purInBill2Id, long finApBillId) {
        DynamicObject purInBill1 = BusinessDataServiceHelper.loadSingle((Object)purInBill1Id, (String)"im_purinbill");
        DynamicObject purInBill2 = BusinessDataServiceHelper.loadSingle((Object)purInBill2Id, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBill1Id, finApBillId, false, false);
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBill2Id, finApBillId, false, false);
    }
}

