/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import org.junit.Test;

public class AP025_001_PurOrder2PayApplyTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteApplys = Arrays.asList("AP025_001_payapply_1", "AP025_001_payapply_2");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7(\u7269\u6599\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_001_purOrder_1", false, true, false);
        DynamicObject purOrderBillTwo = PurOrderBillTestDataProvider.createPurOrderBill("AP025_001_purOrder_2", false, false, false);
        long orderOneId = purOrderBillOne.getLong("id");
        long orderTwoId = purOrderBillTwo.getLong("id");
        DynamicObject[] payApplyOne = PayApplyBillTestHelper.pushPayApplyBill("pm_purorderbill", Arrays.asList(orderOneId, orderTwoId), "B", "AP025_001_payapply_1");
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderOneId, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderTwoId, BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(15L), BigDecimal.ZERO);
        PayApplyBillTestHelper.changeApprovedAmt(payApplyOne);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderOneId, BigDecimal.valueOf(2.5), BigDecimal.ZERO, BigDecimal.valueOf(7.5), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderTwoId, BigDecimal.valueOf(2.5), BigDecimal.ZERO, BigDecimal.valueOf(7.5), BigDecimal.ZERO);
        DynamicObject[] payApplyTwo = PayApplyBillTestHelper.fullPushPayApply("pm_purorderbill", Arrays.asList(orderOneId, orderTwoId), "AP025_001_payapply_2");
        long payApplyTwoId = payApplyTwo[0].getLong("id");
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderOneId, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderTwoId, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)"closepay", (String)"ap_payapply", (Object[])new Long[]{payApplyTwoId}, (OperateOption)option);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderOneId, BigDecimal.valueOf(2.5), BigDecimal.ZERO, BigDecimal.valueOf(7.5), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderTwoId, BigDecimal.valueOf(2.5), BigDecimal.ZERO, BigDecimal.valueOf(7.5), BigDecimal.ZERO);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_payapply", (DynamicObject[])payApplyOne, (OperateOption)option);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_payapply", (DynamicObject[])payApplyOne, (OperateOption)option);
        PurOrderBillTestChecker.validatePurOrderPayEntry(orderOneId, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

