/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP025_015_PurOrder2FinAp2WriteOffTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Collections.singletonList("AP025_015_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8->\u51b2\u9500(\u7269\u6599\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_015_purOrder_1", false, true, true);
        DynamicObject purOrderBillTwo = PurOrderBillTestDataProvider.createPurOrderBill("AP025_015_purOrder_2", false, false, true);
        long orderOneId = purOrderBillOne.getLong("id");
        long orderTwoId = purOrderBillTwo.getLong("id");
        DynamicObject[] finApBill = FinApBillTestHelper.fullPushFinApBill("pm_purorderbill", Arrays.asList(orderOneId, orderTwoId), "AP025_015_finApBill_1");
        List<DynamicObject> writeOffBills = BOTPHelper.push("ap_finapbill", "ap_finapbill", "520819751337865216", Collections.singletonList(finApBill[0].getLong("id")));
        OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])writeOffBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        PurOrderBillTestChecker.validatePurOrderApDataByZero(orderOneId);
        PurOrderBillTestChecker.validatePurOrderApDataByZero(orderTwoId);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{writeOffBills.get(0).getLong("id")}, (OperateOption)OperateOption.create());
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderOneId);
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderTwoId);
    }
}

