/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import org.junit.Test;

public class AP025_033_PurOrder2PurIn2Fin2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePurIns = Collections.singletonList("AP025_033_purIn_1");
        DeleteServiceHelper.delete((String)"im_purinbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePurIns)});
        List<String> deleteFinAps = Collections.singletonList("AP025_033_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u91c7\u8d2d\u5165\u5e93->\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u5355(\u8ba1\u5212\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_033_purOrder_1", true, true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject[] purInBills = PurInBillTestHelper.fullPushPruInBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_033_purIn_1");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("im_purinbill", Collections.singletonList(purInBills[0].getLong("id")), "AP025_033_finApBill_1");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_finapbill", Collections.singletonList(finApBills[0].getLong("id")), "AP025_033_payBill_1");
        CasPayBillTestHelper.casPayBillToDelete(payBills, true);
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.ZERO, BigDecimal.ZERO);
    }
}

