/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import org.junit.Test;

public class AP025_077_PurOrder2PayAnd2FinTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Collections.singletonList("AP025_077_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deletePayBills = Collections.singletonList("AP025_077_payBill_1");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        List<String> deleteRecords = Collections.singletonList("AP025_077_finApBill_1");
        DeleteServiceHelper.delete((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteRecords)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u5355 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8(\u8ba1\u5212\u884c)")
    @Test
    public void purOrderUnitTest_001() throws InterruptedException {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_077_purOrder_1", true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        CasPayBillTestHelper.fullPushPayBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_077_payBill_1");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        Thread.sleep(20000L);
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_077_finApBill_1");
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderOneId);
        Thread.sleep(5000L);
        Object[] finApIds = new Long[]{finApBills[0].getLong("id")};
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])finApIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        result = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])finApIds, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        PurOrderBillTestChecker.validatePurOrderApDataByZero(orderOneId);
    }
}

