/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP025_079_PurOrder2Apply2PayAnd2FinTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deleteFinAps = Arrays.asList("AP025_079_finApBill_1", "AP025_079_finApBill_2");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deleteApplys = Arrays.asList("AP025_079_payapply_1", "AP025_079_payapply_2");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Arrays.asList("AP025_079_payBill_1", "AP025_079_payBill_2");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
    }

    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7\u5355->\u4ed8\u6b3e\u5355 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8(\u8ba1\u5212\u884c)")
    @Test
    public void purOrderUnitTest_001() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_079_purOrder_1", true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject[] payApplys = PayApplyBillTestHelper.fullPushPayApply("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_079_payapply_1");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(payApplys[0].getLong("id")), "C", "AP025_079_payBill_1");
        long payBillId = payBills[0].getLong("id");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.ZERO, BigDecimal.ZERO);
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_079_finApBill_1", BigDecimal.valueOf(6.045));
        long finBillId = finApBills[0].getLong("id");
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderOneId);
        OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBillId}, (OperateOption)OperateOption.create());
        this.validateData(orderOneId, finBillId, payBillId);
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])new Long[]{finBillId}, (OperateOption)OperateOption.create());
        FinApBillTestChecker.validateInitialApFin(finBillId);
        DynamicObject casPayBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        CasPayBillTestChecker.validateInitialCasPayBill(casPayBill);
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Long[]{finBillId}, (OperateOption)OperateOption.create());
        PurOrderBillTestChecker.validatePurOrderApDataByZero(orderOneId);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355->\u4ed8\u6b3e\u7533\u8bf7\u5355->\u4ed8\u6b3e\u5355 AND \u91c7\u8d2d\u8ba2\u5355->\u8d22\u52a1\u5e94\u4ed8(\u8ba1\u5212\u884c)-\u63d0\u4ea4\u6001\u7ed3\u7b97")
    @Test
    public void sumbitSettleTest() {
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP025_079_purOrder_2", true, true, true);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject[] payApplys = PayApplyBillTestHelper.fullPushPayApply("pm_purorderbill", Collections.singletonList(orderOneId), "AP025_079_payapply_2");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(payApplys[0].getLong("id")), "C", "AP025_079_payBill_2");
        long payBillId = payBills[0].getLong("id");
        purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(30L), BigDecimal.ZERO);
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.ZERO, BigDecimal.ZERO);
        OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])new Long[]{payBillId}, (OperateOption)OperateOption.create());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ap_016", 1);
        SystemParameterHelper.setSystemParameter(false, (Long)purOrderBillOne.getDynamicObject("org").getPkValue(), paramMap);
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill(null, "pm_purorderbill", Collections.singletonList(orderOneId), "B", "AP025_079_finApBill_2", BigDecimal.valueOf(6.045));
        long finBillId = finApBills[0].getLong("id");
        QFilter filter = new QFilter("mainbillid", "in", (Object)new Long[]{finBillId});
        filter.and(new QFilter("entry.billid", "in", (Object)new Long[]{payBillId}));
        filter.and(new QFilter("billstatus", "=", (Object)"B"));
        KDAssert.assertEquals((boolean)true, (boolean)SettleRecordTestHelper.exists(filter, false));
        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_finapbill", (Object[])new Long[]{finBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(audit);
        this.validateData(orderOneId, finBillId, payBillId);
    }

    private void validateData(long orderOneId, long finId, long payBillId) {
        DynamicObject purOrderBillOne = BusinessDataServiceHelper.loadSingle((Object)orderOneId, (String)"pm_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(purOrderBillOne, BigDecimal.valueOf(40L), BigDecimal.valueOf(40L));
        PurOrderBillTestChecker.validatePurOrderPayEntry(purOrderBillOne, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(30L), BigDecimal.valueOf(30L));
        PurOrderBillTestChecker.validatePurOrderApDataByFull(orderOneId);
        CasPayBillTestChecker.validateFinishCasPayBill(payBillId);
        DynamicObject finBill = BusinessDataServiceHelper.loadSingle((Object)finId, (String)"ap_finapbill");
        AP025_079_PurOrder2Apply2PayAnd2FinTest.assertEquals((String)"\u6e90\u5355\u5e94\u4e3a\u90e8\u5206\u7ed3\u7b97", (String)"partsettle", (String)finBill.getString("settlestatus"));
        FinApBillTestChecker.validateApFinHeadSettleAmt(finBill, BigDecimal.valueOf(60L), BigDecimal.valueOf(362.7), BigDecimal.valueOf(40L), BigDecimal.valueOf(241.8));
        DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finBill.getDynamicObjectCollection("planentity");
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(0), BigDecimal.valueOf(24.0), BigDecimal.valueOf(36.0), BigDecimal.valueOf(24.0), BigDecimal.valueOf(145.08), BigDecimal.valueOf(36.0), BigDecimal.valueOf(217.62));
        FinApBillTestChecker.validateApFinDetailLockAndSettleAmt((DynamicObject)detailEntry.get(1), BigDecimal.valueOf(16.0), BigDecimal.valueOf(24.0), BigDecimal.valueOf(16.0), BigDecimal.valueOf(96.72), BigDecimal.valueOf(24.0), BigDecimal.valueOf(145.08));
        FinApBillTestChecker.validateApFinPlanLockAndSettleAmt((DynamicObject)planEntity.get(0), BigDecimal.valueOf(40.0), BigDecimal.valueOf(60.0), BigDecimal.valueOf(40.0), BigDecimal.valueOf(241.8), BigDecimal.valueOf(60.0), BigDecimal.valueOf(362.7));
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finId}, new Long[]{payBillId}, false);
    }
}

