/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurOrderBillTestHelper;
import org.junit.Test;

public class AP025_088_PurOrder2PurIn2FinApBillVerifyTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355-\u91c7\u8d2d\u5165\u5e93\uff0c\u624b\u5de5\u65b0\u589e\u8d22\u52a1\u5e94\u4ed8\u5355\uff08\u6838\u5fc3\u5355\u636e\u53f7\u4e0e\u8ba2\u5355\u76f8\u540c\uff09-\u6838\u9500\u6d41\u7a0b\u6d4b\u8bd5")
    @Test
    public void testCase1() throws InterruptedException {
        this.purOrderStratProcessTest(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u8ba2\u5355-\u91c7\u8d2d\u5165\u5e93\uff08\u5f02\u5e01\u522b\uff09\uff0c\u624b\u5de5\u65b0\u589e\u8d22\u52a1\u5e94\u4ed8\u5355\uff08\u6838\u5fc3\u5355\u636e\u53f7\u4e0e\u8ba2\u5355\u76f8\u540c\uff09-\u6838\u9500\u6d41\u7a0b\u6d4b\u8bd5")
    @Test
    public void testCase2() throws InterruptedException {
        this.purOrderStratProcessTest(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6e05\u9664StdConfig\u6838\u9500\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase3() {
        ConfigCache.clear();
    }

    private void purOrderStratProcessTest(boolean isUSD) throws InterruptedException {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purOrderBill = PurOrderBillTestHelper.getAuditStatusPurOrderBill(qtys, prices, isUSD, true);
        long purOrderBillId = purOrderBill.getLong("id");
        DynamicObject[] purInBills = PurInBillTestHelper.fullPushPruInBill("pm_purorderbill", Collections.singletonList(purOrderBillId), "CGRK-" + DBServiceHelper.genGlobalLongId());
        DynamicObject purInBill = purInBills[0];
        long purInBillId = purInBill.getLong("id");
        List<DynamicObject> finApBills = BOTPHelper.push("im_purinbill", "ap_finapbill", Collections.singletonList(purInBillId));
        DynamicObject finApBill = this.getCoreVerifyFinApBill(finApBills.get(0));
        long finApBillId = finApBill.getLong("id");
        this.coreBillVerifyCheck(finApBillId, purInBillId, false);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        this.materialDifferentVerify(finApBillId, purInBillId);
        this.coreBillVerifyCheck(finApBillId, purInBillId, true);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purinbill", new Object[]{purInBillId});
        BusBillTestHelper.executeOperation("delete", "im_purinbill", new Object[]{purInBillId});
        BusBillTestHelper.executeOperation("unaudit", "pm_purorderbill", new Object[]{purOrderBillId});
        BusBillTestHelper.executeOperation("delete", "pm_purorderbill", new Object[]{purOrderBillId});
    }

    private DynamicObject getCoreVerifyFinApBill(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject asstact = bill.getDynamicObject("asstact");
        long currency = bill.getLong("currency.id");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
        ArrayList<FinApBillDataDetailVO> detailVOS = new ArrayList<FinApBillDataDetailVO>(2);
        for (DynamicObject row : entry) {
            detailVOS.add(FinApBillDataDetailVO.New().setMaterial(row.getDynamicObject("material")).setSeq(row.getInt("seq")).setQuantity(row.getBigDecimal("quantity")).setPrice(row.getBigDecimal("price")).setCorebillno(row.getString("corebillno")).setCorebillid(row.getLong("corebillid")).setCorebillentryseq(row.getLong("corebillentryseq")));
        }
        FinApBillDataVO dataVO = FinApBillDataVO.New().setBillStatus("C").setCurrency(currency).setExchangerate(exchangeRate).setOrg(org).setSupplier(asstact);
        return FinApBillTestDataProvider.buildByPriceAndQuantity(dataVO, detailVOS);
    }

    private void coreBillVerifyCheck(long finApBillId, long purInBillId, boolean isReverse) {
        if (isReverse) {
            VerifyRecordTestChecker.checkVerifyRecordExists(purInBillId, finApBillId, false, false);
        } else {
            DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
            DynamicObject purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
            DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(400L), BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinHead(finApBill);
            VerifyRecordTestChecker.verifyRecordCheck(purInBill, finApBill, false);
            PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
            PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), 1);
        }
    }

    private void materialDifferentVerify(long finApBillId, long purInBillId) throws InterruptedException {
        ConfigCache.put("ap_stdconfig", "verify.isAsstActMatch", "true");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        rows.forEach(row -> row.set("spectype", (Object)"verifytest"));
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new DynamicObject[]{finApBill});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        this.unVerifyCheck(finApBillId, purInBillId);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        ConfigCache.put("ap_stdconfig", "verify.isAsstActMatch", "false");
        BusBillTestHelper.executeOperation("submit", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("audit", "ap_finapbill", new Object[]{finApBillId});
        this.coreBillVerifyCheck(finApBillId, purInBillId, false);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
    }

    private void unVerifyCheck(long finApBillId, long purInBillId) {
        DynamicObject purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        VerifyRecordTestChecker.checkVerifyRecordExists(purInBillId, finApBillId, false, false);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.ZERO, BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.ZERO, BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(400L));
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }
}

