/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.OmOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.PurOrderBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.OmInBillTestHelper;
import org.junit.Test;

public class AP026_014_OmOrder2OmIn2FinApWriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u7b80\u5355\u59d4\u5916\u8ba2\u5355-\u7b80\u5355\u59d4\u5916\u5165\u5e93\u5355-\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        this.purInBillStratProcess(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u7b80\u5355\u59d4\u5916\u8ba2\u5355-\u7b80\u5355\u59d4\u5916\u5165\u5e93\u5355\uff08\u5f02\u5e01\u522b\uff09-\u8d22\u52a1\u5e94\u4ed8\u5355-\u51b2\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        this.purInBillStratProcess(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6e05\u9664StdConfig\u59d4\u5916\u6838\u9500\u914d\u7f6e\u4fe1\u606f")
    @Test
    public void testCase3() {
        ConfigCache.clear();
    }

    private void purInBillStratProcess(boolean isUSD) throws InterruptedException {
        ConfigCache.put("ap_stdconfig", "mdcinbillkey", "im_mdc_ominbill");
        BigDecimal exchangeRate = isUSD ? BigDecimal.valueOf(6.5) : BigDecimal.ONE;
        PurOrderBillDataVO headVO = PurOrderBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangeRate(exchangeRate).setCurrency(isUSD ? BaseDataTestProvider.getCurrencyUSD().getLong("id") : BaseDataTestProvider.getCurrencyCNY().getLong("id"));
        PurOrderBillDataDetailVO detailVO1 = new PurOrderBillDataDetailVO().setSeq(1).setQuantity(BigDecimal.valueOf(10L)).setPrice(BigDecimal.valueOf(10L)).setLineTypeId(1194150915045641216L);
        PurOrderBillDataDetailVO detailVO2 = new PurOrderBillDataDetailVO().setSeq(2).setQuantity(BigDecimal.valueOf(20L)).setPrice(BigDecimal.valueOf(20L)).setLineTypeId(1194150915045641216L);
        PurOrderBillDataDetailVO detailVO3 = new PurOrderBillDataDetailVO().setSeq(3).setQuantity(BigDecimal.valueOf(30L)).setPrice(BigDecimal.valueOf(30L)).setLineTypeId(1194150915045641216L);
        PurOrderBillDataDetailVO detailVO4 = new PurOrderBillDataDetailVO().setSeq(4).setQuantity(BigDecimal.valueOf(40L)).setPrice(BigDecimal.valueOf(40L)).setLineTypeId(1194150915045641216L);
        DynamicObject omOrderBill = OmOrderBillTestDataProvider.buildByDetailAndHead(headVO, Arrays.asList(detailVO1, detailVO2, detailVO3, detailVO4));
        DynamicObject[] omInBills = OmInBillTestHelper.fullPushOmInBill("pm_om_purorderbill", Collections.singletonList(omOrderBill.getLong("id")), "WWRK-" + DBServiceHelper.genGlobalLongId());
        DynamicObject omInBill = omInBills[0];
        long omInBillId = omInBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.pushFinApBill("im_mdc_ominbill", Collections.singletonList(omInBillId), "C", "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        DynamicObject finApBill1 = finApBills[0];
        long finApBill1Id = finApBill1.getLong("id");
        finApBills = FinApBillTestHelper.fullPushFinApBill("im_mdc_ominbill", Collections.singletonList(omInBillId), "AP-" + DBServiceHelper.genGlobalLongId(), exchangeRate);
        DynamicObject finApBill2 = finApBills[0];
        long finApBill2Id = finApBill2.getLong("id");
        Thread.sleep(20000L);
        DynamicObject writeOffBill1 = FinApBillTestHelper.executeAndGetWriteOffBill(finApBill1Id);
        long writeOffBill1Id = writeOffBill1.getLong("id");
        this.finApBillAuditCheck(finApBill1Id);
        this.writeOffBillCheck(writeOffBill1Id, finApBill1Id);
        DynamicObject writeOffBill2 = FinApBillTestHelper.executeAndGetWriteOffBill(finApBill2Id);
        long writeOffBill2Id = writeOffBill2.getLong("id");
        this.finApBillAuditCheck(finApBill2Id);
        this.writeOffBillCheck(writeOffBill2Id, finApBill2Id);
    }

    public void finApBillAuditCheck(long finApBillId) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(5L), BigDecimal.ZERO, BigDecimal.valueOf(50L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(200L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(15L), BigDecimal.ZERO, BigDecimal.valueOf(450L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(800L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
    }

    public void writeOffBillCheck(long writeOffBillId, long finApBillId) {
        DynamicObject writeOffBill = BusinessDataServiceHelper.loadSingle((Object)writeOffBillId, (String)"ap_finapbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection entry = writeOffBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(0), BigDecimal.valueOf(-5L), BigDecimal.ZERO, BigDecimal.valueOf(-50L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(1), BigDecimal.valueOf(-10L), BigDecimal.ZERO, BigDecimal.valueOf(-200L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(2), BigDecimal.valueOf(-15L), BigDecimal.ZERO, BigDecimal.valueOf(-450L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)entry.get(3), BigDecimal.valueOf(-20L), BigDecimal.ZERO, BigDecimal.valueOf(-800L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(writeOffBill);
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, writeOffBill, false);
    }
}

