/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.unittest.framework.check.CasPayBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SettleRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.OmOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.CasPayBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.OmInBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import org.junit.Test;

public class AP026_017_OmOrder2OmIn2Fin2Apply2PayTest
extends AbstractJUnitTestPlugIn {
    public void initData() {
        super.initData();
        List<String> deletePurIns = Arrays.asList("AP026_017_omIn_1", "AP026_017_omIn_2");
        DeleteServiceHelper.delete((String)"im_mdc_ominbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePurIns)});
        List<String> deleteFinAps = Arrays.asList("AP026_017_finApBill_1", "AP026_017_finApBill_2");
        DeleteServiceHelper.delete((String)"ap_finapbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteFinAps)});
        List<String> deleteApplys = Arrays.asList("AP026_017_payapply_1", "AP026_017_payapply_2");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "in", deleteApplys)});
        List<String> deletePayBills = Arrays.asList("AP026_017_payBill_1", "AP026_017_payBill_2");
        DeleteServiceHelper.delete((String)"cas_paybill", (QFilter[])new QFilter[]{new QFilter("billno", "in", deletePayBills)});
        ConfigCache.put("ap_stdconfig", "mdcinbillkey", "AP026_017_unittest");
        ConfigCache.put("ap_stdconfig", "oldominbillverify", "true");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u7b80\u5355\u59d4\u5916\u8ba2\u5355->\u7b80\u5355\u59d4\u5916\u5165\u5e93\u5355->\u8d22\u52a1\u5e94\u4ed8->\u4ed8\u6b3e\u7533\u8bf7->\u4ed8\u6b3e\u5355(\u7269\u6599\u884c)")
    @Test
    public void omOrderUnitTest_001() {
        DynamicObject omOrderBill = OmOrderBillTestDataProvider.createOmOrderBill("AP026_017_omOrder_1", true, false, false, true);
        DynamicObject[] omInBills = OmInBillTestHelper.fullPushOmInBill("pm_om_purorderbill", Collections.singletonList(omOrderBill.getLong("id")), "AP026_017_omIn_1");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("im_mdc_ominbill", Collections.singletonList(omInBills[0].getLong("id")), "AP026_017_finApBill_1");
        long finApBillId = finApBills[0].getLong("id");
        DynamicObject[] payApplyBills = PayApplyBillTestHelper.fullPushPayApply("ap_finapbill", Collections.singletonList(finApBills[0].getLong("id")), "AP026_017_payapply_1");
        DynamicObject[] payBills = CasPayBillTestHelper.fullPushPayBill("ap_payapply", Collections.singletonList(payApplyBills[0].getLong("id")), "AP026_017_payBill_1");
        long payBillId = payBills[0].getLong("id");
        omOrderBill = BusinessDataServiceHelper.loadSingle((Object)omOrderBill.getLong("id"), (String)"pm_om_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(omOrderBill, BigDecimal.ZERO, BigDecimal.valueOf(100L));
        FinApBillTestChecker.validateFinishApFin(finApBillId, true, true);
        DynamicObject[] records = SettleRecordTestHelper.loadData(new Long[]{finApBillId}, new Long[]{payBillId}, false);
        SettleRecordTestHelper.setIsVoucherToTrue(records);
        OperationResult cancelpay = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])new Object[]{payBillId}, (OperateOption)OperateOption.create());
        AP026_017_OmOrder2OmIn2Fin2Apply2PayTest.assertEquals((String)"\u53d6\u6d88\u4ed8\u6b3e\u81ea\u52a8\u5931\u8d25", (boolean)false, (boolean)cancelpay.isSuccess());
        omOrderBill = BusinessDataServiceHelper.loadSingle((Object)omOrderBill.getLong("id"), (String)"pm_om_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(omOrderBill, BigDecimal.ZERO, BigDecimal.valueOf(100L));
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        CasPayBillTestChecker.validateFinishCasPayBill(payBill);
        AP026_017_OmOrder2OmIn2Fin2Apply2PayTest.assertEquals((String)"\u4ed8\u6b3e\u5355\u5355\u636e\u72b6\u6001\u5f02\u5e38", (String)"D", (String)payBill.getString("billstatus"));
        OperationResult unsettle = OperationServiceHelper.executeOperate((String)"unsettle", (String)"ap_settlerecord", (DynamicObject[])records, (OperateOption)OperateOption.create());
        AP026_017_OmOrder2OmIn2Fin2Apply2PayTest.assertInvokeOperation((OperationResult)unsettle);
        omOrderBill = BusinessDataServiceHelper.loadSingle((Object)omOrderBill.getLong("id"), (String)"pm_om_purorderbill");
        PurOrderBillTestChecker.validatePurOrderHeadAmt(omOrderBill, BigDecimal.ZERO, BigDecimal.ZERO);
        payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        CasPayBillTestChecker.validateInitialCasPayBill(payBill);
        SettleRecordTestChecker.checkSettleAmtAndJournal(new Long[]{finApBillId}, new Long[]{payBillId}, false);
        boolean isExists = SettleRecordTestHelper.existsWriteOff(new Long[]{finApBillId}, new Long[]{payBillId}, false);
        AP026_017_OmOrder2OmIn2Fin2Apply2PayTest.assertEquals((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\u672a\u751f\u6210\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\u3002", (boolean)true, (boolean)isExists);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6e05\u7a7astdConfig\u914d\u7f6e\u7f13\u5b58")
    @Test
    public void omOrderUnitTest_002() {
        ConfigCache.clear();
        AP026_017_OmOrder2OmIn2Fin2Apply2PayTest.assertEquals((boolean)true, (boolean)true);
    }
}

