/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.PurOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PayApplyBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurOrderBillTestHelper;
import org.junit.Test;

public class AP028_001_PaymentSecurity_freeze
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u7269\u6599\u884c\u7ed3\u7b97")
    @Test
    public void testCase1() throws Exception {
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purOrderBill = PurOrderBillTestHelper.getAuditStatusPurOrderBill(qtys, prices, false, true);
        long purOrderBillId = purOrderBill.getLong("id");
        DynamicObject[] purInBills = PurInBillTestHelper.fullPushPruInBill("pm_purorderbill", Collections.singletonList(purOrderBillId), "CGRK-" + DBServiceHelper.genGlobalLongId());
        DynamicObject purInBill = purInBills[0];
        long purInBillId = purInBill.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Collections.singletonList(purInBillId), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "AP-" + DBServiceHelper.genGlobalLongId());
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBillId)});
        String freezeState = ((DynamicObject)apBills.get(0)).getString("freezestate");
        KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"allfreeze", (String)freezeState);
        ArrayList<Long> orderBillIds = new ArrayList<Long>(2);
        orderBillIds.add(purOrderBillId);
        Object[] payBillIds = this.pushPaidPayBill(orderBillIds);
        Thread.sleep(15000L);
        apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBillId)});
        freezeState = ((DynamicObject)apBills.get(0)).getString("freezestate");
        KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"unfreeze", (String)freezeState);
        OperateOption CancelPayOption = OperateOption.create();
        OperationResult CancelPay = OperationServiceHelper.executeOperate((String)"cancelpay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)CancelPayOption);
        OperationHelper.assertResult(CancelPay);
        Thread.sleep(5000L);
        apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBillId)});
        freezeState = ((DynamicObject)apBills.get(0)).getString("freezestate");
        KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"allfreeze", (String)freezeState);
        OperationResult pay = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)CancelPayOption);
        OperationHelper.assertResult(pay);
        Thread.sleep(15000L);
        DynamicObject[] applyBills = PayApplyBillTestHelper.pushPayApplyBill("ap_finapbill", Collections.singletonList(finApBillId), "AP028_001_payapply_1");
        DeleteServiceHelper.delete((String)"ap_payapply", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"AP028_001_payapply_1")});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8ba1\u5212\u884c\u7ed3\u7b97")
    @Test
    public void testCase2() throws Exception {
        String freezeState;
        DynamicObject purOrderBillOne = PurOrderBillTestDataProvider.createPurOrderBill("AP028_001_purOrder_1", true, true, false, true);
        long orderOneId = purOrderBillOne.getLong("id");
        DynamicObject purOrderBill2 = PurOrderBillTestDataProvider.createPurOrderBill("AP028_001_purOrder_2", true, true, false, true);
        long order2Id = purOrderBill2.getLong("id");
        this.pushPaidPayBill(Collections.singletonList(orderOneId));
        ArrayList<Long> purBillIds = new ArrayList<Long>(16);
        purBillIds.add(orderOneId);
        purBillIds.add(order2Id);
        DynamicObject[] purInBills = PurInBillTestHelper.fullPushPruInBill("pm_purorderbill", purBillIds, "CGRK-" + DBServiceHelper.genGlobalLongId());
        DynamicObject purInBill = purInBills[0];
        long purInBillId = purInBill.getLong("id");
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", Collections.singletonList(purInBillId), "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", Collections.singletonList(busApBillId), "AP-" + DBServiceHelper.genGlobalLongId());
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate,planentity.e_freezestate,planentity.plancorebillid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBillId)});
        for (DynamicObject bill : apBills) {
            freezeState = bill.getString("freezestate");
            KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"partfreeze", (String)freezeState);
            long coreBillId = bill.getLong("planentity.plancorebillid");
            String entryFreezeState = bill.getString("planentity.e_freezestate");
            if (orderOneId == coreBillId) {
                KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"unfreeze", (String)entryFreezeState);
                continue;
            }
            KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"allfreeze", (String)entryFreezeState);
        }
        this.pushPaidPayBill(Collections.singletonList(order2Id));
        Thread.sleep(15000L);
        apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,freezestate,planentity.e_freezestate,planentity.plancorebillid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBillId)});
        for (DynamicObject bill : apBills) {
            freezeState = bill.getString("freezestate");
            KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"unfreeze", (String)freezeState);
            String entryFreezeState = bill.getString("planentity.e_freezestate");
            KDAssert.assertEquals((String)"\u51bb\u7ed3\u72b6\u6001\u6709\u8bef", (String)"unfreeze", (String)entryFreezeState);
        }
    }

    public Long[] pushPaidPayBill(List<Long> purOrderIds) {
        List<DynamicObject> payBillList = BOTPHelper.push("pm_purorderbill", "cas_paybill", purOrderIds);
        DynamicObject[] payBillArray = payBillList.toArray(new DynamicObject[0]);
        OperateOption option = OperateOption.create();
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"cas_paybill", (DynamicObject[])payBillArray, (OperateOption)option);
        OperationHelper.assertResult(save);
        Object[] payBillIds = (Long[])Arrays.stream(payBillArray).map(purIn -> purIn.getLong("id")).toArray(Long[]::new);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cas_paybill");
        DynamicObject[] payBills = BusinessDataServiceHelper.load((Object[])payBillIds, (DynamicObjectType)entityType);
        Arrays.stream(payBills).forEach(purBill -> purBill.set("billstatus", (Object)"C"));
        SaveServiceHelper.save((DynamicObject[])payBills);
        OperateOption payOption = OperateOption.create();
        OperationResult pay = OperationServiceHelper.executeOperate((String)"pay", (String)"cas_paybill", (Object[])payBillIds, (OperateOption)payOption);
        OperationHelper.assertResult(pay);
        return payBillIds;
    }
}

