/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purrecieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataVo;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurReceiveBillTestHelper;
import org.junit.Test;

public class AP024_001_PurReceiveBill2FinApBillTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase1() throws InterruptedException {
        this.purRecStratProcessTest(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u7ea2\u5b57\u91c7\u8d2d\u6536\u8d27-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase2() throws InterruptedException {
        this.purRecStratProcessTest(true);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27(\u5f02\u5e01\u522b)-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase3() throws InterruptedException {
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushFinAPBillDataVo(false);
        purRecDataVo.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
        purRecDataVo.setExchangeRate(BigDecimal.valueOf(6.5));
        DynamicObject purRecBill = PurReceiveBillTestHelper.getAuditStatusPurRecBill(new BigDecimal[]{BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(10L)}, purRecDataVo);
        long purRecBillId = purRecBill.getLong("id");
        ArrayList<Long> purRecBills = new ArrayList<Long>(1);
        purRecBills.add(purRecBillId);
        DynamicObject finApBill = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, true);
        long finApBillId = finApBill.getLong("id");
        purRecBill = BusinessDataServiceHelper.loadSingle((Object)purRecBillId, (String)"im_purreceivebill");
        PurInBillTestChecker.entryCheckByQty(purRecBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), 0);
        finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBillId});
        purRecBill = BusinessDataServiceHelper.loadSingle((Object)purRecBillId, (String)"im_purreceivebill");
        PurInBillTestChecker.entryCheckByQty(purRecBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBillId});
        BusBillTestHelper.executeOperation("unaudit", "im_purreceivebill", new Object[]{purRecBillId});
        BusBillTestHelper.executeOperation("delete", "im_purreceivebill", new Object[]{purRecBillId});
    }

    private void purRecStratProcessTest(boolean isReturn) throws InterruptedException {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushFinAPBillDataVo(isReturn);
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purRecBill1 = PurReceiveBillTestHelper.getAuditStatusPurRecBill(qtys, prices, purRecDataVo);
        long purRecBill1Id = purRecBill1.getLong("id");
        qtys = new BigDecimal[]{BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag)};
        prices = new BigDecimal[]{BigDecimal.valueOf(15L), BigDecimal.valueOf(30L)};
        DynamicObject purRecBill2 = PurReceiveBillTestHelper.getAuditStatusPurRecBill(qtys, prices, purRecDataVo);
        long purRecBill2Id = purRecBill2.getLong("id");
        ArrayList<Long> purRecBills = new ArrayList<Long>(2);
        purRecBills.add(purRecBill1Id);
        purRecBills.add(purRecBill2Id);
        DynamicObject finApBill1 = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, false);
        long finApBill1Id = finApBill1.getLong("id");
        this.finApBillAuditCheckByFinAp(finApBill1Id, purRecBill1Id, purRecBill2Id, isReturn);
        this.finApBillAuditCheckByPur(purRecBill1Id, purRecBill2Id, true, isReturn);
        DynamicObject finApBill2 = PurReceiveBillTestHelper.getPurRecPushFinApBill(purRecBills, true);
        long finApBill2Id = finApBill2.getLong("id");
        this.finApBillAuditCheckByFinAp(finApBill2Id, purRecBill1Id, purRecBill2Id, isReturn);
        this.finApBillAuditCheckByPur(purRecBill1Id, purRecBill2Id, false, isReturn);
        Thread.sleep(20000L);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill1Id});
        this.finApBillUnAuditCheckByPur(purRecBill1Id, purRecBill2Id, true, isReturn);
        BusBillTestHelper.executeOperation("unaudit", "ap_finapbill", new Object[]{finApBill2Id});
        this.finApBillUnAuditCheckByPur(purRecBill1Id, purRecBill2Id, false, isReturn);
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill1Id});
        BusBillTestHelper.executeOperation("delete", "ap_finapbill", new Object[]{finApBill2Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purreceivebill", new Object[]{purRecBill1Id});
        BusBillTestHelper.executeOperation("delete", "im_purreceivebill", new Object[]{purRecBill1Id});
        BusBillTestHelper.executeOperation("unaudit", "im_purreceivebill", new Object[]{purRecBill2Id});
        BusBillTestHelper.executeOperation("delete", "im_purreceivebill", new Object[]{purRecBill2Id});
    }

    private void finApBillAuditCheckByPur(long purRecBill1Id, long purRecBillId2, boolean isFirstPush, boolean isReturn) {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObject purRecBill1 = BusinessDataServiceHelper.loadSingle((Object)purRecBill1Id, (String)"im_purreceivebill");
        DynamicObject purRecBill2 = BusinessDataServiceHelper.loadSingle((Object)purRecBillId2, (String)"im_purreceivebill");
        if (isFirstPush) {
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(20L).multiply(flag), BigDecimal.valueOf(20L).multiply(flag), 1);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(30L).multiply(flag), BigDecimal.valueOf(30L).multiply(flag), 1);
        }
    }

    private void finApBillAuditCheckByFinAp(long finApBillId, long purRecBill1Id, long purRecBill2Id, boolean isReturn) {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(5L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(50L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(10L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(200L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(2), BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(112.5).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(3), BigDecimal.valueOf(15L).multiply(flag), BigDecimal.ZERO, BigDecimal.valueOf(450L).multiply(flag), BigDecimal.ZERO);
        FinApBillTestChecker.validateApFinVerifyRecordData(purRecBill1Id, finApBillId);
        FinApBillTestChecker.validateApFinVerifyRecordData(purRecBill2Id, finApBillId);
        FinApBillTestChecker.validateApFinHead(finApBill);
        FinApBillTestChecker.validateApFinJournalData(finApBill);
    }

    private void finApBillUnAuditCheckByPur(long purRecBill1Id, long purRecBillId2, boolean isFirstUnAudit, boolean isReturn) {
        BigDecimal flag = isReturn ? BigDecimal.valueOf(-1L) : BigDecimal.ONE;
        DynamicObject purRecBill1 = BusinessDataServiceHelper.loadSingle((Object)purRecBill1Id, (String)"im_purreceivebill");
        DynamicObject purRecBill2 = BusinessDataServiceHelper.loadSingle((Object)purRecBillId2, (String)"im_purreceivebill");
        if (isFirstUnAudit) {
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(5L).multiply(flag), BigDecimal.valueOf(5L).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.valueOf(10L).multiply(flag), BigDecimal.valueOf(10L).multiply(flag), 1);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(7.5).multiply(flag), BigDecimal.valueOf(7.5).multiply(flag), 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.valueOf(15L).multiply(flag), BigDecimal.valueOf(15L).multiply(flag), 1);
        } else {
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill1, BigDecimal.ZERO, BigDecimal.ZERO, 1);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.ZERO, BigDecimal.ZERO, 0);
            PurRecBillTestChecker.entryCheckByQty(purRecBill2, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        }
    }
}

