/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.purrecieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.unittest.framework.check.FinApBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurInBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.PurRecBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.PurReceiveBillDataVo;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinApBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurInBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.PurReceiveBillTestHelper;
import org.junit.Test;

public class AP024_008_PurRec2PurIn2BusAp2FinApWriteTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27-\u91c7\u8d2d\u5165\u5e93-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase1() throws InterruptedException {
        this.purRecStratProcessTest(false);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u91c7\u8d2d\u6536\u8d27(\u5f02\u5e01\u522b)-\u91c7\u8d2d\u5165\u5e93-\u6682\u4f30\u5e94\u4ed8-\u8d22\u52a1\u5e94\u4ed8")
    @Test
    public void testCase3() throws InterruptedException {
        this.purRecStratProcessTest(true);
    }

    private void purRecStratProcessTest(boolean isUSD) throws InterruptedException {
        PurReceiveBillDataVo purRecDataVo = PurReceiveBillTestHelper.getPushPurInBillDataVo();
        if (isUSD) {
            purRecDataVo.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            purRecDataVo.setExchangeRate(BigDecimal.valueOf(6.5));
        }
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(20L)};
        DynamicObject purRecBill = PurReceiveBillTestHelper.getAuditStatusPurRecBill(qtys, prices, purRecDataVo);
        long purRecBillId = purRecBill.getLong("id");
        ArrayList<Long> purRecBillIds = new ArrayList<Long>(1);
        purRecBillIds.add(purRecBillId);
        DynamicObject purInBill = PurInBillTestHelper.fullPushPruInBill("im_purreceivebill", purRecBillIds, "CGRK-" + DBServiceHelper.genGlobalLongId())[0];
        long purInBillId = purInBill.getLong("id");
        ArrayList<Long> purInBillIds = new ArrayList<Long>(1);
        purInBillIds.add(purInBillId);
        DynamicObject[] busApBills = BusBillTestHelper.fullPushBusApBill("im_purinbill", purInBillIds, "APUB-" + DBServiceHelper.genGlobalLongId());
        DynamicObject busApBill = busApBills[0];
        long busApBillId = busApBill.getLong("id");
        ArrayList<Long> busApBillIds = new ArrayList<Long>(1);
        busApBillIds.add(busApBillId);
        DynamicObject[] finApBills = FinApBillTestHelper.fullPushFinApBill("ap_busbill", busApBillIds, "AP-" + DBServiceHelper.genGlobalLongId());
        DynamicObject finApBill = finApBills[0];
        long finApBillId = finApBill.getLong("id");
        Thread.sleep(20000L);
        DynamicObject writeOffBill = FinApBillTestHelper.executeAndGetWriteOffBill(finApBillId);
        this.purRecBillCheck(purRecBillId);
        this.purInBillCheck(purInBillId);
        this.finApBillCheck(purInBillId, finApBillId, isUSD);
        this.writeOffBillCheck(finApBillId, writeOffBill.getLong("id"), isUSD);
    }

    private void purRecBillCheck(long purBillId) {
        DynamicObject purRecBill = BusinessDataServiceHelper.loadSingle((Object)purBillId, (String)"im_purreceivebill");
        PurRecBillTestChecker.entryCheckByQty(purRecBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurRecBillTestChecker.entryCheckByQty(purRecBill, BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }

    private void purInBillCheck(long purInBillId) {
        DynamicObject purInBill = BusinessDataServiceHelper.loadSingle((Object)purInBillId, (String)"im_purinbill");
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 0);
        PurInBillTestChecker.entryCheckByQty(purInBill, BigDecimal.ZERO, BigDecimal.ZERO, 1);
    }

    private void finApBillCheck(long purInBillId, long finApBillId, boolean isUSD) {
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = finApBill.getDynamicObjectCollection("detailentry");
        if (!isUSD) {
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.ZERO, BigDecimal.valueOf(100L), BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(20L), BigDecimal.ZERO, BigDecimal.valueOf(400L), BigDecimal.ZERO);
        }
        FinApBillTestChecker.validateApFinHead(finApBill);
        VerifyRecordTestChecker.redVerifyRecordCheck(purInBillId, finApBillId, false);
    }

    private void writeOffBillCheck(long finApBillId, long writeOffBillId, boolean isUSD) {
        DynamicObject writeOffBill = BusinessDataServiceHelper.loadSingle((Object)writeOffBillId, (String)"ap_finapbill");
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)finApBillId, (String)"ap_finapbill");
        DynamicObjectCollection rows = writeOffBill.getDynamicObjectCollection("detailentry");
        if (!isUSD) {
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(0), BigDecimal.valueOf(-10L), BigDecimal.ZERO, BigDecimal.valueOf(-100L), BigDecimal.ZERO);
            FinApBillTestChecker.validateApFinDetailVerifyData((DynamicObject)rows.get(1), BigDecimal.valueOf(-20L), BigDecimal.ZERO, BigDecimal.valueOf(-400L), BigDecimal.ZERO);
        }
        FinApBillTestChecker.validateApFinHead(writeOffBill);
        VerifyRecordTestChecker.verifyRecordCheck(finApBill, writeOffBill, false);
    }
}

