/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import org.junit.Test;

public class AR022_008_SaleOrderTest
extends AbstractJUnitTestPlugIn {
    private String salBillNo_1 = "AR022_008_SaleOrder_01";

    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355->\u6682\u4f30\u5e94\u6536->\u5f00\u7968\u5355->\u8d22\u52a1\u5e94\u6536->\u6536\u6b3e\u5355\u5355\u5143\u6d4b\u8bd5")
    @Test
    public void case1() {
        SaleOrderTestHelper.deleteBill("sm_salorder", this.salBillNo_1);
        ArrayList<Long> saleBillIds = new ArrayList<Long>(2);
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)2L, (String)"bd_taxrate");
        DynamicObject saleInfo = SaleOrderTestHelper.createSaleOrder(this.salBillNo_1, taxRate, BigDecimal.valueOf(2L), BigDecimal.valueOf(200L), BigDecimal.valueOf(2L), BigDecimal.valueOf(200L));
        Long salBillId = saleInfo.getLong("id");
        saleBillIds.add(salBillId);
        DynamicObject busArInfo = this.pushBusAr(saleBillIds);
        DynamicObject arInvInfo = this.pushArInvoice(busArInfo);
        DynamicObject finArInfo = this.pushFinArBill(arInvInfo);
        DynamicObject recBillInfo = this.pushRecBill(finArInfo);
        recBillInfo = this.receivingrec(salBillId, recBillInfo);
        this.cancelrec(salBillId, recBillInfo);
    }

    public void cancelrec(Long salBillId, DynamicObject recBillInfo) {
        OperationResult cancelrecResult = OperationServiceHelper.executeOperate((String)"cancelrec", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6536\u6b3e\u5355\u53d6\u6d88\u6536\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + cancelrecResult.getMessage()), (boolean)true, (boolean)cancelrecResult.isSuccess());
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject salOrderInfo = BusinessDataServiceHelper.loadSingle((Object)salBillId, (String)"sm_salorder");
        BigDecimal receiptamount = salOrderInfo.getBigDecimal("receiptamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (boolean)false, (receiptamount.compareTo(BigDecimal.valueOf(0L)) != 0 ? 1 : 0) != 0);
    }

    public DynamicObject receivingrec(Long salBillId, DynamicObject recBillInfo) {
        OperationResult receivingrecResult = OperationServiceHelper.executeOperate((String)"receivingrec", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e\u5931\u8d25\u3002\u539f\u56e0\uff1a" + receivingrecResult.getMessage()), (boolean)true, (boolean)receivingrecResult.isSuccess());
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DynamicObject salOrderInfo = BusinessDataServiceHelper.loadSingle((Object)salBillId, (String)"sm_salorder");
        BigDecimal receiptamount = salOrderInfo.getBigDecimal("receiptamount");
        KDAssert.assertEquals((String)"\u8868\u5934\u7d2f\u8ba1\u6536\u6b3e\u91d1\u989d\u6821\u9a8c\u5f02\u5e38", (boolean)false, (receiptamount.compareTo(BigDecimal.valueOf(872L)) != 0 ? 1 : 0) != 0);
        return recBillInfo;
    }

    public DynamicObject pushRecBill(DynamicObject finArInfo) {
        ArrayList<Long> idList = new ArrayList<Long>(1);
        idList.add(finArInfo.getLong("id"));
        List<DynamicObject> list = BOTPHelper.push("ar_finarbill", "cas_recbill", "440257677843523584", idList);
        DynamicObject recBillInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6536\u6b3e\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        recBillInfo.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBillInfo});
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{recBillInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6536\u6b3e\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        return recBillInfo;
    }

    public DynamicObject pushFinArBill(DynamicObject arInvInfo) {
        ArrayList<Long> idList = new ArrayList<Long>(1);
        idList.add(arInvInfo.getLong("id"));
        Long orgId = arInvInfo.getLong("org.id");
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("ar_001", Boolean.FALSE);
        SystemParameterHelper.setSystemParameter(true, orgId, params);
        List<DynamicObject> list = BOTPHelper.push("ar_invoice", "ar_finarbill", "460543480779767808", idList);
        DynamicObject finArInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        finArInfo.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finArInfo});
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        return finArInfo;
    }

    public DynamicObject pushArInvoice(DynamicObject busArInfo) {
        ArrayList<Long> idList = new ArrayList<Long>(1);
        idList.add(busArInfo.getLong("id"));
        List<DynamicObject> list = BOTPHelper.push("ar_busbill", "ar_invoice", "678812139145673728", idList);
        DynamicObject arInvInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{arInvInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u5f00\u7968\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        arInvInfo.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{arInvInfo});
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{arInvInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u5f00\u7968\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        return arInvInfo;
    }

    public DynamicObject pushBusAr(List<Long> idList) {
        List<DynamicObject> list = BOTPHelper.push("sm_salorder", "ar_busbill", "727977235356625920", idList);
        DynamicObject busArInfo = list.get(0);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busArInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6682\u4f30\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        busArInfo.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busArInfo});
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busArInfo}, (OperateOption)OperateOption.create());
        AR022_008_SaleOrderTest.assertEquals((String)("\u6682\u4f30\u5e94\u6536\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        return busArInfo;
    }
}

