/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SaleOrderBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.SaleOrderBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.CasRecTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SettleRecordTestHelper;
import kd.fi.arapcommon.unittest.scene.process.saleorder.SaleOrderBaseTest;
import kd.fi.arapcommon.util.DateUtils;
import org.junit.Test;

public class AR022_051_CasRecFinSaleOrderTest
extends SaleOrderBaseTest {
    private long saleOrderId1;
    private long saleOrderId2;
    private long casRecBillId;
    private long finArBillId;
    private long subCasRecBillId;

    public void initData() {
        super.initData();
        this.deleteFinAndRec(Arrays.asList("AR022_051-TEST-1", "AR022_051-TEST-2"));
        SaleOrderBillDataVO dataVO = new SaleOrderBillDataVO();
        dataVO.setBillNo("AR022_051-TEST-1");
        dataVO.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder1 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId1 = saleOrder1.getLong("id");
        SaleOrderBillDataVO dataVO2 = new SaleOrderBillDataVO();
        dataVO2.setBillNo("AR022_051-TEST-2");
        dataVO2.setOrg(BaseDataTestProvider.getDetailInitOrg());
        dataVO2.setCurrency(BaseDataTestProvider.getCurrencyCNY());
        dataVO2.setExchangeRate(BigDecimal.valueOf(1L));
        DynamicObject saleOrder2 = SaleOrderBillTestDataProvider.createAR022SaleOrderBill(dataVO2, new BigDecimal[]{BigDecimal.valueOf(10L), BigDecimal.valueOf(10L)}, new BigDecimal[]{BigDecimal.valueOf(100L), BigDecimal.valueOf(100L)});
        this.saleOrderId2 = saleOrder2.getLong("id");
    }

    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355-\u8d22\u52a1\u5e94\u6536\u5355 & \u9500\u552e\u8ba2\u5355-\u6536\u6b3e\u5355")
    @Test
    public void partPushCasRecFinAuditTest() {
        List<DynamicObject> finArBillList = BOTPHelper.push("sm_salorder", "ar_finarbill", "940441051997418496", Arrays.asList(this.saleOrderId1, this.saleOrderId2));
        AR022_051_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u8d22\u52a1\u5e94\u6536\u5355\u5f02\u5e38", (finArBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject finArBill = finArBillList.get(0);
        DynamicObjectCollection finDetailEntries = finArBill.getDynamicObjectCollection("entry");
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(0), BigDecimal.valueOf(6L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(1), BigDecimal.valueOf(6L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(2), BigDecimal.valueOf(6L));
        FinArBillTestHelper.setFinArDetailEntry((DynamicObject)finDetailEntries.get(3), BigDecimal.valueOf(6L));
        FinArBillTestHelper.setEntryAmount(finArBill, new BigDecimal[]{BigDecimal.valueOf(600L), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L), BigDecimal.valueOf(600L)});
        OperationResult result1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result1);
        this.finArBillId = finArBill.getLong("id");
        this.doOperation("ar_finarbill", "submit", Collections.singletonList(this.finArBillId));
        this.doOperation("ar_finarbill", "audit", Collections.singletonList(this.finArBillId));
        List<DynamicObject> subCasRecBillList = BOTPHelper.push("ar_finarbill", "cas_recbill", "440257677843523584", Collections.singletonList(this.finArBillId));
        AR022_051_CasRecFinSaleOrderTest.assertTrue((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u6536\u6b3e\u5355\u5f02\u5e38", (subCasRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject subCasRecBill = subCasRecBillList.get(0);
        CasRecTestHelper.setEntryAmt(subCasRecBill, new BigDecimal[]{BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L), BigDecimal.valueOf(200L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        subCasRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        OperationResult result2 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{subCasRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result2);
        subCasRecBill = BusinessDataServiceHelper.loadSingle(result2.getSuccessPkIds().get(0), (String)"cas_recbill");
        this.subCasRecBillId = subCasRecBill.getLong("id");
        subCasRecBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{subCasRecBill});
        this.doOperation("cas_recbill", "audit", Collections.singletonList(this.subCasRecBillId));
        List<DynamicObject> casRecBillList = BOTPHelper.push("sm_salorder", "cas_recbill", "711443854984779776", Arrays.asList(this.saleOrderId1, this.saleOrderId2));
        AR022_051_CasRecFinSaleOrderTest.assertTrue((String)"\u5408\u5e76\u4e0b\u63a8\u751f\u6210\u6536\u6b3e\u5904\u7406\u5355\u5f02\u5e38", (casRecBillList.size() == 1 ? 1 : 0) != 0);
        DynamicObject casRecBill = casRecBillList.get(0);
        casRecBill.set("bizdate", (Object)DateUtils.parseDate("2021-12-11", "yyyy-MM-dd"));
        CasRecTestHelper.setEntryAmt(casRecBill, new BigDecimal[]{BigDecimal.valueOf(800L), BigDecimal.valueOf(800L)}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO});
        OperationResult result3 = OperationServiceHelper.executeOperate((String)"save", (String)"cas_recbill", (DynamicObject[])new DynamicObject[]{casRecBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result3);
        casRecBill = BusinessDataServiceHelper.loadSingle(result3.getSuccessPkIds().get(0), (String)"cas_recbill");
        this.casRecBillId = casRecBill.getLong("id");
        casRecBill.set("billstatus", (Object)"B");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casRecBill});
        this.doOperation("cas_recbill", "audit", Collections.singletonList(this.casRecBillId));
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.casRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    @TestMethod(value=2)
    @DisplayName(value="\u8d22\u52a1\u5355\u4e0b\u63a8\u7684\u6536\u6b3e\u5355\u786e\u8ba4\u6536\u6b3e")
    @Test
    public void casRecReceiveTest() {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.subCasRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(800L), BigDecimal.valueOf(1200L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(800L), BigDecimal.valueOf(1200L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    @TestMethod(value=3)
    @DisplayName(value="\u8d22\u52a1\u5355\u4e0b\u63a8\u7684\u6536\u6b3e\u5355\u53d6\u6d88\u6536\u6b3e")
    @Test
    public void finArBillUnAuditTest() {
        this.doOperation("cas_recbill", "cancelrec", Collections.singletonList(this.subCasRecBillId));
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
    }

    @TestMethod(value=4)
    @DisplayName(value="\u8d22\u52a1\u5355\u4e0b\u63a8\u7684\u6536\u6b3e\u5355\u624b\u5de5\u53cd\u7ed3\u7b97")
    @Test
    public void finArBillAuditTest() {
        this.doOperation("cas_recbill", "receivingrec", Collections.singletonList(this.subCasRecBillId));
        DynamicObject[] settleRecords = SettleRecordTestHelper.loadData(new Long[]{this.finArBillId}, new Long[]{this.subCasRecBillId}, true);
        AR022_051_CasRecFinSaleOrderTest.assertTrue((String)"\u7ed3\u7b97\u8bb0\u5f55\u672a\u751f\u6210", (settleRecords.length > 0 ? 1 : 0) != 0);
        for (DynamicObject settleRecord2 : settleRecords) {
            settleRecord2.set("isvoucher", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])settleRecords);
        List<Long> settleRecordIds = Arrays.stream(settleRecords).map(settleRecord -> settleRecord.getLong("id")).collect(Collectors.toList());
        this.doOperation("ar_settlerecord", "unsettle", settleRecordIds);
        DynamicObject saleOrderBill1 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId1, (String)"sm_salorder");
        DynamicObjectCollection detailEntries = saleOrderBill1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill1, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(0), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        DynamicObjectCollection planEntries = saleOrderBill1.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject saleOrderBill2 = BusinessDataServiceHelper.loadSingle((Object)this.saleOrderId2, (String)"sm_salorder");
        SaleOrderBillTestChecker.validateHeadAddUpAmt(saleOrderBill2, BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObjectCollection detailEntries2 = saleOrderBill2.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(0), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        SaleOrderBillTestChecker.checkJoinAndAdd((DynamicObject)detailEntries2.get(1), BigDecimal.valueOf(6L), BigDecimal.valueOf(6L), BigDecimal.valueOf(600L));
        DynamicObjectCollection planEntries2 = saleOrderBill2.getDynamicObjectCollection("recplanentry");
        SaleOrderBillTestChecker.validatePlanEntryAmt((DynamicObject)planEntries2.get(0), BigDecimal.valueOf(2000L), BigDecimal.valueOf(800L), BigDecimal.valueOf(800L));
        DynamicObject[] settleRecords1 = SettleRecordTestHelper.loadData(new Long[]{this.finArBillId}, new Long[]{this.subCasRecBillId}, true);
        AR022_051_CasRecFinSaleOrderTest.assertTrue((String)"\u672a\u751f\u6210\u5bf9\u5e94\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55", (settleRecords1.length > settleRecords.length ? 1 : 0) != 0);
    }
}

