/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.saleorder;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SaleOrderBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SaleOrderTestHelper;
import org.junit.Test;

public class AR022_054_SalOrderandNewFinArBillTest
extends AbstractJUnitTestPlugIn {
    private DynamicObject salOrderBill = null;
    private DynamicObject salOutBill = null;
    private DynamicObject finArBill = null;
    private DynamicObject revCfmBill = null;

    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u51c6\u5907\u9500\u552e\u8ba2\u5355")
    @Test
    public void createBillInfo() {
        DynamicObject taxRate = BusinessDataServiceHelper.loadSingle((Object)2L, (String)"bd_taxrate");
        this.salOrderBill = SaleOrderTestHelper.createSaleOrder("AR022_054_SalOrder_01", "sm_SalesOrder_STD_BT_S", taxRate, BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L));
    }

    @TestMethod(value=2)
    @DisplayName(value="\u9500\u552e\u8ba2\u5355->\u9500\u552e\u51fa\u5e93\u5355")
    @Test
    public void salOrdertoRevCfmBill() {
        List<DynamicObject> salOutBills = BOTPHelper.push("sm_salorder", "im_saloutbill", "610056021305574400", Collections.singletonList(this.salOrderBill.getLong("id")));
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])salOutBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(save);
        for (DynamicObject salOutBill : salOutBills) {
            salOutBill.set("billstatus", (Object)"C");
            salOutBill.set("billno", (Object)"AR022_054_SalOut_01");
        }
        SaveServiceHelper.update((DynamicObject[])salOutBills.toArray(new DynamicObject[0]));
        this.salOutBill = salOutBills.get(0);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u65b0\u589e\u8d22\u52a1\u5e94\u6536\u5355 \u6838\u5fc3\u5355\u636e\u53f7\u4e3a\u8ba2\u5355 \u4e0b\u63a8\u6536\u5165\u786e\u8ba4\u5355")
    @Test
    public void CreateRevCfmBillInfo() {
        List<DynamicObject> finArBills = BOTPHelper.push("im_saloutbill", "ar_finarbill", "645358541351198720", Collections.singletonList(this.salOutBill.getLong("id")));
        this.finArBill = finArBills.get(0);
        this.finArBill.set("billno", (Object)"AR022_054_FinArBill_01");
        this.finArBill.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        this.finArBill.set("billstatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.finArBill});
        if (QueryServiceHelper.exists((String)"ar_revcfmbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"AR022_054_RevCfmBill_01")})) {
            DeleteServiceHelper.delete((String)"ar_revcfmbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"AR022_054_RevCfmBill_01")});
        }
        List<DynamicObject> revCfmBills = BOTPHelper.push("ar_finarbill", "ar_revcfmbill", "732548615414756352", Collections.singletonList(this.finArBill.getLong("id")));
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])revCfmBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(save);
        this.revCfmBill = revCfmBills.get(0);
        this.revCfmBill.set("billno", (Object)"AR022_054_RevCfmBill_01");
        DynamicObject payProperty = BusinessDataServiceHelper.loadSingleFromCache((Object)503272215320499200L, (String)"ar_payproperty");
        this.revCfmBill.set("payproperty", payProperty.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.revCfmBill});
    }

    @TestMethod(value=4)
    @DisplayName(value="\u6536\u5165\u786e\u8ba4\u5355\u63d0\u4ea4\u5ba1\u6838")
    @Test
    public void RevCfmBillSubmmitandAudit() {
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])new Long[]{this.revCfmBill.getLong("id")}, (OperateOption)OperateOption.create());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AR022_054_SalOrderandNewFinArBillTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Long[]{this.revCfmBill.getLong("id")}, (OperateOption)OperateOption.create());
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AR022_054_SalOrderandNewFinArBillTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        this.salOrderBill = BusinessDataServiceHelper.loadSingle((Object)this.salOrderBill.getLong("id"), (String)"sm_salorder");
        DynamicObjectCollection entry = this.salOrderBill.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L));
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry.get(1), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), BigDecimal.valueOf(400L));
        this.coreBillVerifyCheck(false);
    }

    @TestMethod(value=5)
    @DisplayName(value="\u6536\u5165\u786e\u8ba4\u5355\u53cd\u5ba1\u6838")
    @Test
    public void RevCfmBillUnaudit() throws InterruptedException {
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{this.finArBill.getLong("id")}, (OperateOption)OperateOption.create());
        Thread.sleep(20000L);
        AR022_054_SalOrderandNewFinArBillTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult.getMessage()), (boolean)true, (boolean)unauditResult.isSuccess());
        DynamicObject salOrder1 = BusinessDataServiceHelper.loadSingle((Object)this.salOrderBill.getLong("id"), (String)"sm_salorder");
        DynamicObjectCollection entry1 = salOrder1.getDynamicObjectCollection("billentry");
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry1.get(0), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        SaleOrderBillTestChecker.checkConfirmQtyAndAmt((DynamicObject)entry1.get(1), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        this.coreBillVerifyCheck(true);
        this.deleteBills();
    }

    private void coreBillVerifyCheck(boolean isReverse) {
        if (isReverse) {
            VerifyRecordTestChecker.checkVerifyRecordExists(this.salOutBill.getLong("id"), this.revCfmBill.getLong("id"), true, false);
        } else {
            this.revCfmBill = BusinessDataServiceHelper.loadSingle((Object)this.revCfmBill.getLong("id"), (String)"ar_revcfmbill");
            this.salOutBill = BusinessDataServiceHelper.loadSingle((Object)this.salOutBill.getLong("id"), (String)"im_saloutbill");
            DynamicObjectCollection rows = this.revCfmBill.getDynamicObjectCollection("entry");
            RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)rows.get(0), BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO);
            RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)rows.get(1), BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), BigDecimal.ZERO, BigDecimal.ZERO);
            RevCfmBillTestChecker.validateHeadAmt(this.revCfmBill, BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.valueOf(500L), BigDecimal.ZERO);
            VerifyRecordTestChecker.verifyRecordCheck(this.salOutBill, this.revCfmBill, true);
        }
    }

    private void deleteBills() {
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_revcfmbill", (Object[])new Long[]{this.revCfmBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Long[]{this.finArBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_finarbill", (Object[])new Long[]{this.finArBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])new Long[]{this.salOutBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Long[]{this.salOutBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"sm_salorder", (Object[])new Long[]{this.salOrderBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"sm_salorder", (Object[])new Long[]{this.salOrderBill.getLong("id")}, (OperateOption)OperateOption.create());
    }
}

