/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.salout;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.SalOutBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SalOutBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.junit.Test;

public class AR021_001_SalOutBilltoBusArTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u51fa\u5e93\u5355-\u6682\u4f30\u5e94\u6536\u5355")
    @Test
    public void testCase1() throws InterruptedException {
        DynamicObject salOutBill = this.getSalOutBill(false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
        salOutBill = BusinessDataServiceHelper.loadSingle((Object)salOutBill.getPkValue(), (String)"im_saloutbill");
        DynamicObject[] busBills = BOTPHelper.push("im_saloutbill", "ar_busbill", "727376405603593216", salOutBill);
        BusBillTestHelper.executeOperation("save", "ar_busbill", busBills);
        Thread.sleep(1500L);
        SalOutBillTestChecker.checkIsPushBusAr(salOutBill.getLong("id"), true);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBills);
        Thread.sleep(1500L);
        SalOutBillTestChecker.checkIsPushBusAr(salOutBill.getLong("id"), false);
        BusBillTestHelper.executeOperation("unaudit", "im_saloutbill", new Object[]{salOutBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "im_saloutbill", new Object[]{salOutBill.getLong("id")});
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5f02\u5e01\u522b\uff1a\u9500\u552e\u51fa\u5e93\u5355-\u6682\u4f30\u5e94\u6536\u5355")
    @Test
    public void testCase2() throws InterruptedException {
        DynamicObject salOutBill = this.getSalOutBill(true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{salOutBill});
        salOutBill = BusinessDataServiceHelper.loadSingle((Object)salOutBill.getPkValue(), (String)"im_saloutbill");
        DynamicObject[] busBills = BOTPHelper.push("im_saloutbill", "ar_busbill", "727376405603593216", salOutBill);
        BusBillTestHelper.executeOperation("save", "ar_busbill", busBills);
        Thread.sleep(1500L);
        SalOutBillTestChecker.checkIsPushBusAr(salOutBill.getLong("id"), true);
        BusBillTestHelper.executeOperation("delete", "ar_busbill", busBills);
        Thread.sleep(1500L);
        SalOutBillTestChecker.checkIsPushBusAr(salOutBill.getLong("id"), false);
        BusBillTestHelper.executeOperation("unaudit", "im_saloutbill", new Object[]{salOutBill.getLong("id")});
        BusBillTestHelper.executeOperation("delete", "im_saloutbill", new Object[]{salOutBill.getLong("id")});
    }

    private DynamicObject getSalOutBill(boolean isUSD) {
        SalOutBillDataDetailVO salOutDetailVO1 = new SalOutBillDataDetailVO();
        salOutDetailVO1.setQuantity(BigDecimal.valueOf(10L));
        salOutDetailVO1.setPrice(BigDecimal.valueOf(10L));
        SalOutBillDataDetailVO salOutDetailVO2 = new SalOutBillDataDetailVO();
        salOutDetailVO2.setQuantity(BigDecimal.valueOf(20L));
        salOutDetailVO2.setPrice(BigDecimal.valueOf(20L));
        ArrayList<SalOutBillDataDetailVO> entryInfoList = new ArrayList<SalOutBillDataDetailVO>(2);
        entryInfoList.add(salOutDetailVO1);
        entryInfoList.add(salOutDetailVO2);
        SalOutBillDataVO billInfo = new SalOutBillDataVO().setBillStatus("C").setBillNo("AR021_001_SalOutBill_01");
        if (isUSD) {
            billInfo.setSettleCurrency(BaseDataTestProvider.getCurrencyUSD());
            billInfo.setExchangeRate(BigDecimal.valueOf(6.5));
        }
        return SalOutBillDataTestProvider.buildByEntryPriceAndQty(billInfo, entryInfoList);
    }
}

