/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.salout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.SalOutBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.SalOutBillTestHelper;
import org.junit.Test;

public class AR021_016_SalOutBilltoRevCfmTest
extends AbstractJUnitTestPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u9500\u552e\u51fa\u5e93->\u6682\u4f30\u5e94\u6536->\u6536\u5165\u786e\u8ba4")
    @Test
    public void testCase1() throws InterruptedException {
        DynamicObject salOutBill1 = SalOutBillTestHelper.createSalOutBill("AR021_016_SalOutBill_01", BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), false);
        DynamicObject salOutBill2 = SalOutBillTestHelper.createSalOutBill("AR021_016_SalOutBill_02", BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), false);
        long salOutBillId1 = salOutBill1.getLong("id");
        long salOutBillId2 = salOutBill2.getLong("id");
        ArrayList<Long> salOutBillIds = new ArrayList<Long>(2);
        salOutBillIds.add(salOutBillId1);
        salOutBillIds.add(salOutBillId2);
        DynamicObject busBill = this.pushBusBill(salOutBillIds);
        List<DynamicObject> revCfmBills = BOTPHelper.push("ar_busbill", "ar_revcfmbill", "743297688115646464", Collections.singletonList(busBill.getLong("id")));
        DynamicObject revCfmBill = revCfmBills.get(0);
        revCfmBill.set("confirmrate", (Object)BigDecimal.valueOf(100L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])revCfmBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        long revCfmBillId = revCfmBill.getLong("id");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])new Long[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Long[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        Thread.sleep(20000L);
        salOutBill1 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId1, (String)"im_saloutbill");
        salOutBill2 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId2, (String)"im_saloutbill");
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        VerifyRecordTestChecker.verifyRecordCheck(salOutBill1, revCfmBill, true);
        VerifyRecordTestChecker.verifyRecordCheck(salOutBill2, revCfmBill, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), 0, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), 1, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), 2, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), 3, false);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.valueOf(10L), 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.valueOf(20L), 1);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.valueOf(30L), 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.valueOf(40L), 1);
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult.getMessage()), (boolean)true, (boolean)unauditResult.isSuccess());
        Thread.sleep(20000L);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), 0, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), 1, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), 2, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), 3, true);
        salOutBill1 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId1, (String)"im_saloutbill");
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.ZERO, 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.ZERO, 1);
        salOutBill2 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId2, (String)"im_saloutbill");
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.ZERO, 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.ZERO, 1);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_busbill", (Object[])new Object[]{busBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_busbill", (Object[])new Object[]{busBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId1}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId2}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId1}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId2}, (OperateOption)OperateOption.create());
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5f02\u5e01\u522b\uff1a\u9500\u552e\u51fa\u5e93->\u6682\u4f30\u5e94\u6536->\u6536\u5165\u786e\u8ba4")
    @Test
    public void testCase2() throws InterruptedException {
        DynamicObject salOutBill1 = SalOutBillTestHelper.createSalOutBill("AR021_016_SalOutBill_USD_01", BigDecimal.valueOf(10L), BigDecimal.valueOf(10L), BigDecimal.valueOf(20L), BigDecimal.valueOf(20L), false);
        DynamicObject salOutBill2 = SalOutBillTestHelper.createSalOutBill("AR021_016_SalOutBill_USD_02", BigDecimal.valueOf(30L), BigDecimal.valueOf(30L), BigDecimal.valueOf(40L), BigDecimal.valueOf(40L), false);
        long salOutBillId1 = salOutBill1.getLong("id");
        long salOutBillId2 = salOutBill2.getLong("id");
        ArrayList<Long> salOutBillIds = new ArrayList<Long>(2);
        salOutBillIds.add(salOutBillId1);
        salOutBillIds.add(salOutBillId2);
        DynamicObject busBill = this.pushBusBill(salOutBillIds);
        List<DynamicObject> revCfmBills = BOTPHelper.push("ar_busbill", "ar_revcfmbill", "743297688115646464", Collections.singletonList(busBill.getLong("id")));
        DynamicObject revCfmBill = revCfmBills.get(0);
        revCfmBill.set("confirmrate", (Object)BigDecimal.valueOf(100L));
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])revCfmBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        long revCfmBillId = revCfmBill.getLong("id");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])new Long[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult.getMessage()), (boolean)true, (boolean)submitResult.isSuccess());
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Long[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        Thread.sleep(20000L);
        salOutBill1 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId1, (String)"im_saloutbill");
        salOutBill2 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId2, (String)"im_saloutbill");
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        VerifyRecordTestChecker.verifyRecordCheck(salOutBill1, revCfmBill, true);
        VerifyRecordTestChecker.verifyRecordCheck(salOutBill2, revCfmBill, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), 0, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), 1, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), 2, false);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), 3, false);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.valueOf(10L), 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.valueOf(20L), 1);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.valueOf(30L), 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.valueOf(40L), 1);
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        AR021_016_SalOutBilltoRevCfmTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u53cd\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult.getMessage()), (boolean)true, (boolean)unauditResult.isSuccess());
        Thread.sleep(20000L);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(10L), BigDecimal.valueOf(100L), 0, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(20L), BigDecimal.valueOf(400L), 1, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(30L), BigDecimal.valueOf(900L), 2, true);
        this.checkRevCfmBill(revCfmBillId, BigDecimal.valueOf(40L), BigDecimal.valueOf(1600L), 3, true);
        salOutBill1 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId1, (String)"im_saloutbill");
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.ZERO, 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill1, BigDecimal.ZERO, 1);
        salOutBill2 = BusinessDataServiceHelper.loadSingle((Object)salOutBillId2, (String)"im_saloutbill");
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.ZERO, 0);
        SalOutBillTestChecker.entryCheckByQty(salOutBill2, BigDecimal.ZERO, 1);
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_busbill", (Object[])new Object[]{busBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"ar_busbill", (Object[])new Object[]{busBill.getLong("id")}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId1}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId2}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId1}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (Object[])new Object[]{salOutBillId2}, (OperateOption)OperateOption.create());
    }

    private DynamicObject pushBusBill(List<Long> salOutBillIds) {
        List<DynamicObject> busBills = BOTPHelper.push("im_saloutbill", "ar_busbill", "727376405603593216", salOutBillIds);
        DynamicObject busBill = busBills.get(0);
        OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busBill}, (OperateOption)OperateOption.create());
        long busBillId = busBill.getLong("id");
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        busBill.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{busBill});
        OperationServiceHelper.executeOperate((String)"submit", (String)"ar_busbill", (Object[])new Object[]{busBillId}, (OperateOption)OperateOption.create());
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_busbill", (Object[])new Object[]{busBillId}, (OperateOption)OperateOption.create());
        busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)"ar_busbill");
        return busBill;
    }

    private void checkRevCfmBill(long revCfmBillId, BigDecimal qty, BigDecimal price, int rowIndex, boolean isReverse) {
        DynamicObject revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        DynamicObjectCollection entry = revCfmBill.getDynamicObjectCollection("entry");
        if (isReverse) {
            RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)entry.get(rowIndex), BigDecimal.ZERO, BigDecimal.ZERO, qty, price);
        } else {
            RevCfmBillTestChecker.validateDetailEntryVerify((DynamicObject)entry.get(rowIndex), qty, price, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }
}

