/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.salout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.unittest.framework.check.SalOutBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.VerifyRecordTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.helper.FinArBillTestHelper;
import kd.fi.arapcommon.unittest.framework.helper.SalOutBillTestHelper;
import org.junit.Test;

public class AR021_025_SalOutBillTest
extends AbstractJUnitTestPlugIn {
    private static String salOutBillNo_1 = "AR021_025_SalOutBillNo_01";

    public void initData() {
        super.initData();
    }

    @TestMethod(value=1)
    @DisplayName(value="\u5f53\u6708\u51fa\u5e93\u3001\u6b21\u6708\u9000\u8d27\u3001\u6700\u540e\u5f00\u7968 1.\u9500\u552e\u51fa\u5e93-\u6682\u4f30\u5e94\u65362.\u9500\u552e\u51fa\u5e93-\u9500\u552e\u51fa\u5e93\uff08\u7ea2\u5b57\uff093.\u6682\u4f30\u5e94\u6536-\u8d22\u52a1\u5e94\u6536-\u6536\u5165\u786e\u8ba4")
    @Test
    public void case1() {
        SalOutBillTestHelper.deleteBill("im_saloutbill", salOutBillNo_1);
        SalOutBillTestHelper.deleteBill("ar_verifyrecord", salOutBillNo_1);
        ArrayList<Long> salOutBillIds = new ArrayList<Long>(2);
        DynamicObject salOutBillInfo_1 = SalOutBillTestHelper.createSalOutBill(salOutBillNo_1, BigDecimal.valueOf(4L), BigDecimal.valueOf(100L), BigDecimal.valueOf(4L), BigDecimal.valueOf(100L));
        Long salOutBillId_1 = salOutBillInfo_1.getLong("id");
        salOutBillIds.add(salOutBillId_1);
        DynamicObject busArInfo = AR021_025_SalOutBillTest.pushBusAr_1(salOutBillIds);
        DynamicObject redSalOutBill = AR021_025_SalOutBillTest.salOutToSalOut_1(salOutBillIds);
        DynamicObject finArBillInfo = AR021_025_SalOutBillTest.busArToFinAr_1(busArInfo, salOutBillIds);
        AR021_025_SalOutBillTest.unAuditFinAr_1(finArBillInfo, salOutBillIds);
        AR021_025_SalOutBillTest.unAuditRedSalOutBill(redSalOutBill, salOutBillIds);
        AR021_025_SalOutBillTest.deleteBusAr_1(busArInfo, salOutBillIds);
    }

    public static void deleteBusAr_1(DynamicObject busArInfo, List<Long> salOutBillIds) {
        OperationResult unauditResult_1 = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busArInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u53cd\u5ba1\u6838\u6682\u4f30\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult_1.getMessage()), (boolean)true, (boolean)unauditResult_1.isSuccess());
        OperationResult deleteResult_1 = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busArInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u5220\u9664\u6682\u4f30\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + deleteResult_1.getMessage()), (boolean)true, (boolean)deleteResult_1.isSuccess());
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkIsPushBusAr(salOutBillId, false);
        }
    }

    public static void unAuditRedSalOutBill(DynamicObject redSalOutBill, List<Long> salOutBillIds) {
        Long redSalOutId = redSalOutBill.getLong("id");
        redSalOutBill = BusinessDataServiceHelper.loadSingle((Object)redSalOutId, (String)"im_saloutbill");
        OperationResult unauditResult_1 = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{redSalOutBill}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u53cd\u5ba1\u6838\u7ea2\u5b57\u51fa\u5e93\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult_1.getMessage()), (boolean)true, (boolean)unauditResult_1.isSuccess());
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkEntryAllQty(salOutBillId, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false);
        }
        redSalOutBill = BusinessDataServiceHelper.loadSingle((Object)redSalOutId, (String)"im_saloutbill");
        OperationResult deleteResult_1 = OperationServiceHelper.executeOperate((String)"delete", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{redSalOutBill}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u5220\u9664\u7ea2\u5b57\u51fa\u5e93\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + deleteResult_1.getMessage()), (boolean)true, (boolean)deleteResult_1.isSuccess());
    }

    public static void unAuditFinAr_1(DynamicObject finArBillInfo, List<Long> salOutBillIds) {
        OperationResult unauditResult_1 = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBillInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u53cd\u5ba1\u6838\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + unauditResult_1.getMessage()), (boolean)true, (boolean)unauditResult_1.isSuccess());
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkEntryAllQty(salOutBillId, BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), true);
        }
        OperationResult deleteResult_1 = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBillInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u5220\u9664\u8d22\u52a1\u5e94\u6536\u5355\u5931\u8d25\u3002\u539f\u56e0\uff1a" + deleteResult_1.getMessage()), (boolean)true, (boolean)deleteResult_1.isSuccess());
    }

    public static DynamicObject busArToFinAr_1(DynamicObject busArInfo, List<Long> salOutBillIds) {
        ArrayList<Long> busArIds = new ArrayList<Long>(1);
        busArIds.add(busArInfo.getLong("id"));
        List<DynamicObject> list = BOTPHelper.push("ar_busbill", "ar_finarbill", "674365182167762944", busArIds);
        DynamicObject finArBillInfo = list.get(0);
        finArBillInfo.set("payproperty", (Object)BaseDataTestProvider.getPayProperty());
        DynamicObjectCollection entryCol = finArBillInfo.getDynamicObjectCollection("entry");
        for (DynamicObject entryInfo : entryCol) {
            FinArBillTestHelper.setFinArDetailEntry(entryInfo, BigDecimal.valueOf(2L));
        }
        FinArBillTestHelper.recHeadAmt(finArBillInfo);
        OperationResult saveResult_2 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBillInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult_2.getMessage()), (boolean)true, (boolean)saveResult_2.isSuccess());
        OperationResult submitResult_2 = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBillInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u63d0\u4ea4\u5931\u8d25\u3002\u539f\u56e0\uff1a" + submitResult_2.getMessage()), (boolean)true, (boolean)submitResult_2.isSuccess());
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OperationResult auditResult_2 = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBillInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult_2.getMessage()), (boolean)true, (boolean)auditResult_2.isSuccess());
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkEntryAllQty(salOutBillId, BigDecimal.valueOf(2L), BigDecimal.valueOf(4L), BigDecimal.valueOf(2L), true);
        }
        return finArBillInfo;
    }

    public static DynamicObject salOutToSalOut_1(List<Long> salOutBillIds) {
        List<DynamicObject> list = BOTPHelper.push("im_saloutbill", "im_saloutbill", "705622291240812544", salOutBillIds);
        DynamicObject red_salOutBillinfo = list.get(0);
        SalOutBillTestHelper.buildEntryByQtyDivide2(red_salOutBillinfo);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{red_salOutBillinfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u9500\u552e\u51fa\u5e93-\u9500\u552e\u51fa\u5e93\uff08\u7ea2\u5b57\uff09\uff08\u6570\u91cf\u51cf\u534a\uff09\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        red_salOutBillinfo = BusinessDataServiceHelper.loadSingle((Object)red_salOutBillinfo.getLong("id"), (String)"im_saloutbill");
        red_salOutBillinfo.set("billstatus", (Object)"B");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{red_salOutBillinfo});
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{red_salOutBillinfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u9500\u552e\u51fa\u5e93-\u9500\u552e\u51fa\u5e93\uff08\u7ea2\u5b57\uff09\uff08\u6570\u91cf\u51cf\u534a\uff09\u5ba1\u6838\u5931\u8d25\u3002\u539f\u56e0\uff1a" + auditResult.getMessage()), (boolean)true, (boolean)auditResult.isSuccess());
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkEntryAllQty(salOutBillId, BigDecimal.valueOf(2L), BigDecimal.valueOf(2L), BigDecimal.ZERO, true);
        }
        Long redSalOutBillId = red_salOutBillinfo.getLong("id");
        DynamicObjectCollection entryCol = red_salOutBillinfo.getDynamicObjectCollection("billentry");
        VerifyRecordTestChecker.checkVerifyRecord(false, salOutBillIds, redSalOutBillId, ((DynamicObject)entryCol.get(0)).getLong("id"), BigDecimal.valueOf(-2L), BigDecimal.valueOf(-2L), true, true);
        VerifyRecordTestChecker.checkVerifyRecord(false, salOutBillIds, redSalOutBillId, ((DynamicObject)entryCol.get(1)).getLong("id"), BigDecimal.valueOf(-2L), BigDecimal.valueOf(-2L), true, true);
        return red_salOutBillinfo;
    }

    public static DynamicObject pushBusAr_1(List<Long> salOutBillIds) {
        List<DynamicObject> list = BOTPHelper.push("im_saloutbill", "ar_busbill", "727376405603593216", salOutBillIds);
        DynamicObject busArInfo = list.get(0);
        OperationResult saveResult_1 = OperationServiceHelper.executeOperate((String)"save", (String)"ar_busbill", (DynamicObject[])new DynamicObject[]{busArInfo}, (OperateOption)OperateOption.create());
        AR021_025_SalOutBillTest.assertEquals((String)("\u9500\u552e\u51fa\u5e93\u4e0b\u63a8\u6682\u4f30\u5e94\u6536\uff0c\u6682\u4f30\u5e94\u6536\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult_1.getMessage()), (boolean)true, (boolean)saveResult_1.isSuccess());
        busArInfo.set("payproperty", (Object)BaseDataTestProvider.getRecProperty());
        busArInfo.set("billstatus", (Object)"C");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{busArInfo});
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Long salOutBillId : salOutBillIds) {
            SalOutBillTestChecker.checkIsPushBusAr(salOutBillId, true);
        }
        return busArInfo;
    }
}

