/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.WriteBackerFactory;
import kd.fi.arapcommon.service.writeback.decorate.IFinEntryWriteBacker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinApBillDataDetailVO;
import org.junit.Test;

public class EntryWriteBackerUnitTest
extends AbstractJUnitTestWithOutFormPlugIn {
    @TestMethod(value=1)
    @DisplayName(value="\u5206\u5f55\u53cd\u5199\u5668-\u4ece\u4e0a\u5230\u4e0b\u8986\u76d6\u7b97\u6cd5-\u5e94\u4ed8\u5355")
    @Test
    public void testOrdinal() {
        DynamicObject bill = this.createSingleFinApBill("EntryWriteBacker_Ordinal_AP");
        IFinEntryWriteBacker writeBacker = WriteBackerFactory.getPlanEntryLockWriteBacker("ap_finapbill");
        writeBacker.directWriteBack(bill, BigDecimal.valueOf(30L));
        writeBacker.directWriteBack(bill, BigDecimal.valueOf(70L));
        writeBacker.directWriteBack(bill, BigDecimal.valueOf(30L));
        writeBacker.directWriteBack(bill, BigDecimal.valueOf(30L));
        BillModel billModel = BillModelFactory.getModel("ap_finapbill");
        DynamicObjectCollection planEntries = bill.getDynamicObjectCollection(billModel.P_ENTRY);
        for (DynamicObject planEntry : planEntries) {
            planEntry.getBigDecimal(billModel.P_UNPLANLOCKAMT);
            planEntry.getBigDecimal(billModel.P_PLANLOCKEDAMT);
        }
    }

    private DynamicObject createSingleFinApBill(String billNo) {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinApBillDataDetailVO> entryInfoApList = new ArrayList<FinApBillDataDetailVO>(2);
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(1));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(50L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(2));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(200L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(3));
        entryInfoApList.add(FinApBillDataDetailVO.New().setPrice(BigDecimal.valueOf(350L)).setQuantity(BigDecimal.valueOf(1L)).setSeq(4));
        return FinApBillTestDataProvider.buildByPriceAndQuantity("EntryWriteBacker_Ordinal_AP", org, entryInfoApList);
    }
}

