/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.RecCfmBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataVO;
import kd.fi.arapcommon.unittest.framework.helper.BusBillTestHelper;
import org.junit.Test;

public class AR023_001_Ar_Rev_VerifyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 15000L;

    public void initData() {
        super.initData();
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ar_005", 0);
        SystemParameterHelper.setSystemParameter(true, org.getLong("id"), params);
        String sql1 = "update t_msmod_schemeset set fenable =1 where fid=1566728852539979776";
        String sql2 = "update t_msmod_schemeset set fenable =1 where fid=1569657529678431232";
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql1);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql2);
    }

    @TestMethod(value=1)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500-\u6570\u91cf\u57fa\u51c6-\u540c\u6e90\u6838\u9500")
    @Test
    public void testCase1() throws InterruptedException {
        String busArBillNo1 = "Ar_Rev_Verify_Case1_busAr";
        this.deleteBill(busArBillNo1, "ar_busbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(10L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(100L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo1, false, false, qtys, prices);
        long busArBillId1 = busArBill.getLong("id");
        List<DynamicObject> finArBills = BOTPHelper.push("ar_busbill", "ar_finarbill", Collections.singletonList(busArBillId1));
        DynamicObject finArBill = finArBills.get(0);
        long finArBillId = finArBill.getLong("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        List<DynamicObject> revCfmBills = BOTPHelper.push("ar_busbill", "ar_revcfmbill", Collections.singletonList(busArBillId1));
        DynamicObject revCfmBill = revCfmBills.get(0);
        long revCfmBillId = revCfmBill.getLong("id");
        operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])new DynamicObject[]{revCfmBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (records.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(0L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(0L), 0);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), 0);
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500-\u91d1\u989d\u57fa\u51c6-\u540c\u6e90\u6838\u9500")
    @Test
    public void testCase2() throws InterruptedException {
        String busArBillNo1 = "Ar_Rev_Verify_Case2_busAr";
        this.deleteBill(busArBillNo1, "ar_busbill");
        BigDecimal[] qtys = new BigDecimal[]{BigDecimal.valueOf(1L)};
        BigDecimal[] prices = new BigDecimal[]{BigDecimal.valueOf(100L)};
        DynamicObject busArBill = BusBillTestHelper.getAuditBusArBill(busArBillNo1, true, false, qtys, prices);
        long busArBillId1 = busArBill.getLong("id");
        List<DynamicObject> finArBills = BOTPHelper.push("ar_busbill", "ar_finarbill", Collections.singletonList(busArBillId1));
        DynamicObject finArBill = finArBills.get(0);
        long finArBillId = finArBill.getLong("id");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{finArBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        List<DynamicObject> revCfmBills = BOTPHelper.push("ar_busbill", "ar_revcfmbill", Collections.singletonList(busArBillId1));
        DynamicObject revCfmBill = revCfmBills.get(0);
        long revCfmBillId = revCfmBill.getLong("id");
        operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])new DynamicObject[]{revCfmBill}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (records.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), 0);
        operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(operationResult);
        Thread.sleep(15000L);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), 0);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500-\u6570\u91cf\u57fa\u51c6-\u540c\u6838\u5fc3\u5355\u636e\u53f7\u6838\u9500-\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500")
    @Test
    public void testCase3() throws InterruptedException {
        this.deleteBill("Ar_Rev_Verify_Case3_finAr", "ar_finarbill");
        this.deleteBill("Ar_Rev_Verify_Case3_revCfm", "ar_revcfmbill");
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(90L)).setQuantity(BigDecimal.valueOf(10L)).setCorebillno("case3").setCorebillentryseq(1L));
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo("Ar_Rev_Verify_Case3_finAr").setOrg(org).setBillStatus("B");
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoArList);
        long finArBillId = finArBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(15000L);
        ArrayList<RecCfmBillDataDetailVO> asstEntryList = new ArrayList<RecCfmBillDataDetailVO>(1);
        asstEntryList.add(RecCfmBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(10L)).setCorebillno("case3").setCorebillentryseq(1L));
        RecCfmBillDataVO billInfo1 = RecCfmBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo("Ar_Rev_Verify_Case3_revCfm").setOrg(org).setBillStatus("B");
        DynamicObject revCfmBill = RecCfmBillTestDataProvider.buildByPriceAndQuantity(billInfo1, asstEntryList);
        long revCfmBillId = revCfmBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(15000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (records.length == 1 ? 1 : 0) != 0);
        Thread.sleep(15000L);
        Set revAdjustBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
        DynamicObject[] revAdjustBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"fbillno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", revAdjustBillIds)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355,\u8bf7\u68c0\u67e5", (boolean)true, (revAdjustBills.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(900L), BigDecimal.valueOf(0L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), BigDecimal.valueOf(0L), 0);
        DynamicObject[] writeOffBills = BOTPHelper.push("ar_finarbill", "ar_finarbill", "516550166468103168", finArBill);
        DynamicObject writeOffBill = writeOffBills[0];
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_finarbill", (DynamicObject[])new DynamicObject[]{writeOffBill}, (OperateOption)OperateOption.create());
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)("\u8d22\u52a1\u5e94\u6536\u5355\u51b2\u9500\uff0c\u51b2\u9500\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        DynamicObject[] hadRedRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId), new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u4e0d\u5b58\u5728\u5df2\u88ab\u7ea2\u51b2\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (hadRedRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject[] redRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId), new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u4e0d\u5b58\u5728\u7ea2\u51b2\u751f\u6210\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (redRecords.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(900L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(10L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1000L), 0);
    }

    @TestMethod(value=4)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500-\u91d1\u989d\u57fa\u51c6-\u540c\u6838\u5fc3\u5355\u636e\u53f7\u6838\u9500(\u5b8c\u5168\u6838\u9500)-\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500")
    @Test
    public void testCase4() throws InterruptedException {
        this.deleteBill("Ar_Rev_Verify_Case4_finAr", "ar_finarbill");
        this.deleteBill("Ar_Rev_Verify_Case4_revCfm", "ar_revcfmbill");
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        ArrayList<FinArBillDataDetailVO> entryInfoArList = new ArrayList<FinArBillDataDetailVO>(1);
        entryInfoArList.add(FinArBillDataDetailVO.New().setPrice(BigDecimal.valueOf(90L)).setQuantity(BigDecimal.valueOf(1L)).setCorebillno("case4").setCorebillentryseq(1L).setIsallverify(true));
        FinArBillDataVO billInfo = FinArBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo("Ar_Rev_Verify_Case4_finAr").setOrg(org).setBillStatus("B").setPayproperty(payproperty);
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryInfoArList);
        long finArBillId = finArBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(15000L);
        ArrayList<RecCfmBillDataDetailVO> asstEntryList = new ArrayList<RecCfmBillDataDetailVO>(1);
        asstEntryList.add(RecCfmBillDataDetailVO.New().setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(1L)).setCorebillno("case4").setCorebillentryseq(1L).setIsallverify(true));
        RecCfmBillDataVO billInfo1 = RecCfmBillDataVO.New().setCurrency(BaseDataTestProvider.getCurrencyCNY().getLong("id")).setExchangerate(BigDecimal.ONE).setBillNo("Ar_Rev_Verify_Case4_revCfm").setOrg(org).setBillStatus("B").setPayproperty(payproperty);
        DynamicObject revCfmBill = RecCfmBillTestDataProvider.buildByPriceAndQuantity(billInfo1, asstEntryList);
        long revCfmBillId = revCfmBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(15000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (records.length == 1 ? 1 : 0) != 0);
        Thread.sleep(15000L);
        Set revAdjustBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
        DynamicObject[] revAdjustBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"fbillno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", revAdjustBillIds)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u672a\u751f\u6210\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355,\u8bf7\u68c0\u67e5", (boolean)true, (revAdjustBills.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(90L), BigDecimal.valueOf(0L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), BigDecimal.valueOf(0L), 0);
        DynamicObject[] writeOffBills = BOTPHelper.push("ar_revcfmbill", "ar_revcfmbill", "1281716490650811392", revCfmBill);
        DynamicObject writeOffBill = writeOffBills[0];
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])new DynamicObject[]{writeOffBill}, (OperateOption)OperateOption.create());
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)("\u6536\u5165\u786e\u8ba4\u5355\u51b2\u9500\uff0c\u51b2\u9500\u5355\u4fdd\u5b58\u5931\u8d25\u3002\u539f\u56e0\uff1a" + saveResult.getMessage()), (boolean)true, (boolean)saveResult.isSuccess());
        DynamicObject[] hadRedRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId), new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.TRUE), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.FALSE)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u4e0d\u5b58\u5728\u5df2\u88ab\u7ea2\u51b2\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (hadRedRecords.length == 1 ? 1 : 0) != 0);
        DynamicObject[] redRecords = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId), new QFilter("entry.e_hadwrittenoff", "=", (Object)Boolean.FALSE), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE)});
        AR023_001_Ar_Rev_VerifyTest.assertEquals((String)"\u4e0d\u5b58\u5728\u7ea2\u51b2\u751f\u6210\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (boolean)true, (redRecords.length == 1 ? 1 : 0) != 0);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(90L), 0);
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(100L), 0);
    }

    private void deleteBill(String billNo, String entityKey) {
        boolean exists = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        if (exists) {
            DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
        }
        if ("ar_finarbill".equals(entityKey)) {
            DeleteServiceHelper.delete((String)"ar_revcrm_verifyrecord", (QFilter[])new QFilter[]{new QFilter("entry.billno", "=", (Object)billNo)});
        }
        if ("ar_revcfmbill".equals(entityKey)) {
            DeleteServiceHelper.delete((String)"ar_revcrm_verifyrecord", (QFilter[])new QFilter[]{new QFilter("entry.assbillno", "=", (Object)billNo)});
        }
    }
}

