/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.check.RevCfmBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.RecCfmBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.RecCfmBillDataVO;
import org.junit.Test;

public class AR023_002_Ar_Rev_GroupVerifyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    DynamicObject org;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ar_005", false);
        SystemParameterHelper.setSystemParameter(true, this.org.getLong("id"), params);
        Object ar_005 = SystemParameterHelper.getARAppParameter(this.org.getLong("id"), "ar_005");
        AR023_002_Ar_Rev_GroupVerifyTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\u5f00\u542f\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u6838\u9500\u65b9\u6848"), ((Boolean)ar_005 == false ? 1 : 0) != 0);
        String sql = "update t_msmod_schemeset set fenable =1 where fid=?;";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(2);
        paramsList.add(new Object[]{1566728852539979776L});
        paramsList.add(new Object[]{1569657529678431232L});
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, paramsList);
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500\uff08\u6570\u91cf\u57fa\u51c6-\u6309\u6210\u7ec4\uff09")
    @Test
    public void testCase2() throws InterruptedException {
        this.testCase("AR023_002_Ar_Rev_GroupVerify_Case2_finAr", "AR023_002_Ar_Rev_GroupVerify_Case2_revCfm", "Ar_Rev_Corebill2", "Ar_Rev_Group2", false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u5e94\u6536\u6536\u5165\u6838\u9500\uff08\u91d1\u989d\u57fa\u51c6-\u6309\u6210\u7ec4\uff09")
    @Test
    public void testCase3() throws InterruptedException {
        this.testCase("AR023_002_Ar_Rev_GroupVerify_Case3_finAr", "AR023_002_Ar_Rev_GroupVerify_Case3_revCfm", "Ar_Rev_Corebill3", "Ar_Rev_Group3", true);
    }

    private void testCase(String finArNo, String recCfmNo, String corebillno, String groupnumber, boolean isAmtBenchMark) throws InterruptedException {
        this.deleteBill("ar_finarbill", new String[]{finArNo});
        this.deleteBill("ar_revcfmbill", new String[]{finArNo, recCfmNo});
        long currencyId = BaseDataTestProvider.getCurrencyUSD().getLong("id");
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        ArrayList<FinArBillDataDetailVO> mainEntryList = new ArrayList<FinArBillDataDetailVO>(8);
        FinArBillDataDetailVO detailVO1 = FinArBillDataDetailVO.New().setSeq(1).setCorebillno(corebillno);
        mainEntryList.add(detailVO1);
        FinArBillDataDetailVO detailVO2 = FinArBillDataDetailVO.New().setSeq(2).setCorebillno(corebillno).setCorebillentryseq(2L);
        mainEntryList.add(detailVO2);
        FinArBillDataDetailVO detailVO3 = FinArBillDataDetailVO.New().setSeq(3).setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber);
        mainEntryList.add(detailVO3);
        FinArBillDataDetailVO detailVO4 = FinArBillDataDetailVO.New().setSeq(4).setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        mainEntryList.add(detailVO4);
        FinArBillDataDetailVO detailVO5 = FinArBillDataDetailVO.New().setSeq(5).setGroupnumber(groupnumber).setGroupseq("10");
        mainEntryList.add(detailVO5);
        for (int i = 0; i < mainEntryList.size(); ++i) {
            FinArBillDataDetailVO detailVO = (FinArBillDataDetailVO)mainEntryList.get(i);
            BigDecimal seq = BigDecimal.valueOf(i + 1);
            if (isAmtBenchMark) {
                detailVO.setPrice(BigDecimal.valueOf(1000L).multiply(seq)).setQuantity(BigDecimal.ONE);
                continue;
            }
            detailVO.setPrice(BigDecimal.valueOf(90L)).setQuantity(BigDecimal.valueOf(10L).multiply(seq));
        }
        FinArBillDataVO finInfo = FinArBillDataVO.New().setCurrency(currencyId).setExchangerate(new BigDecimal(2)).setBillNo(finArNo).setOrg(this.org).setBillStatus("B");
        if (isAmtBenchMark) {
            finInfo.setPayproperty(payproperty);
        }
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQuantity(finInfo, mainEntryList);
        long finArBillId = finArBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(20000L);
        ArrayList<RecCfmBillDataDetailVO> asstEntryList = new ArrayList<RecCfmBillDataDetailVO>(8);
        RecCfmBillDataDetailVO recDetailVO1 = RecCfmBillDataDetailVO.New().setSeq(1).setCorebillno(corebillno);
        asstEntryList.add(recDetailVO1);
        RecCfmBillDataDetailVO recDetailVO2 = RecCfmBillDataDetailVO.New().setSeq(2).setCorebillno(corebillno).setCorebillentryseq(2L);
        asstEntryList.add(recDetailVO2);
        RecCfmBillDataDetailVO recDetailVO3 = RecCfmBillDataDetailVO.New().setSeq(3).setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber);
        asstEntryList.add(recDetailVO3);
        RecCfmBillDataDetailVO recDetailVO4 = RecCfmBillDataDetailVO.New().setSeq(4).setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        asstEntryList.add(recDetailVO4);
        RecCfmBillDataDetailVO recDetailVO5 = RecCfmBillDataDetailVO.New().setSeq(5).setGroupnumber(groupnumber).setGroupseq("10");
        asstEntryList.add(recDetailVO5);
        for (int i = 0; i < asstEntryList.size(); ++i) {
            RecCfmBillDataDetailVO recDetailVO = (RecCfmBillDataDetailVO)asstEntryList.get(i);
            BigDecimal seq = BigDecimal.valueOf(i + 1);
            if (isAmtBenchMark) {
                recDetailVO.setPrice(BigDecimal.valueOf(1000L).multiply(seq)).setQuantity(BigDecimal.ONE);
                continue;
            }
            recDetailVO.setPrice(BigDecimal.valueOf(100L)).setQuantity(BigDecimal.valueOf(10L).multiply(seq));
        }
        RecCfmBillDataVO recInfo = RecCfmBillDataVO.New().setCurrency(currencyId).setExchangerate(new BigDecimal(2)).setBillNo(recCfmNo).setOrg(this.org).setBillStatus("B");
        if (isAmtBenchMark) {
            recInfo.setPayproperty(payproperty);
        }
        DynamicObject revCfmBill = RecCfmBillTestDataProvider.buildByPriceAndQuantity(recInfo, asstEntryList);
        long revCfmBillId = revCfmBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])new Object[]{revCfmBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(20000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)revCfmBillId)});
        AR023_002_Ar_Rev_GroupVerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55", (records.length == 0 ? 1 : 0) != 0, (boolean)false);
        if (!isAmtBenchMark) {
            Set revAdjustBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
            DynamicObject[] revAdjustBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"fbillno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", revAdjustBillIds)});
            AR023_002_Ar_Rev_GroupVerifyTest.assertEquals((String)"\u672a\u751f\u6210\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355,\u8bf7\u68c0\u67e5", (revAdjustBills.length == 0 ? 1 : 0) != 0, (boolean)false);
        }
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        if (isAmtBenchMark) {
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(2000L), BigDecimal.valueOf(0L), 1);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3000L), BigDecimal.valueOf(0L), 2);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(4000L), BigDecimal.valueOf(0L), 3);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(5000L), 4);
        } else {
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1800L), BigDecimal.valueOf(0L), 1);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(2700L), BigDecimal.valueOf(0L), 2);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3600L), BigDecimal.valueOf(0L), 3);
            FinArBillTestChecker.entryCheckByArRevVerify(finArBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(4500L), 4);
        }
        revCfmBill = BusinessDataServiceHelper.loadSingle((Object)revCfmBillId, (String)"ar_revcfmbill");
        if (isAmtBenchMark) {
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(2000L), BigDecimal.valueOf(0L), 1);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3000L), BigDecimal.valueOf(0L), 2);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(4000L), BigDecimal.valueOf(0L), 3);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1L), BigDecimal.valueOf(0L), BigDecimal.valueOf(5000L), 4);
        } else {
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(2000L), BigDecimal.valueOf(0L), 1);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3000L), BigDecimal.valueOf(0L), 2);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(4000L), BigDecimal.valueOf(0L), 3);
            RevCfmBillTestChecker.entryCheckByArRevVerify(revCfmBill, BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(5000L), 4);
        }
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        String verifyrecordKey = "ar_finarbill".equals(entityKey) ? "entry.billno" : "entry.assbillno";
        DeleteServiceHelper.delete((String)"ar_revcrm_verifyrecord", (QFilter[])new QFilter[]{new QFilter(verifyrecordKey, "in", (Object)billNos)});
    }
}

