/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.unittest.framework.check.FinArBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.SalOutBillDataTestProvider;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.FinArBillDataVO;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.SalOutBillDataVO;
import org.junit.Test;

public class AR024_002_Ar_Salout_GroupVerifyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;
    DynamicObject org;

    public void initData() {
        super.initData();
        this.org = BaseDataTestProvider.getDetailInitOrg();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("ar_005", false);
        SystemParameterHelper.setSystemParameter(true, this.org.getLong("id"), params);
        Object ar_005 = SystemParameterHelper.getARAppParameter(this.org.getLong("id"), "ar_005");
        AR024_002_Ar_Salout_GroupVerifyTest.assertTrue((String)(this.org.getLocaleString("name") + " \u5e94\u6536\u6536\u5165\u540c\u65f6\u786e\u8ba4\u5f00\u542f\uff0c\u4e0d\u7b26\u5408\u6210\u7ec4\u548c\u6838\u5fc3\u5355\u636e\u6838\u9500\u65b9\u6848"), ((Boolean)ar_005 == false ? 1 : 0) != 0);
        String sql = "update t_msmod_schemeset set fenable =1 where fid=?;";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(2);
        paramsList.add(new Object[]{1680467798893283328L});
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, paramsList);
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u5e94\u6536\u51fa\u5e93\u6838\u9500\uff08\u6570\u91cf\u57fa\u51c6--\u975eBOTP\uff09")
    @Test
    public void testCase2() throws InterruptedException {
        String salOutNo = "AR024_002_Ar_Salout_GroupVerify_Case2_salOut";
        String finArNo = "AR024_002_Ar_Salout_GroupVerify_Case2_finAr";
        String corebillno = "Ar_Salout_Corebill2";
        String groupnumber = "Ar_Salout_Group2";
        this.deleteBill("im_saloutbill", new String[]{salOutNo});
        this.deleteBill("ar_finarbill", new String[]{finArNo});
        this.deleteBill("ar_revcfmbill", new String[]{finArNo});
        DynamicObject currency = BaseDataTestProvider.getCurrencyUSD();
        ArrayList<SalOutBillDataDetailVO> asstEntryList = new ArrayList<SalOutBillDataDetailVO>(8);
        SalOutBillDataDetailVO salOutDetailVO1 = SalOutBillDataDetailVO.New().setSeq(1).setCorebilltype("sm_salorder").setCorebillno(corebillno);
        asstEntryList.add(salOutDetailVO1);
        SalOutBillDataDetailVO salOutDetailVO2 = SalOutBillDataDetailVO.New().setSeq(2).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(2L);
        asstEntryList.add(salOutDetailVO2);
        SalOutBillDataDetailVO salOutDetailVO3 = SalOutBillDataDetailVO.New().setSeq(3).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber);
        asstEntryList.add(salOutDetailVO3);
        SalOutBillDataDetailVO salOutDetailVO4 = SalOutBillDataDetailVO.New().setSeq(4).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        asstEntryList.add(salOutDetailVO4);
        SalOutBillDataDetailVO salOutDetailVO5 = SalOutBillDataDetailVO.New().setSeq(5).setCorebilltype("sm_salorder").setGroupnumber(groupnumber).setGroupseq("10");
        asstEntryList.add(salOutDetailVO5);
        for (int i = 0; i < asstEntryList.size(); ++i) {
            SalOutBillDataDetailVO recDetailVO = (SalOutBillDataDetailVO)asstEntryList.get(i);
            BigDecimal seq = BigDecimal.valueOf(i + 1);
            recDetailVO.setPrice(BigDecimal.valueOf(90L)).setQuantity(BigDecimal.valueOf(10L).multiply(seq));
        }
        SalOutBillDataVO salOutInfo = SalOutBillDataVO.New().setBillNo(salOutNo).setOrg(this.org).setSettleCurrency(currency).setExchangeRate(new BigDecimal(2)).setBillStatus("C");
        DynamicObject salOutBill = SalOutBillDataTestProvider.buildByEntryPriceAndQty(salOutInfo, asstEntryList);
        long salOutBillId = salOutBill.getLong("id");
        DynamicObject material = ((DynamicObject)salOutBill.getDynamicObjectCollection("billentry").get(0)).getDynamicObject("material").getDynamicObject("masterid");
        ArrayList<FinArBillDataDetailVO> mainEntryList = new ArrayList<FinArBillDataDetailVO>(8);
        FinArBillDataDetailVO detailVO1 = FinArBillDataDetailVO.New().setSeq(1).setCorebilltype("sm_salorder").setCorebillno(corebillno);
        mainEntryList.add(detailVO1);
        FinArBillDataDetailVO detailVO2 = FinArBillDataDetailVO.New().setSeq(2).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(2L);
        mainEntryList.add(detailVO2);
        FinArBillDataDetailVO detailVO3 = FinArBillDataDetailVO.New().setSeq(3).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber);
        mainEntryList.add(detailVO3);
        FinArBillDataDetailVO detailVO4 = FinArBillDataDetailVO.New().setSeq(4).setCorebilltype("sm_salorder").setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        mainEntryList.add(detailVO4);
        FinArBillDataDetailVO detailVO5 = FinArBillDataDetailVO.New().setSeq(5).setCorebilltype("sm_salorder").setGroupnumber(groupnumber).setGroupseq("10");
        mainEntryList.add(detailVO5);
        for (int i = 0; i < mainEntryList.size(); ++i) {
            FinArBillDataDetailVO detailVO = (FinArBillDataDetailVO)mainEntryList.get(i);
            BigDecimal seq = BigDecimal.valueOf(i + 1);
            detailVO.setPrice(BigDecimal.valueOf(90L)).setQuantity(BigDecimal.valueOf(10L).multiply(seq));
        }
        FinArBillDataVO finInfo = FinArBillDataVO.New().setBillNo(finArNo).setOrg(this.org).setCurrency(currency.getLong("id")).setExchangerate(new BigDecimal(2)).setBillStatus("B");
        DynamicObject finArBill = FinArBillTestDataProvider.buildByPriceAndQuantity(finInfo, mainEntryList);
        DynamicObjectCollection entrys = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            entry.set("e_material", (Object)material);
            entry.set("e_measureunit", (Object)material.getDynamicObject("baseunit"));
            entry.set("e_baseunit", (Object)material.getDynamicObject("baseunit"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finArBill});
        long finArBillId = finArBill.getLong("id");
        OperationServiceHelper.executeOperate((String)"audit", (String)"ar_finarbill", (Object[])new Object[]{finArBillId}, (OperateOption)OperateOption.create());
        Thread.sleep(20000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_saloutwfrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)finArBillId), new QFilter("entry.assbillid", "=", (Object)salOutBillId)});
        AR024_002_Ar_Salout_GroupVerifyTest.assertEquals((String)"\u672a\u751f\u6210\u5e94\u6536\u51fa\u5e93\u6838\u9500\u8bb0\u5f55", (records.length == 0 ? 1 : 0) != 0, (boolean)false);
        finArBill = BusinessDataServiceHelper.loadSingle((Object)finArBillId, (String)"ar_finarbill");
        FinArBillTestChecker.entryCheckByArSaloutVerify(finArBill, 1, BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(20L), BigDecimal.valueOf(0L), BigDecimal.valueOf(1800L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.entryCheckByArSaloutVerify(finArBill, 2, BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(30L), BigDecimal.valueOf(0L), BigDecimal.valueOf(2700L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.entryCheckByArSaloutVerify(finArBill, 3, BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(40L), BigDecimal.valueOf(0L), BigDecimal.valueOf(3600L), BigDecimal.valueOf(0L));
        FinArBillTestChecker.entryCheckByArSaloutVerify(finArBill, 4, BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(50L), BigDecimal.valueOf(0L), BigDecimal.valueOf(4500L));
    }

    private void deleteBill(String entityKey, String[] billNos) {
        DeleteServiceHelper.delete((String)entityKey, (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        String verifyrecordKey = "ar_finarbill".equals(entityKey) ? "entry.billno" : "entry.assbillno";
        DeleteServiceHelper.delete((String)"ar_saloutwfrecord", (QFilter[])new QFilter[]{new QFilter(verifyrecordKey, "in", (Object)billNos)});
    }
}

