/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.unittest.AbstractJUnitTestPlugIn;
import kd.bos.unittest.framework.KDAssert;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.unittest.framework.check.BusBillTestChecker;
import kd.fi.arapcommon.unittest.framework.dataprovider.BaseDataTestProvider;
import kd.fi.arapcommon.unittest.framework.dataprovider.BusArBillTestDataProvider;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataDetailVO;
import kd.fi.arapcommon.unittest.framework.entity.BusArBillDataVO;
import org.junit.Test;

public class AR027_001_Ar_BusGroupMatchVerifyTest
extends AbstractJUnitTestPlugIn {
    private static final long sleepTime = 20000L;

    public void initData() {
        super.initData();
        String sql = "update t_msmod_scheme set fenable =1 where fnumber in (?, ?);";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(2);
        paramsList.add(new Object[]{"HXFA-220421-00000003", "HXFA-231111-00001007"});
        paramsList.add(new Object[]{"HXFA-220421-00000004", "HXFA-231111-00001006"});
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql, paramsList);
        String sql2 = "update t_msmod_schemeset set fenable =1 where fnumber in (?, ?);";
        ArrayList<Object[]> paramsList2 = new ArrayList<Object[]>(2);
        paramsList2.add(new Object[]{"LCHX-220421-00000003", "LCHX-220421-00000004"});
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql2, paramsList2);
    }

    @TestMethod(value=1)
    @DisplayName(value="initData")
    @Test
    public void testCase1() {
        this.initData();
    }

    @TestMethod(value=2)
    @DisplayName(value="\u6682\u4f30\u7ea2\u84dd\u6838\u9500\uff08\u6570\u91cf\u57fa\u51c6-\u6309\u6210\u7ec4\uff09")
    @Test
    public void testCase2() throws InterruptedException {
        this.testCase("AR027_001_Case2_BusBlue", "AR027_001_Case2_BusRed", "AR_Bus_Corebill2", "AR_Bus_Group2", false);
    }

    @TestMethod(value=3)
    @DisplayName(value="\u6682\u4f30\u7ea2\u84dd\u6838\u9500\uff08\u91d1\u989d\u57fa\u51c6-\u6309\u6210\u7ec4\uff09")
    @Test
    public void testCase3() throws InterruptedException {
        this.testCase("AR027_001_Case3_BusBlue", "AR027_001_Case3_BusRed", "AR_Bus_Corebill3", "AR_Bus_Group3", true);
    }

    private void testCase(String blueNo, String redNo, String corebillno, String groupnumber, boolean isAmtBenchMark) throws InterruptedException {
        this.deleteBill(new String[]{blueNo, redNo});
        long buleBusId = this.prepareBusBill(blueNo, false, corebillno, groupnumber, isAmtBenchMark);
        long redBusId = this.prepareBusBill(redNo, true, corebillno, groupnumber, isAmtBenchMark);
        OperationResult result = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_busbill", (Object[])new Object[]{redBusId}, (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        Thread.sleep(20000L);
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_bus_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.billid", "=", (Object)buleBusId), new QFilter("entry.assbillid", "=", (Object)redBusId)});
        AR027_001_Ar_BusGroupMatchVerifyTest.assertEquals((String)"\u672a\u751f\u6210\u6682\u4f30\u5e94\u6536\u6838\u9500\u8bb0\u5f55", (records.length == 0 ? 1 : 0) != 0, (boolean)false);
        DynamicObject buleBusBill = BusinessDataServiceHelper.loadSingle((Object)buleBusId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(buleBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByWoff(buleBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        BusBillTestChecker.entryCheckByWoff(buleBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 3);
        BusBillTestChecker.entryCheckByWoff(buleBusBill, BigDecimal.ONE, new BigDecimal(40), new BigDecimal(40), 4);
        DynamicObject redBusBill = BusinessDataServiceHelper.loadSingle((Object)redBusId, (String)"ar_busbill");
        BusBillTestChecker.entryCheckByWoff(redBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1);
        BusBillTestChecker.entryCheckByWoff(redBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 2);
        BusBillTestChecker.entryCheckByWoff(redBusBill, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 3);
        BusBillTestChecker.entryCheckByWoff(redBusBill, new BigDecimal(-1), new BigDecimal(-40), new BigDecimal(-40), 4);
        boolean existBlueWoff = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)true), new QFilter("sourcebillno", "=", (Object)blueNo)});
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + blueNo + "\u672a\u751f\u6210\u51b2\u56de\u5355"), (boolean)true, (boolean)existBlueWoff);
        boolean existRedWoff = QueryServiceHelper.exists((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)true), new QFilter("sourcebillno", "=", (Object)redNo)});
        KDAssert.assertEquals((String)("\u7f16\u53f7\u4e3a\uff1a" + blueNo + "\u672a\u751f\u6210\u51b2\u56de\u5355"), (boolean)true, (boolean)existRedWoff);
    }

    private long prepareBusBill(String billNo, boolean isRed, String corebillno, String groupnumber, boolean isAmtBenchMark) {
        DynamicObject org = BaseDataTestProvider.getDetailInitOrg();
        long currencyId = BaseDataTestProvider.getCurrencyCNY().getLong("id");
        DynamicObject payproperty = BaseDataTestProvider.getRecPropertyAmtBenchmark();
        ArrayList<BusArBillDataDetailVO> entryList = new ArrayList<BusArBillDataDetailVO>(8);
        BusArBillDataDetailVO detailVO1 = BusArBillDataDetailVO.New().setSeq(1).setCorebillno(corebillno);
        entryList.add(detailVO1);
        BusArBillDataDetailVO detailVO2 = BusArBillDataDetailVO.New().setSeq(2).setCorebillno(corebillno).setCorebillentryseq(2L);
        entryList.add(detailVO2);
        BusArBillDataDetailVO detailVO3 = BusArBillDataDetailVO.New().setSeq(3).setCorebillno(corebillno).setCorebillentryseq(3L).setGroupnumber(groupnumber);
        entryList.add(detailVO3);
        BusArBillDataDetailVO detailVO4 = BusArBillDataDetailVO.New().setSeq(4).setCorebillno(corebillno).setCorebillentryseq(4L).setGroupnumber(groupnumber).setGroupseq("8");
        entryList.add(detailVO4);
        BusArBillDataDetailVO detailVO5 = BusArBillDataDetailVO.New().setSeq(5).setGroupnumber(groupnumber).setGroupseq("10");
        entryList.add(detailVO5);
        for (int i = 0; i < entryList.size(); ++i) {
            BusArBillDataDetailVO detailVO = (BusArBillDataDetailVO)entryList.get(i);
            BigDecimal quantity = BigDecimal.ONE;
            if (isRed) {
                quantity = quantity.negate();
            }
            detailVO.setPrice(BigDecimal.TEN.multiply(BigDecimal.valueOf(i))).setQuantity(quantity);
        }
        BusArBillDataVO billInfo = BusArBillDataVO.New().setOrg(org).setBillNo(billNo).setCurrency(currencyId).setExchangerate(BigDecimal.ONE).setBillStatus(isRed ? "B" : "C");
        if (isAmtBenchMark) {
            billInfo.setPayProperty(payproperty);
        }
        DynamicObject busBill = BusArBillTestDataProvider.buildByPriceAndQuantity(billInfo, entryList);
        return busBill.getLong("id");
    }

    private void deleteBill(String[] billNos) {
        DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ar_busbill", (QFilter[])new QFilter[]{new QFilter("sourcebillno", "in", (Object)billNos)});
        DeleteServiceHelper.delete((String)"ar_journal", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
    }
}

