/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.process.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.unittest.scene.process.verify.EntryRowVO;

public class ManualVerifyUnitTestHelper {
    public static DynamicObject[] buildMainRows(List<EntryRowVO> mainBills, boolean isAr) {
        ArrayList<DynamicObject> mainRows = new ArrayList<DynamicObject>(mainBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_manualverify" : "ap_manualverify"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("mainbill")).getDynamicCollectionItemPropertyType();
        for (EntryRowVO rowModel : mainBills) {
            Map<String, Object> paramMap = rowModel.getParamMap();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("main_id", paramMap.get("id"));
            row.set("main_entryid", paramMap.get("entryid"));
            row.set("main_billno", paramMap.get("billno"));
            row.set("main_currency", paramMap.get("currency"));
            row.set("main_bizdate", paramMap.get("bizdate"));
            row.set("main_unitprice", paramMap.get("price"));
            row.set("main_curverifyamt", paramMap.get("curVerifyAmt"));
            row.set("main_material", paramMap.get("material"));
            row.set("main_convertrate", paramMap.get("convertrate"));
            DynamicObject measureunit = (Long)paramMap.get("measureunit") != 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)paramMap.get("measureunit"), (String)"bd_measureunits") : null;
            row.set("main_measureunit", (Object)measureunit);
            DynamicObject baseunit = (Long)paramMap.get("baseunit") != 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)paramMap.get("baseunit"), (String)"bd_measureunits") : null;
            row.set("main_baseunit", (Object)baseunit);
            row.set("main_curverifyqty", paramMap.get("curverifyqty"));
            row.set("main_quotation", paramMap.get("quotation"));
            row.set("main_exchangerate", paramMap.get("exchangerate"));
            row.set("main_basecurrency", paramMap.get("basecurrency"));
            row.set("main_materialversion", paramMap.get("materialversion"));
            row.set("main_modelnum", paramMap.get("modelnum"));
            row.set("main_assistantattr", paramMap.get("assistantattr"));
            row.set("main_configuredcode", paramMap.get("configuredcode"));
            row.set("main_tracknumber", paramMap.get("tracknumber"));
            mainRows.add(row);
        }
        return mainRows.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] buildAsstRows(List<EntryRowVO> mainBills, boolean isAr) {
        ArrayList<DynamicObject> mainRows = new ArrayList<DynamicObject>(mainBills.size());
        DynamicObject handSettle = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_manualverify" : "ap_manualverify"));
        DynamicObjectType dataEntityType = (DynamicObjectType)handSettle.getDataEntityType();
        DynamicObjectType entryDt = ((EntryProp)dataEntityType.getProperty("asstbill")).getDynamicCollectionItemPropertyType();
        for (EntryRowVO rowModel : mainBills) {
            Map<String, Object> paramMap = rowModel.getParamMap();
            DynamicObject row = new DynamicObject(entryDt);
            row.set("asst_id", paramMap.get("id"));
            row.set("asst_entryid", paramMap.get("entryid"));
            row.set("asst_billno", paramMap.get("billno"));
            row.set("asst_currency", paramMap.get("currency"));
            row.set("asst_bizdate", paramMap.get("bizdate"));
            row.set("asst_unitprice", paramMap.get("price"));
            row.set("asst_curverifyamt", paramMap.get("curVerifyAmt"));
            row.set("asst_material", paramMap.get("material"));
            row.set("asst_convertrate", paramMap.get("convertrate"));
            DynamicObject measureunit = (Long)paramMap.get("measureunit") != 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)paramMap.get("measureunit"), (String)"bd_measureunits") : null;
            row.set("asst_measureunit", (Object)measureunit);
            DynamicObject baseunit = (Long)paramMap.get("baseunit") != 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)paramMap.get("baseunit"), (String)"bd_measureunits") : null;
            row.set("asst_baseunit", (Object)baseunit);
            row.set("asst_curverifyqty", paramMap.get("curverifyqty"));
            row.set("asst_quotation", paramMap.get("quotation"));
            row.set("asst_exchangerate", paramMap.get("exchangerate"));
            row.set("asst_basecurrency", paramMap.get("basecurrency"));
            row.set("asst_materialversion", paramMap.get("materialversion"));
            row.set("asst_modelnum", paramMap.get("modelnum"));
            row.set("asst_assistantattr", paramMap.get("assistantattr"));
            row.set("asst_configuredcode", paramMap.get("configuredcode"));
            row.set("asst_tracknumber", paramMap.get("tracknumber"));
            mainRows.add(row);
        }
        return mainRows.toArray(new DynamicObject[0]);
    }

    public static Set<Long> getVerifyRecordIds(Long[] mainIds, Long[] asstIds, boolean isAr) {
        String entityName = isAr ? "ar_verifyrecord" : "ap_verifyrecord";
        QFilter filter = new QFilter("billid", "in", (Object)mainIds);
        filter.and(new QFilter("entry.e_billid", "in", (Object)asstIds));
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filter.toArray());
        return Arrays.stream(verifyRecords).map(verifyRecord -> verifyRecord.getLong("id")).collect(Collectors.toSet());
    }
}

