/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.unittest.scene.upgrade;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.unittest.DisplayName;
import kd.bos.form.unittest.TestMethod;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.unittest.AbstractJUnitTestWithOutFormPlugIn;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.UpgradeDataRangeEnum;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.unittest.framework.dataprovider.FinApBillTestDataProvider;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.BatchUpdateParam;
import org.junit.Test;

public class ArApUpgradeConfigTest
extends AbstractJUnitTestWithOutFormPlugIn {
    private static final int COUNT = 10;

    @TestMethod(value=1)
    @DisplayName(value="prepare")
    @Test
    public void prepare() {
        DeleteServiceHelper.delete((String)"arap_upgradeconfig", (QFilter[])new QFilter[]{new QFilter("plugin", "in", Arrays.asList("kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest", "kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest_0"))});
        for (int i = 0; i < 10; ++i) {
            String billNo = DateUtils.formatString(new Date(), "yyyy-MM-dd") + "_prepare_" + i;
            FinApBillTestDataProvider.buildByHeadPriceTaxTotal(billNo, BigDecimal.ONE);
            String billNo_0 = DateUtils.formatString(new Date(), "yyyy-MM-dd") + "_prepare_0_" + i;
            FinApBillTestDataProvider.buildByHeadPriceTaxTotal(billNo_0, BigDecimal.ONE);
        }
        QFilter filter = new QFilter("key", "=", (Object)"UpgradeConfigDataCount");
        filter.and("value", "=", (Object)"400000");
        if (!QueryServiceHelper.exists((String)"ap_stdconfig", (QFilter[])new QFilter[]{filter})) {
            String deleteSql = "DELETE FROM t_ap_stdconfig WHERE FKEY = 'UpgradeConfigDataCount';";
            String insertSql = "INSERT INTO t_ap_stdconfig(FID,FVALUE,FKEY,FDESC) VALUES (1515074390851586048,'400000','UpgradeConfigDataCount','\u6570\u636e\u5347\u7ea7\u903b\u8f91\uff0c\u6a21\u62df\u6bcf\u4e2a\u6708\u7528\u6237\u4ea7\u751f40w\u6570\u636e');";
            DB.execute((DBRoute)DBRouteConst.AP, (String)deleteSql);
            DB.execute((DBRoute)DBRouteConst.AP, (String)insertSql);
            ConfigCache.remove("ap_stdconfig", "UpgradeConfigDataCount");
        }
        ArApUpgradeConfigTest.assertEquals((boolean)true, (boolean)true);
    }

    @TestMethod(value=2)
    @DisplayName(value="insertTaskAndAutoExecute")
    @Test
    public void onlyInsetOneConfig() {
        BatchUpdateParam batchUpdateParam = new BatchUpdateParam();
        batchUpdateParam.setBizObj("ap_finapbill");
        batchUpdateParam.setPlugin("kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest");
        batchUpdateParam.setUpgradeDataRange(UpgradeDataRangeEnum.ALL);
        batchUpdateParam.setOnlyInsertConfig(true);
        UpgradeConfigHelper.batchExecute(batchUpdateParam);
        QFilter filter1 = new QFilter("plugin", "=", (Object)"kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest");
        ArApUpgradeConfigTest.assertEquals((String)"\u5927\u6570\u636e\u91cf\u4e0b\u6570\u636e\u81ea\u52a8\u5206\u6279\u521b\u5efa\u540e\u53f0\u4efb\u52a1\u5931\u8d25", (boolean)true, (boolean)QueryServiceHelper.exists((String)"arap_upgradeconfig", (QFilter[])new QFilter[]{filter1}));
        BatchUpdateParam batchUpdateParam1 = new BatchUpdateParam();
        batchUpdateParam1.setBizObj("ap_finapbill");
        batchUpdateParam1.setPlugin("kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest_0");
        batchUpdateParam1.setUpgradeDataRange(UpgradeDataRangeEnum.ALL);
        batchUpdateParam1.setOnlyInsertConfig(true);
        UpgradeConfigHelper.batchExecute(batchUpdateParam1);
        QFilter filter = new QFilter("plugin", "=", (Object)"kd.fi.arapcommon.unittest.scene.upgrade.ArApUpgradeConfigDemoTest_0");
        ArApUpgradeConfigTest.assertEquals((String)"\u5927\u6570\u636e\u91cf\u4e0b\u6570\u636e\u81ea\u52a8\u5206\u6279\u521b\u5efa\u540e\u53f0\u4efb\u52a1\u5931\u8d25", (boolean)true, (boolean)QueryServiceHelper.exists((String)"arap_upgradeconfig", (QFilter[])new QFilter[]{filter}));
    }

    @TestMethod(value=3)
    @DisplayName(value="upgrade")
    @Test
    public void upgrade() throws InterruptedException {
        String remark = DateUtils.formatString(new Date(), "yyyy-MM-dd");
        QFilter filter = new QFilter("remark", "=", (Object)remark);
        filter.and("billno", "ilike", (Object)(DateUtils.formatString(new Date(), "yyyy-MM-dd") + "_prepare%"));
        Thread.sleep(10000L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryfinbillcount", (String)"ap_finapbill", (String)"count(1)", (QFilter[])new QFilter[]{filter}, (String)"");
        ArApUpgradeConfigTest.assertEquals((String)"\u6570\u636e\u5347\u7ea7\u5931\u8d25", (boolean)true, (dataSet.next().getInteger("count(1)") >= 20 ? 1 : 0) != 0);
    }
}

