/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.upgrade.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.upgrade.AbstractSplitHandle;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class BizDescriptionBaseUpgrade
extends AbstractSplitHandle
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BizDescriptionBaseUpgrade.class);
    public static final int UPGRADE_CNT = 1000000;
    protected String journalTableName;

    public String getJournalTableName() {
        if (this.journalTableName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u7c7b\u8981\u8986\u76d6\u8be5\u65b9\u6cd5\uff0c\u83b7\u53d6\u6d41\u6c34\u8868\u540d\u3002", (String)"BizDescriptionBaseUpgrade_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return this.journalTableName;
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("---upgrade.params[ver={}, iteration={}, dbKey={}, sqlFileName={}]", new Object[]{ver, iteration, dbKey, sqlFileName});
        String log = "";
        try {
            this.upgrade();
        }
        catch (Exception e) {
            log = ArApHelper.getStackTraceMessage(e);
        }
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        upgradeResult.setLog(log);
        return upgradeResult;
    }

    public String upgrade() {
        this.journalTableName = this.getJournalTableName();
        this.dbRoute = DBRouteConst.AP;
        this.sql = this.getSql(this.journalTableName);
        Map<String, Object> rusult = this.execute();
        return (String)rusult.get("message");
    }

    protected String getSql(String journalTableName) {
        return null;
    }

    @Override
    protected int getUpgradeCnt() {
        return 1000000;
    }

    @Override
    protected Map<String, Object> doProcess(DataSet subDataSet) {
        int updateCnt;
        HashMap<String, Object> subResult = new HashMap<String, Object>(2);
        List<Map<String, Object>> journals = this.getJournals(subDataSet);
        int subCnt = journals.size();
        if (subCnt != (updateCnt = this.doUpgrade(journals))) {
            // empty if block
        }
        subResult.put("exeCnt", updateCnt);
        return subResult;
    }

    private int doUpgrade(List<Map<String, Object>> journals) {
        int updateCnt = 0;
        try (TXHandle tx = TX.requiresNew();){
            try {
                updateCnt = this.execute(journals);
            }
            catch (Exception e) {
                logger.error("---upgrade.error", (Throwable)e);
                String log = ArApHelper.getStackTraceMessage(e);
                tx.markRollback();
                throw new KDBizException(log);
            }
        }
        return updateCnt;
    }

    private int execute(List<Map<String, Object>> journals) {
        int updateCnt = 0;
        Map<String, List<Map>> journalMap = journals.stream().collect(Collectors.groupingBy(j -> (String)j.get("sourcebilltype")));
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(64);
        for (Map.Entry<String, List<Map>> entry : journalMap.entrySet()) {
            Map<String, List<Long>> asstSettleMap;
            List<Object[]> upAsstJournals;
            List<Map<String, Object>> asstJournals;
            Map<String, List<Long>> mainSettleMap;
            List<Object[]> upMainJournals;
            String key = entry.getKey();
            List<Map<String, Object>> journalList = entry.getValue();
            Set<Long> idSet = journalList.stream().map(m -> (Long)m.get("sourcebillid")).collect(Collectors.toSet());
            if ("cas_paybill".equals(key) || "ap_paidbill".equals(key)) {
                List<Object[]> payParams = this.getBizDescription4Pay(key, idSet, journalList);
                if (payParams.isEmpty()) continue;
                updateParams.addAll(payParams);
                continue;
            }
            if ("cas_recbill".equals(key) || "ar_receivedbill".equals(key)) {
                List<Object[]> recParams = this.getBizDescription4Rec(key, idSet, journalList);
                if (recParams.isEmpty()) continue;
                updateParams.addAll(recParams);
                continue;
            }
            if (!"ap_settlerecord".equals(key) && !"ar_settlerecord".equals(key)) continue;
            List<Map<String, Object>> settles = this.getSettles(idSet);
            List<Map<String, Object>> mainJournals = journalList.stream().filter(j -> EmptyUtils.isEmpty(j.get("sourceentryid"))).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(mainJournals) && !(upMainJournals = this.getBizDescription4Settle(mainJournals, mainSettleMap = settles.stream().collect(Collectors.groupingBy(s -> (String)s.get("billentity"), Collectors.mapping(sr -> (Long)sr.get("mainbillid"), Collectors.toList()))), settles, true)).isEmpty()) {
                updateParams.addAll(upMainJournals);
            }
            if (ObjectUtils.isEmpty(asstJournals = journalList.stream().filter(j -> EmptyUtils.isNotEmpty(j.get("sourceentryid"))).collect(Collectors.toList())) || (upAsstJournals = this.getBizDescription4Settle(asstJournals, asstSettleMap = settles.stream().filter(s -> EmptyUtils.isNotEmpty(s.get("e_billentity"))).collect(Collectors.groupingBy(s -> (String)s.get("e_billentity"), Collectors.mapping(sr -> (Long)sr.get("e_billid"), Collectors.toList()))), settles, false)).isEmpty()) continue;
            updateParams.addAll(upAsstJournals);
        }
        if (!updateParams.isEmpty()) {
            String updateSql = "update " + this.journalTableName + " SET fbizdescription = ? WHERE fid = ?";
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)updateSql, updateParams);
            updateCnt = updateParams.size();
        }
        return updateCnt;
    }

    private List<Object[]> getBizDescription4Settle(List<Map<String, Object>> journals, Map<String, List<Long>> settleMap, List<Map<String, Object>> settles, boolean isMain) {
        ArrayList<Object[]> upJournals = new ArrayList<Object[]>(64);
        List<Long> payPks = settleMap.get("cas_paybill");
        DataSet paybills = this.getPayDataSet("cas_paybill", payPks);
        List<Long> paidPks = settleMap.get("ap_paidbill");
        DataSet paidbills = this.getPayDataSet("ap_paidbill", paidPks);
        DataSet payUnion = paybills.union(paidbills);
        List<Long> recPks = settleMap.get("cas_recbill");
        DataSet recbills = this.getRecDataSet("cas_recbill", recPks);
        List<Long> prePks = settleMap.get("ar_receivedbill");
        DataSet prebills = this.getRecDataSet("ar_receivedbill", prePks);
        DataSet recUnion = recbills.union(prebills);
        for (Map<String, Object> journal : journals) {
            String bizDescription = null;
            if (isMain) {
                Long sourceBillId = (Long)journal.get("sourcebillid");
                for (Map<String, Object> settle : settles) {
                    if (!sourceBillId.equals(settle.get("id"))) continue;
                    bizDescription = this.getBizDescription((String)settle.get("billentity"), (Long)settle.get("mainbillid"), payUnion, recUnion);
                    break;
                }
            } else {
                Long sourceEntryId = (Long)journal.get("sourceentryid");
                for (Map<String, Object> settle : settles) {
                    if (!sourceEntryId.equals(settle.get("entryid"))) continue;
                    bizDescription = this.getBizDescription((String)settle.get("e_billentity"), (Long)settle.get("e_billid"), payUnion, recUnion);
                    break;
                }
            }
            if (bizDescription == null) continue;
            upJournals.add(new Object[]{bizDescription, journal.get("id")});
        }
        return upJournals;
    }

    private String getBizDescription(String billEntity, Long billPk, DataSet paybills, DataSet recbills) {
        String bizType;
        String bizDescription = BizDescriptionEnum.fin_woff.name();
        if ("cas_paybill".equals(billEntity) || "ap_paidbill".equals(billEntity)) {
            String bizType2 = this.findBizType(billPk, paybills);
            if (bizType2 != null) {
                bizDescription = "202".equals(bizType2) ? BizDescriptionEnum.paid_woff.name() : BizDescriptionEnum.pay_woff.name();
            }
        } else if (("cas_recbill".equals(billEntity) || "ar_receivedbill".equals(billEntity)) && (bizType = this.findBizType(billPk, recbills)) != null) {
            bizDescription = "101".equals(bizType) ? BizDescriptionEnum.received_woff.name() : BizDescriptionEnum.rec_woff.name();
        }
        return bizDescription;
    }

    private String findBizType(Long billPk, DataSet dataSet) {
        String bizType = null;
        for (Row row : dataSet.copy()) {
            if (!billPk.equals(row.getLong("fid"))) continue;
            bizType = row.getString("fbiztype");
            if (!EmptyUtils.isEmpty(bizType)) break;
            bizType = "";
            break;
        }
        return bizType;
    }

    private List<Map<String, Object>> getSettles(Set<Long> idSet) {
        ArrayList<Map<String, Object>> settles = new ArrayList<Map<String, Object>>(16);
        StringBuilder sql = new StringBuilder();
        sql.append("select head.fid, head.fmainbillentity fbillentity, head.fmainbillid, ");
        sql.append("entry.fentryid, entry.fbillentity e_billentity, entry.fbillid ");
        sql.append("from t_ap_settlerecord head ");
        sql.append("left join t_ap_settlerecordentry entry on entry.fid = head.fid ");
        sql.append("where head.fid in (").append(StringUtils.join(idSet, (char)',')).append(')');
        DataSet settleRecords = DB.queryDataSet((String)"getSettles", (DBRoute)DBRouteConst.AP, (String)sql.toString());
        for (Row row : settleRecords) {
            Map<String, Object> settle = this.buildSettle(row);
            settles.add(settle);
        }
        return settles;
    }

    private Map<String, Object> buildSettle(Row row) {
        HashMap<String, Object> settle = new HashMap<String, Object>(16);
        settle.put("id", row.getLong("fid"));
        settle.put("billentity", row.getString("fbillentity"));
        settle.put("mainbillid", row.getLong("fmainbillid"));
        settle.put("entryid", row.getLong("fentryid"));
        settle.put("e_billentity", row.getString("e_billentity"));
        settle.put("e_billid", row.getLong("fbillid"));
        return settle;
    }

    private List<Object[]> getBizDescription4Rec(String entityKey, Set<Long> idSet, List<Map<String, Object>> journalList) {
        ArrayList<Object[]> upJournals = new ArrayList<Object[]>(64);
        DataSet recbills = this.getRecDataSet(entityKey, idSet);
        if (recbills.hasNext()) {
            for (Map<String, Object> journal : journalList) {
                Long sourceBillId = (Long)journal.get("sourcebillid");
                String bizDescription = null;
                for (Row recbill : recbills.copy()) {
                    if (!sourceBillId.equals(recbill.getLong("fid"))) continue;
                    bizDescription = "101".equals(recbill.getString("fbiztype")) ? BizDescriptionEnum.received.name() : BizDescriptionEnum.rec.name();
                    break;
                }
                if (bizDescription == null) continue;
                upJournals.add(new Object[]{bizDescription, journal.get("id")});
            }
        }
        return upJournals;
    }

    private List<Object[]> getBizDescription4Pay(String entityKey, Set<Long> idSet, List<Map<String, Object>> journalList) {
        ArrayList<Object[]> upJournals = new ArrayList<Object[]>(64);
        DataSet paybills = this.getPayDataSet(entityKey, idSet);
        if (paybills.hasNext()) {
            for (Map<String, Object> journal : journalList) {
                Long sourceBillId = (Long)journal.get("sourcebillid");
                String bizDescription = null;
                for (Row paybill : paybills.copy()) {
                    if (!sourceBillId.equals(paybill.getLong("fid"))) continue;
                    bizDescription = "202".equals(paybill.getString("fbiztype")) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
                    break;
                }
                if (bizDescription == null) continue;
                upJournals.add(new Object[]{bizDescription, journal.get("id")});
            }
        }
        return upJournals;
    }

    private DataSet getPayDataSet(String entityKey, Collection<Long> pks) {
        StringBuilder sql = new StringBuilder();
        sql.append("select pay.fid as fid, ptype.fbiztype as fbiztype ");
        if ("cas_paybill".equals(entityKey)) {
            sql.append("from t_cas_paymentbill pay ");
        } else {
            sql.append("from t_ap_paidbill pay ");
        }
        sql.append("left join t_cas_paymentbilltype ptype on ptype.fid = pay.fpaymenttypeid ");
        sql.append("where pay.fid in (").append(StringUtils.join(pks, (char)',')).append(')');
        return DB.queryDataSet((String)"getPayBill", (DBRoute)DBRouteConst.AP, (String)sql.toString());
    }

    private DataSet getRecDataSet(String entityKey, Collection<Long> pks) {
        StringBuilder sql = new StringBuilder();
        sql.append("select rec.fid as fid, rtype.fbiztype as fbiztype ");
        if ("cas_recbill".equals(entityKey)) {
            sql.append("from t_cas_receivingbill rec ");
            sql.append("left join T_CAS_ReceivingBillType rtype on rtype.fid = rec.FReceivingTypeID ");
        } else {
            sql.append("from t_ar_receivedbill rec ");
            sql.append("left join T_CAS_ReceivingBillType rtype on rtype.fid = rec.frectypeid ");
        }
        sql.append("where rec.fid in (").append(StringUtils.join(pks, (char)',')).append(')');
        return DB.queryDataSet((String)"getRecBill", (DBRoute)DBRouteConst.AR, (String)sql.toString());
    }

    private List<Map<String, Object>> getJournals(DataSet subDataSet) {
        ArrayList<Map<String, Object>> journals = new ArrayList<Map<String, Object>>(64);
        for (Row row : subDataSet) {
            if (!EmptyUtils.isNotEmpty(row.getString("fsourcebilltype"))) continue;
            Map<String, Object> journal = this.buildJournal(row);
            journals.add(journal);
        }
        return journals;
    }

    private Map<String, Object> buildJournal(Row row) {
        HashMap<String, Object> journal = new HashMap<String, Object>(5);
        journal.put("id", row.getLong("fid"));
        journal.put("sourcebilltype", row.getString("fsourcebilltype"));
        journal.put("sourcebillid", row.getLong("fsourcebillid"));
        journal.put("sourceentryid", row.getLong("fsourceentryid"));
        journal.put("billno", row.getString("fbillno"));
        return journal;
    }
}

