/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.util.StdConfig;

public class AES128 {
    private static final Log logger = LogFactory.getLog(AES128.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String ENCODING = "UTF-8";

    public static String encrypt(String content, String encryptPass) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, AES128.getSecretKey(encryptPass));
            byte[] iv = cipher.getIV();
            assert (iv.length == 12);
            byte[] encryptData = cipher.doFinal(content.getBytes(ENCODING));
            assert (encryptData.length == content.getBytes(ENCODING).length + 16);
            byte[] message = new byte[12 + content.getBytes(ENCODING).length + 16];
            System.arraycopy(iv, 0, message, 0, 12);
            System.arraycopy(encryptData, 0, message, 12, encryptData.length);
            return Base64.getEncoder().encodeToString(message);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static String encrypt4Download(String content, String password) throws Exception {
        if ((password = password + "").length() != 16) {
            System.out.print(ResManager.loadKDString((String)"Key\u957f\u5ea6\u4e0d\u662f16\u4f4d", (String)"AES128_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return "";
        }
        byte[] raw = password.getBytes("utf-8");
        SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(StdConfig.get("invoicecloud.invoiceEasCipher"));
        cipher.init(1, skeySpec);
        byte[] encrypted = cipher.doFinal(content.getBytes("utf-8"));
        return new org.apache.commons.codec.binary.Base64().encodeToString(encrypted);
    }

    public static String decrypt(String base64Content, String encryptPass) {
        byte[] content = Base64.getDecoder().decode(base64Content);
        if (content.length < 28) {
            throw new IllegalArgumentException();
        }
        GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, (Key)AES128.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData, ENCODING);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return "";
        }
    }

    public static SecretKeySpec getSecretKey(String encryptPass) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(encryptPass.getBytes(ENCODING));
        kg.init(128, random);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }
}

