/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.fi.arapcommon.util.EmptyUtils;

public class CollectionUtils {
    public static <T> T[] mergeArrays(T[] t1, T[] t2) {
        T[] copyOf = Arrays.copyOf(t1, t1.length + t2.length);
        for (int i = 0; i < t2.length; ++i) {
            copyOf[i + t1.length] = t2[i];
        }
        return copyOf;
    }

    public static void removeIgnoreCase(List<String> list, String ... items) {
        Iterator<String> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            String next = iterator.next();
            for (String item : items) {
                if (!next.equalsIgnoreCase(item)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static <T> List<List<T>> partition(List<T> source, int n) {
        List<List<T>> result = new ArrayList<List<T>>(0);
        if (EmptyUtils.isEmpty(source)) {
            return result;
        }
        if (n <= 0) {
            return result;
        }
        int limit = (source.size() + n - 1) / n;
        result = ((Stream)Stream.iterate(0, i -> i + 1).limit(limit).parallel()).map(a -> ((Stream)source.stream().skip(a * n).limit(n).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
        return result;
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(0);
        if (EmptyUtils.isEmpty(source)) {
            return result;
        }
        if (n <= 0) {
            return result;
        }
        int size = source.size();
        n = n > size ? size : n;
        int remaider = size % n;
        int number = size / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remaider > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remaider;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

