/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckFactory;
import kd.fi.arapcommon.check.base.DataCheckService;
import kd.fi.arapcommon.check.base.HealthCheckFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.util.EmptyUtils;

public class DataCheckUtils {
    private static Set<String> oppositeSettleRelations = new HashSet<String>(16);
    private static Set<String> settleRelations = new HashSet<String>(16);

    private static void initOppositeSettleRelations() {
        oppositeSettleRelations.add(SettleRelationEnum.APSELF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.APWRITEOFF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.ARSELF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.ARWRITEOFF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.PAYSELF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.RECSELF.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        oppositeSettleRelations.add(SettleRelationEnum.APRECSETTLE.getValue());
    }

    private static void initSettleRelations() {
        settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.RECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.APARSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.ARAPSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.PAYTRANS.getValue());
        settleRelations.add(SettleRelationEnum.ARTRANSFER.getValue());
        settleRelations.add(SettleRelationEnum.RECPAYSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.PAYRECSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.PREMSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.BADDEBTLOSS.getValue());
        settleRelations.add(SettleRelationEnum.BADDEBTRECOVERY.getValue());
        settleRelations.add(SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue());
        settleRelations.add(SettleRelationEnum.APLIQUIDATIONSETTLE.getValue());
    }

    public static Set<String> listOppositeSettleRelation() {
        return oppositeSettleRelations;
    }

    public static Set<String> listSettleRelation() {
        return settleRelations;
    }

    public static QFilter getQFilter(HealthCheckFilter checkFilter) {
        String moreFilerVal;
        if (EmptyUtils.isEmpty(checkFilter)) {
            return null;
        }
        QFilter filter = new QFilter("org", "in", checkFilter.getOrgIds());
        if (EmptyUtils.isNotEmpty(checkFilter.getStartDate())) {
            filter.and(new QFilter("createtime", ">=", (Object)checkFilter.getStartDate()));
        }
        if (EmptyUtils.isNotEmpty(checkFilter.getEndDate())) {
            filter.and(new QFilter("createtime", "<=", (Object)checkFilter.getEndDate()));
        }
        if (EmptyUtils.isNotEmpty(moreFilerVal = checkFilter.getMoreFilterVal())) {
            filter.and(DataCheckUtils.buildQFilter(moreFilerVal, checkFilter.getEntityNumber()));
        }
        return filter;
    }

    private static QFilter buildQFilter(String conditionVal, String billEntityName) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionVal, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        QFilter qfilter = filterBuilder.getQFilter();
        if (EmptyUtils.isNotEmpty(condition.getExpression())) {
            QFilter of = QFilter.of((String)condition.getExpression(), (Object[])new Object[0]);
            qfilter = EmptyUtils.isEmpty(qfilter) ? of : qfilter.and(of);
        }
        return qfilter;
    }

    public static CheckResult getCheckResult(DynamicObject entity, QFilter filter) {
        String classPath = entity.getString("checkitem.plugin");
        DataCheckService dataCheck = DataCheckFactory.getDataCheckInstance(classPath);
        CheckResult checkResult = new CheckResult();
        if (dataCheck == null) {
            checkResult.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5de1\u67e5\u63d2\u4ef6\u3002", (String)"DataCheckUtils_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return checkResult;
        }
        dataCheck.setQFilter(filter);
        checkResult = dataCheck.getCheckResult();
        return checkResult;
    }

    public static QFilter generateNewSettleQFilter(QFilter filter) {
        QFilter result = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
        for (QFilter.QFilterNest nest : filter.getNests(false)) {
            String property = nest.getFilter().getProperty();
            if ("createtime".equals(property)) {
                result.and(new QFilter("settledate", nest.getFilter().getCP(), nest.getFilter().getValue()));
                continue;
            }
            result.and(new QFilter(nest.getFilter().getProperty(), nest.getFilter().getCP(), nest.getFilter().getValue()));
        }
        return result;
    }

    public static QFilter generateNewJournalQFilter(QFilter filter) {
        QFilter result = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
        for (QFilter.QFilterNest nest : filter.getNests(false)) {
            String property = nest.getFilter().getProperty();
            if ("createtime".equals(property)) {
                result.and(new QFilter("bizdate", nest.getFilter().getCP(), nest.getFilter().getValue()));
                continue;
            }
            result.and(new QFilter(nest.getFilter().getProperty(), nest.getFilter().getCP(), nest.getFilter().getValue()));
        }
        return result;
    }

    static {
        DataCheckUtils.initOppositeSettleRelations();
        DataCheckUtils.initSettleRelations();
    }
}

