/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.fi.arapcommon.enums.BillOperationEnum;
import kd.fi.arapcommon.util.StdConfig;

public class OperationUtils {
    private static final List<BillOperationEnum> defaultLimitedOperationList = new ArrayList<BillOperationEnum>(16);

    public static boolean hasOperationPermission(String appId, String entityName, BillOperationEnum operationEnum) {
        boolean hasOperationPermission = true;
        if ("dhc".equalsIgnoreCase(appId)) {
            hasOperationPermission = OperationUtils.listBillEnableOperation(entityName).contains((Object)operationEnum);
        }
        return hasOperationPermission;
    }

    private static List<String> listBillUnVisibleButton(String entityName) {
        List<String> listButton = Collections.emptyList();
        if (!ObjectUtils.isEmpty((Object)entityName)) {
            switch (entityName) {
                case "ar_finarbill": {
                    listButton = Arrays.asList("bar_save4writeoff", "bar_audit", "tblwriteoff", "liquidate", "transfer", "tblloss", "calculatetaxcbtn", "tracevoucher", "viewsettle", "tracetxlog", "viewver_arrev", "viewvr_oriwf", "viewvr_saloutwf", "bar_generatevoucher", "bar_adjust", "handsettle");
                    break;
                }
                case "ar_busbill": {
                    listButton = Arrays.asList("tracevoucher", "bar_save4woff", "bar_audit", "bar_woff", "calculatetaxcbtn", "bar_generatevoucher");
                    break;
                }
                case "ar_invoice": {
                    listButton = Arrays.asList("bar_applyissue", "tblinvmanage", "bar_confirminvoiced", "bar_audit", "bar_pushar");
                    break;
                }
                case "ap_finapbill": {
                    listButton = Arrays.asList("calculatetaxcbtn", "tracetxlog", "bar_save4writeoff", "bar_audit", "bar_adjust", "tblwriteoff", "liquidate", "transferpay", "transferall", "handsettle", "bar_generatevoucher", "tracevoucher", "viewver", "viewsettle");
                    break;
                }
                case "ap_busbill": {
                    listButton = Arrays.asList("calculatetaxcbtn", "bar_save4woff", "bar_audit", "bar_woff", "revaluation", "bar_generatevoucher", "tracevoucher");
                    break;
                }
                case "ap_invoice": {
                    listButton = Collections.singletonList("bar_match");
                    break;
                }
                case "ap_payapply": {
                    String ignoreApplyPayCheck = StdConfig.get("ignoreapplypaycheck");
                    if ("true".equalsIgnoreCase(ignoreApplyPayCheck)) break;
                    listButton = Collections.singletonList("bar_audit");
                }
            }
        }
        return listButton;
    }

    public static void setButtonUnvisibleByAppId(String entityName, IFormView formView) {
        String appId = formView.getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId)) {
            List<String> billUnVisibleButtonList = OperationUtils.listBillUnVisibleButton(entityName);
            formView.setVisible(Boolean.FALSE, billUnVisibleButtonList.toArray(new String[0]));
        }
    }

    private static List<String> listBillListUnVisibleButton(String entityName) {
        List<String> listButton = Collections.emptyList();
        if (!ObjectUtils.isEmpty((Object)entityName)) {
            switch (entityName) {
                case "ar_finarbill": {
                    listButton = Arrays.asList("tblcheck", "tbladjust", "batchcalculatetaxcbtn", "tblgeneratevoucher", "tblwriteoff", "liquidate", "transfer", "tblloss", "handsettle", "tracevoucher", "viewsettle", "tracetxlog", "viewver_arrev", "viewvr_oriwf", "viewvr_saloutwf");
                    break;
                }
                case "ar_busbill": {
                    listButton = Arrays.asList("tbl_woff", "tblcheck", "matchverify", "batchcalculatetaxcbtn", "tblgeneratevoucher", "tracevoucher");
                    break;
                }
                case "ar_invoice": {
                    listButton = Arrays.asList("tblcheck", "tblpushap", "tbl_issue", "tblinvmanage", "tblconfirminvoiced", "tblrecreate");
                    break;
                }
                case "ap_finapbill": {
                    listButton = Arrays.asList("tblcheck", "tbladjust", "batchcalculatetaxcbtn", "tblgeneratevoucher", "tblwriteoff", "liquidate", "transferpay", "transferall", "handsettle", "tblgotopurinvoice", "tracevoucher", "viewver", "viewsettle", "bar_searchlog", "tracetxlog");
                    break;
                }
                case "ap_busbill": {
                    listButton = Arrays.asList("tbl_woff", "tblcheck", "matchverify", "batchcalculatetaxcbtn", "tblgeneratevoucher", "revaluation", "tracevoucher");
                    break;
                }
                case "ap_invoice": {
                    listButton = Arrays.asList("tracetxlog", "tblmatch");
                    break;
                }
                case "ap_payapply": {
                    String ignoreApplyPayCheck = StdConfig.get("ignoreapplypaycheck");
                    if ("true".equalsIgnoreCase(ignoreApplyPayCheck)) break;
                    listButton = Collections.singletonList("tblcheck");
                }
            }
        }
        return listButton;
    }

    public static void setListButtonUnvisibleByAppId(String entityName, IFormView formView) {
        String appId = formView.getFormShowParameter().getAppId();
        if ("dhc".equalsIgnoreCase(appId)) {
            List<String> billListUnVisibleButtonList = OperationUtils.listBillListUnVisibleButton(entityName);
            formView.setVisible(Boolean.FALSE, billListUnVisibleButtonList.toArray(new String[0]));
        }
    }

    private static List<BillOperationEnum> listBillEnableOperation(String entityName) {
        List<BillOperationEnum> billLimitOperation = defaultLimitedOperationList;
        if ("ap_invoice".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.AUDIT, BillOperationEnum.UN_AUDIT, BillOperationEnum.ASSIGN, BillOperationEnum.CANCEL_ASSIGN);
        }
        if ("ap_finapbill".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.ASSIGN, BillOperationEnum.CANCEL_ASSIGN, BillOperationEnum.INVDIFFADJUST);
        }
        if ("ar_finarbill".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.COORDINATEAPADJUST);
        }
        if ("ap_busbill".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.WOFF, BillOperationEnum.BATCHWOFF, BillOperationEnum.WOFFBILL);
        }
        if ("ar_busbill".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.WOFF, BillOperationEnum.BATCHWOFF);
        }
        if ("ap_payapply".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.ASSIGN, BillOperationEnum.CANCEL_ASSIGN);
        }
        if ("ar_invoice".equalsIgnoreCase(entityName)) {
            billLimitOperation = Arrays.asList(BillOperationEnum.NEW, BillOperationEnum.COPY, BillOperationEnum.SAVE, BillOperationEnum.DELETE, BillOperationEnum.SUBMIT, BillOperationEnum.UN_SUBMIT, BillOperationEnum.AUDIT, BillOperationEnum.UN_AUDIT, BillOperationEnum.ISSUE, BillOperationEnum.ISSUE_PRINT, BillOperationEnum.CANCEL_INVOICED, BillOperationEnum.SUBMITCLOUD, BillOperationEnum.SYNCDATA, BillOperationEnum.APPLY_ABANDON, BillOperationEnum.CONFIRM_ABANDON, BillOperationEnum.CANCEL_ABANDON);
        }
        if ("ar_transferofcredit".equalsIgnoreCase(entityName)) {
            billLimitOperation = Collections.singletonList(BillOperationEnum.TRANSFER);
        }
        return billLimitOperation;
    }

    static {
        defaultLimitedOperationList.add(BillOperationEnum.NEW);
        defaultLimitedOperationList.add(BillOperationEnum.COPY);
        defaultLimitedOperationList.add(BillOperationEnum.SAVE);
        defaultLimitedOperationList.add(BillOperationEnum.SUBMIT);
        defaultLimitedOperationList.add(BillOperationEnum.DELETE);
        defaultLimitedOperationList.add(BillOperationEnum.UN_SUBMIT);
    }
}

