/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.StringUtils;

public class QueryUtil {
    private final Map<String, Object> queryResultCache = new HashMap<String, Object>(8);

    public DynamicObject getInitObj(long orgId, String initEntity) {
        if (orgId == 0L || StringUtils.isEmpty(initEntity)) {
            return null;
        }
        String key = "getInitObj_" + orgId + "_" + initEntity;
        Object initObj = this.queryResultCache.get(key);
        if (initObj == null) {
            InitHelper initHelper = new InitHelper(orgId, initEntity);
            initObj = initHelper.getInit();
            this.queryResultCache.put(key, initObj);
        }
        return (DynamicObject)initObj;
    }

    public DynamicObject getBaseDataByPk(long pk, String entity) {
        if (pk == 0L || StringUtils.isEmpty(entity)) {
            return null;
        }
        String key = "getBaseDataByPk_" + pk + "_" + entity;
        Object baseData = this.queryResultCache.get(key);
        if (baseData == null) {
            baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)entity);
            this.queryResultCache.put(key, baseData);
        }
        return (DynamicObject)baseData;
    }

    public BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        if (materialId == null || srcUnitId == null || desUnitId == null || materialId == 0L || srcUnitId == 0L || desUnitId == 0L) {
            return BigDecimal.ONE;
        }
        String key = "getConvertRate_" + materialId + "_" + srcUnitId + "_" + desUnitId;
        Object convertRate = this.queryResultCache.get(key);
        if (convertRate == null) {
            convertRate = UnitConvertHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
            this.queryResultCache.put(key, convertRate);
        }
        return (BigDecimal)convertRate;
    }

    public boolean getRateConversionConfig(Long originalCurrency, Long targetCurrency, Date conversionDate) {
        if (originalCurrency == null || targetCurrency == null || conversionDate == null) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = "getRateConversionConfig_" + originalCurrency + "_" + targetCurrency + "_" + sdf.format(conversionDate);
        Object rateConversionConfig = this.queryResultCache.get(key);
        if (rateConversionConfig == null) {
            rateConversionConfig = BaseDataServiceHelper.getRateConversionConfig((Long)originalCurrency, (Long)targetCurrency, (Date)conversionDate);
            this.queryResultCache.put(key, rateConversionConfig);
        }
        return (Boolean)rateConversionConfig;
    }

    public BigDecimal getExchangeRate(Long exrateTableId, Long srcCurrencyId, Long destCurrencyId, String convertMode, Date exrateDate) {
        if (exrateTableId == null || srcCurrencyId == null || destCurrencyId == null || StringUtils.isEmpty(convertMode) || exrateDate == null) {
            return BigDecimal.ONE;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = "getExchangeRate_" + srcCurrencyId + "_" + destCurrencyId + "_" + exrateTableId + "_" + convertMode + "_" + sdf.format(exrateDate);
        Object exchangeRate = this.queryResultCache.get(key);
        if (exchangeRate == null) {
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exrateTableId, (Date)exrateDate);
            if (exchangeRateMap != null) {
                exchangeRate = exchangeRateMap.get("exchangeRate");
            }
            this.queryResultCache.put(key, exchangeRate);
        }
        return (BigDecimal)exchangeRate;
    }

    public Map<Object, DynamicObject> getBatchBaseDataMap(Set<Long> pks, String entity, String selector) {
        Map<Object, Object> queryResult = new HashMap<Object, DynamicObject>(8);
        if (ObjectUtils.isEmpty(pks) || StringUtils.isEmpty(entity) || StringUtils.isEmpty(selector)) {
            return queryResult;
        }
        queryResult = BusinessDataServiceHelper.loadFromCache((String)entity, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        return queryResult;
    }

    public Map<Object, DynamicObject> getBatchBillMap(Set<Long> pks, String entity, String selector) {
        Map<Object, DynamicObject> queryResult = new HashMap<Object, DynamicObject>(8);
        if (ObjectUtils.isEmpty(pks) || StringUtils.isEmpty(entity) || StringUtils.isEmpty(selector)) {
            return queryResult;
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)entity, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        queryResult = Arrays.stream(bills).collect(Collectors.toMap(DataEntityBase::getPkValue, bill -> bill));
        return queryResult;
    }

    public String getEntityNameByMainTableId(Long tableId) {
        Object entityName = this.queryResultCache.get(String.valueOf(tableId));
        if (ObjectUtils.isEmpty((Object)entityName)) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
            entityName = tableDefine.getEntityKey();
            this.queryResultCache.put(String.valueOf(tableId), entityName);
        }
        return String.valueOf(entityName);
    }
}

