/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class StringUtils {
    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String getEmpty() {
        return "";
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    public static String trim(String string) {
        return StringUtils.isNull(string) ? StringUtils.getEmpty() : string.trim();
    }

    public static String formatMessage(String msg, Object[] params) {
        return MessageFormat.format(msg, params);
    }

    public static String setToString(Set valueSet) {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append('(');
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(',');
                }
                returnValue.append('\'');
                returnValue.append(tempValue);
                returnValue.append('\'');
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(')');
        return returnValue.toString();
    }

    public static String setToString(DynamicObjectCollection value, String field) {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append('(');
        if (value != null && value.size() != 0) {
            boolean flag = false;
            for (DynamicObject obj : value) {
                if (flag) {
                    returnValue.append(',');
                }
                returnValue.append('\'');
                returnValue.append(obj.getString(field));
                returnValue.append('\'');
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(')');
        return returnValue.toString();
    }

    public static String listToString(List<String> fliedList) {
        return String.join((CharSequence)",", fliedList);
    }

    public static Object[] getPks(DynamicObject[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            pks[i] = objArray[i].getPkValue();
        }
        return pks;
    }

    public static Object[] getPks(DynamicObjectCollection objArray) {
        if (objArray == null || objArray.size() == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            pks[i] = ((DynamicObject)objArray.get(i)).getPkValue();
        }
        return pks;
    }

    public static String setToSelectorString(Set<String> valueSet) {
        return String.join((CharSequence)",", valueSet);
    }

    public static String removePrefix(String str, char c) {
        int index = str.indexOf(c);
        index = index > 0 ? ++index : 0;
        return str.substring(index);
    }

    public static String removePrefix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? ++index : 0;
        return str.substring(index);
    }

    public static String removeSubfix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? index : str.length();
        return str.substring(0, index);
    }

    public static String longSetToString(Set<Long> valueSet) {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append('(');
        if (valueSet != null && valueSet.size() != 0) {
            Iterator<Long> it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Long obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)((Object)obj) : ((Object)obj).toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(',');
                }
                returnValue.append(tempValue);
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(')');
        return returnValue.toString();
    }
}

