/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ViewUtils {
    public static void setVisible(AbstractFormPlugin plugin, boolean visible, String ... ctrlId) {
        for (int i = 0; i < ctrlId.length; ++i) {
            ViewUtils.innerSetVisible(plugin, visible, ctrlId[i]);
        }
    }

    private static void innerSetVisible(AbstractFormPlugin plugin, boolean visible, String ctrlId) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setVisible(Boolean.valueOf(visible), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            edit.setVisible("", visible);
        } else if (ctrl instanceof Container) {
            List<Control> subControls = ViewUtils.getSubControls((Container)ctrl);
            subControls.add(ctrl);
            String[] keys = new String[subControls.size()];
            for (int i = 0; i < subControls.size(); ++i) {
                keys[i] = subControls.get(i).getKey();
            }
            plugin.getView().setVisible(Boolean.valueOf(visible), keys);
        } else {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e%s\u7c7b\u578b\u63a7\u4ef6\u7684\u663e\u9690\u3002", (String)"ViewUtils_0", (String)"fi-arapcommon", (Object[])new Object[0]), ctrl.getClass().getName()));
        }
    }

    private static List<Control> getSubControls(Container control) {
        ArrayList<Control> result = new ArrayList<Control>();
        List items = control.getItems();
        for (Control item : items) {
            if (item instanceof Container) {
                result.addAll(ViewUtils.getSubControls((Container)item));
                continue;
            }
            result.add(item);
        }
        return result;
    }

    public static void setEnable(AbstractFormPlugin plugin, boolean enable, String ... ctrlId) {
        for (int i = 0; i < ctrlId.length; ++i) {
            ViewUtils.innerSetEnable(plugin, enable, ctrlId[i]);
        }
    }

    private static void innerSetEnable(AbstractFormPlugin plugin, boolean enable, String ctrlId) {
        Control ctrl = plugin.getView().getControl(ctrlId);
        if (ctrl == null || ctrl instanceof Button) {
            plugin.getView().setEnable(Boolean.valueOf(enable), new String[]{ctrlId});
        } else if (ctrl instanceof FieldEdit) {
            FieldEdit edit = (FieldEdit)ctrl;
            if (edit.getProperty().getParent() instanceof EntryType) {
                int rowCount = plugin.getView().getModel().getEntryRowCount(edit.getEntryKey());
                for (int i = 0; i < rowCount; ++i) {
                    edit.setEnable("", enable, i);
                }
            } else {
                edit.setEnable("", enable, 0);
            }
        } else {
            throw new RuntimeException("");
        }
    }

    public static void setColumnValue(IDataModel dataModel, String entry, Object value, String ... ctrlId) {
        int rowCount = dataModel.getEntryRowCount(entry);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < ctrlId.length; ++j) {
                dataModel.setValue(ctrlId[j], value, i);
            }
        }
    }

    public static DynamicObject getCurrentUser() {
        Long currentUserId = RequestContext.get().getCurrUserId();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user");
    }

    public static void openListPageWithPks(IFormView view, String formId, List<Object> billIds, String capiton) {
        if (billIds.isEmpty()) {
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)2, (boolean)false);
        LinkQueryPkIdCollection link = new LinkQueryPkIdCollection();
        for (Object billId : billIds) {
            link.addLinkQueryPkId(billId);
        }
        if (StringUtils.isNotBlank((CharSequence)capiton)) {
            parameter.setCaption(capiton);
        }
        parameter.setLinkQueryPkIdCollection(link);
        view.showForm((FormShowParameter)parameter);
    }
}

