/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.util.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClassInfo {
    protected String className = null;

    public ClassInfo(String className) {
        this.className = className;
    }

    public String getInfo() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getUrl()).append('\n');
        buf.append(this.getDeclaredFields()).append('\n');
        buf.append(this.getDeclaredMethods()).append('\n');
        return buf.toString();
    }

    public String getUrl() {
        try {
            return this.className + " location: " + Class.forName(this.className).getProtectionDomain().getCodeSource().getLocation();
        }
        catch (Exception e) {
            return "Class not find: " + e.getMessage();
        }
    }

    private String formatMethods(Method[] methods) {
        StringBuilder methodBuf = new StringBuilder("Methods:\n");
        for (Method method : methods) {
            methodBuf.append(method).append('\n');
        }
        return methodBuf.toString();
    }

    private String formatFields(Field[] fields) {
        StringBuilder fieldBuf = new StringBuilder("Fields:\n");
        for (Field field : fields) {
            fieldBuf.append(field).append('\n');
        }
        return fieldBuf.toString();
    }

    public String getFields() {
        try {
            Field[] fields = Class.forName(this.className).getFields();
            return this.formatFields(fields);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getDeclaredFields() {
        try {
            Field[] fields = Class.forName(this.className).getDeclaredFields();
            return this.formatFields(fields);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getMethods() {
        try {
            Method[] methods = Class.forName(this.className).getMethods();
            return this.formatMethods(methods);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getDeclaredMethods() {
        try {
            Method[] methods = Class.forName(this.className).getDeclaredMethods();
            return this.formatMethods(methods);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String getVersion() {
        try {
            Method method = Class.forName(this.className).getMethod("getVersion", new Class[0]);
            return "getVersion() return: " + method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return "no public static getVersion() method";
        }
    }
}

