/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.util.EmptyUtils;

public class AdjExchOpValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject[] initArr;
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        HashMap<Long, DynamicObject> orgAndInitDoMap = new HashMap<Long, DynamicObject>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            orgIds.add(data.getLong("org.id"));
        }
        for (DynamicObject initData : initArr = BusinessDataServiceHelper.load((String)(this.isAr() ? "ar_init" : "ap_init"), (String)"id,org,startperiod,curperiod,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)})) {
            orgAndInitDoMap.put(initData.getLong("org.id"), initData);
        }
        AdjExchService adjExchService = new AdjExchService(this.isAr() ? "ar" : "ap");
        Map<Long, Boolean> orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean isPeriod;
            DynamicObject initData;
            ArrayList<String> errorMessageList = new ArrayList<String>(8);
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject org = data.getDynamicObject("org");
            Long orgId = org.getLong("id");
            String periodName = ResManager.loadKDString((String)"\u671f\u521d", (String)"AdjExchOpValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            DynamicObject period = data.getDynamicObject("period");
            if (period != null) {
                periodName = period.getString("name");
            }
            if (data.getBoolean("isadjexch")) {
                errorMessageList.add(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u8c03\u6c47\u7684\u7ec4\u7ec7\u624d\u53ef\u4ee5\u8fdb\u884c\u8c03\u6c47\uff0c\u8bf7\u53d6\u6d88\u8c03\u6c47\u540e\u91cd\u8bd5\u3002", (String)"AdjExchOpValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                continue;
            }
            Boolean isParticipateInAdjExch = orgAndParamMap.get(orgId);
            if (isParticipateInAdjExch == null || !isParticipateInAdjExch.booleanValue()) {
                errorMessageList.add(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u53c2\u4e0e\u8c03\u6c47\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"AdjExchOpValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (EmptyUtils.isEmpty((initData = (DynamicObject)orgAndInitDoMap.get(orgId)).getDynamicObject("curperiod"))) {
                errorMessageList.add(ResManager.loadKDString((String)"\u672a\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u8c03\u6c47\u3002", (String)"AdjExchOpValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (!(isPeriod = data.getBoolean("isperiod"))) {
                boolean periodNull = EmptyUtils.isEmpty(period);
                if (periodNull) {
                    errorMessageList.add(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9009\u4e2d\u6570\u636e\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"AdjExchOpValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if (!periodNull) {
                    Date validatorDate = period.getDate("enddate");
                    Date curperiodEndDate = initData.getDate("curperiod.enddate");
                    Date currentDate = initData.getDate("currentdate");
                    if (validatorDate.compareTo(curperiodEndDate) < 0) {
                        errorMessageList.add(ResManager.loadKDString((String)"\u8c03\u6c47\u671f\u95f4\u5c0f\u4e8e\u7ed3\u7b97\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\uff0c\u4e0d\u5141\u8bb8\u8c03\u6c47\u3002", (String)"AdjExchOpValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    if (validatorDate.compareTo(currentDate) >= 0) {
                        errorMessageList.add(ResManager.loadKDString((String)"\u672a\u5173\u8d26\u5230\u8c03\u6c47\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f\uff0c\u4e0d\u5141\u8bb8\u8c03\u6c47\u3002", (String)"AdjExchOpValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    Long startPeriodId = (Long)initData.getDynamicObject("startperiod").getPkValue();
                    Long periodId = (Long)period.getPkValue();
                    long lastPeriodId = 0L;
                    if (!startPeriodId.equals(periodId)) {
                        DynamicObject lastPeriod = PeriodHelper.getPrevPeriod(periodId);
                        lastPeriodId = lastPeriod.getLong("id");
                    }
                    QFilter isAdjExchFilter = new QFilter("org.id", "=", (Object)orgId);
                    isAdjExchFilter.and(new QFilter("isadjexch", "=", (Object)Boolean.FALSE));
                    QFilter periodFilter = new QFilter("period.id", "=", (Object)lastPeriodId);
                    QFilter isArFilter = new QFilter("bizsystem", "=", (Object)(this.isAr() ? "AR" : "AP"));
                    boolean periodIsAdjExchFlag = QueryServiceHelper.exists((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (QFilter[])new QFilter[]{isAdjExchFilter, periodFilter, isArFilter});
                    if (periodIsAdjExchFlag) {
                        errorMessageList.add(ResManager.loadKDString((String)"\u9009\u4e2d\u7ec4\u7ec7\u8c03\u6c47\u671f\u95f4\u7684\u4e0a\u4e00\u671f\u72b6\u6001\u4e3a\u5df2\u8c03\u6c47\u65f6\uff0c\u624d\u5141\u8bb8\u5bf9\u5f53\u524d\u671f\u95f4\u8c03\u6c47\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"AdjExchOpValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                }
            }
            if (!EmptyUtils.isNotEmpty(errorMessageList)) continue;
            StringBuilder errorInfo = new StringBuilder();
            for (String errorMessage : errorMessageList) {
                errorInfo.append(errorMessage);
            }
            String errMsg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u671f\u95f4\uff1a%2$s\uff0c%3$s", (String)"AdjExchOpValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]), org.getString("name"), periodName, errorInfo.toString());
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private boolean isAr() {
        return "ar_adjustexch".equals(this.entityKey);
    }
}

