/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class BillPriceValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] datas = this.getDataEntities();
        String billName = datas[0].getDataEntity().getDataEntityType().getName();
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            boolean includetax = false;
            if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_busbill".equals(billName) || "ap_finapbill".equals(billName)) {
                includetax = bill.get("isincludetax") != null && bill.getBoolean("isincludetax");
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(this.getBillEntryName(billName));
            for (int i = 0; i < entries.size(); ++i) {
                boolean ispresent;
                DynamicObject row = (DynamicObject)entries.get(i);
                boolean bl = ispresent = row.get(this.getBillPresentName(billName)) != null && row.getBoolean(this.getBillPresentName(billName));
                if (!ispresent) {
                    if (includetax) {
                        this.checkEntryPrice(row.get(this.getBillPriceTaxName(billName)), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"BillPriceValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1, data);
                    } else {
                        this.checkEntryPrice(row.get(this.getBillPriceName(billName)), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"BillPriceValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), i + 1, data);
                    }
                }
                if (!"submit".equals(operateKey)) continue;
                BigDecimal quantity = row.getBigDecimal(this.getBillQuantityName(billName));
                BigDecimal tax = row.getBigDecimal(this.getBillTaxName(billName));
                BigDecimal amount = row.getBigDecimal(this.getBillAmountName(billName));
                BigDecimal discountAmount = row.getBigDecimal(this.getBillDiscountAmountName(billName));
                BigDecimal priceTaxTotal = row.getBigDecimal(this.getBillPriceTaxTotalName(billName));
                String msg = "";
                if ("ap_finapbill".equals(billName) || "ar_finarbill".equals(billName)) {
                    BigDecimal taxLocal = row.getBigDecimal(this.getBillTaxLocalName(billName));
                    BigDecimal amountLocal = row.getBigDecimal(this.getBillAmountLocalName(billName));
                    BigDecimal priceTaxTotalLocal = row.getBigDecimal(this.getBillPriceTaxTotalLocalName(billName));
                    if (quantity.multiply(taxLocal).compareTo(BigDecimal.ZERO) < 0 || quantity.multiply(amountLocal).compareTo(BigDecimal.ZERO) < 0 || quantity.multiply(priceTaxTotalLocal).compareTo(BigDecimal.ZERO) < 0) {
                        msg = ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u6570\u91cf\u3001\u7a0e\u989d\u3001\u91d1\u989d\u3001\u6298\u6263\u989d\u3001%2$s\u3001\u7a0e\u989d\u672c\u4f4d\u5e01\u3001\u91d1\u989d\u672c\u4f4d\u5e01\u3001%3$s\u7684\u65b9\u5411\u9700\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillPriceValidator_8", (String)"fi-arapcommon", (Object[])new Object[0]);
                        this.addErrorMessage(data, String.format(msg, i + 1, this.getPriceTaxTotalLocalString(billName), this.getPriceTaxTotalLocalName(billName)));
                    }
                }
                if (quantity.multiply(tax).compareTo(BigDecimal.ZERO) >= 0 && quantity.multiply(amount).compareTo(BigDecimal.ZERO) >= 0 && quantity.multiply(discountAmount).compareTo(BigDecimal.ZERO) >= 0 && quantity.multiply(priceTaxTotal).compareTo(BigDecimal.ZERO) >= 0 || !"".equals(msg)) continue;
                msg = ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff0c\u6570\u91cf\u3001\u7a0e\u989d\u3001\u91d1\u989d\u3001\u6298\u6263\u989d\u3001%2$s\u7684\u65b9\u5411\u9700\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BillPriceValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.addErrorMessage(data, String.format(msg, i + 1, this.getPriceTaxTotalLocalString(billName)));
            }
        }
    }

    private void checkEntryPrice(Object price, String name, int seq, ExtendedDataEntity data) {
        if (!ObjectUtils.isEmpty((Object)price) && ((BigDecimal)price).compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\uff1a%2$s\u8981\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"BillPriceValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), seq, name));
        }
    }

    private String getBillPriceName(String billName) {
        String billPriceName = "";
        if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName) || "ar_invoice".equals(billName)) {
            billPriceName = "e_unitprice";
        } else if ("ap_finapbill".equals(billName) || "ap_invoice".equals(billName)) {
            billPriceName = "price";
        }
        return billPriceName;
    }

    private String getBillPriceTaxName(String billName) {
        String billPriceTaxName = "";
        if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_busbill".equals(billName)) {
            billPriceTaxName = "e_taxunitprice";
        } else if ("ap_finapbill".equals(billName)) {
            billPriceTaxName = "pricetax";
        }
        return billPriceTaxName;
    }

    private String getBillEntryName(String billName) {
        String billEntryName = "";
        if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName) || "ar_invoice".equals(billName) || "ap_invoice".equals(billName)) {
            billEntryName = "entry";
        } else if ("ap_finapbill".equals(billName)) {
            billEntryName = "detailentry";
        }
        return billEntryName;
    }

    private String getBillPresentName(String billName) {
        String billPresentName = "";
        if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName) || "ar_invoice".equals(billName)) {
            billPresentName = "e_ispresent";
        } else if ("ap_finapbill".equals(billName) || "ap_invoice".equals(billName)) {
            billPresentName = "ispresent";
        }
        return billPresentName;
    }

    private String getBillPriceTaxTotalName(String billName) {
        String priceTaxTotal = "";
        if ("ap_finapbill".equals(billName) || "ap_busbill".equals(billName) || "ap_invoice".equals(billName) || "ar_revcfmbill".equals(billName)) {
            priceTaxTotal = "e_pricetaxtotal";
        } else if ("ar_finarbill".equals(billName) || "ar_invoice".equals(billName) || "ar_busbill".equals(billName)) {
            priceTaxTotal = "e_recamount";
        }
        return priceTaxTotal;
    }

    private String getBillPriceTaxTotalLocalName(String billName) {
        String priceTaxTotal = "";
        if ("ap_finapbill".equals(billName)) {
            priceTaxTotal = "e_pricetaxtotalbase";
        } else if ("ar_finarbill".equals(billName)) {
            priceTaxTotal = "e_reclocalamt";
        }
        return priceTaxTotal;
    }

    private String getBillAmountName(String billName) {
        String amount = "";
        if ("ap_finapbill".equals(billName) || "ap_busbill".equals(billName) || "ap_invoice".equals(billName) || "ar_finarbill".equals(billName) || "ar_invoice".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName)) {
            amount = "e_amount";
        }
        return amount;
    }

    private String getBillAmountLocalName(String billName) {
        String amount = "";
        if ("ap_finapbill".equals(billName)) {
            amount = "e_amountbase";
        } else if ("ar_finarbill".equals(billName)) {
            amount = "e_localamt";
        }
        return amount;
    }

    private String getBillDiscountAmountName(String billName) {
        String discountAmount = "";
        if ("ap_finapbill".equals(billName)) {
            discountAmount = "discountamount";
        } else if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_invoice".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName)) {
            discountAmount = "e_discountamount";
        } else if ("ap_invoice".equals(billName)) {
            discountAmount = "discountamt";
        }
        return discountAmount;
    }

    private String getBillTaxName(String billName) {
        String tax = "";
        if ("ap_finapbill".equals(billName) || "ap_busbill".equals(billName) || "ap_invoice".equals(billName) || "ar_finarbill".equals(billName) || "ar_invoice".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName)) {
            tax = "e_tax";
        }
        return tax;
    }

    private String getBillTaxLocalName(String billName) {
        String tax = "";
        if ("ap_finapbill".equals(billName) || "ar_finarbill".equals(billName)) {
            tax = "e_taxlocalamt";
        }
        return tax;
    }

    private String getBillQuantityName(String billName) {
        String quantity = "";
        if ("ap_finapbill".equals(billName) || "ap_invoice".equals(billName)) {
            quantity = "quantity";
        } else if ("ap_busbill".equals(billName) || "ar_finarbill".equals(billName) || "ar_invoice".equals(billName) || "ar_busbill".equals(billName) || "ar_revcfmbill".equals(billName)) {
            quantity = "e_quantity";
        }
        return quantity;
    }

    private String getPriceTaxTotalLocalString(String billName) {
        String priceTaxTotalKey = "";
        if ("ap_finapbill".equals(billName) || "ap_busbill".equals(billName)) {
            priceTaxTotalKey = ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"BillPriceValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if ("ap_invoice".equals(billName) || "ar_invoice".equals(billName) || "ar_revcfmbill".equals(billName)) {
            priceTaxTotalKey = ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"BillPriceValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if ("ar_finarbill".equals(billName) || "ar_busbill".equals(billName)) {
            priceTaxTotalKey = ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"BillPriceValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        return priceTaxTotalKey;
    }

    private String getPriceTaxTotalLocalName(String billName) {
        String priceTaxTotalKey = "";
        if ("ap_finapbill".equals(billName)) {
            priceTaxTotalKey = ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01", (String)"BillPriceValidator_9", (String)"fi-arapcommon", (Object[])new Object[0]);
        } else if ("ar_finarbill".equals(billName)) {
            priceTaxTotalKey = ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d\u672c\u4f4d\u5e01", (String)"BillPriceValidator_10", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        return priceTaxTotalKey;
    }
}

