/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BillVerifyAndSettleRecordValidator
extends AbstractValidator {
    private boolean ar;

    public void validate() {
        List<Long> billIds = Arrays.stream(this.getDataEntities()).map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        HashSet<Long> verifyBillIds = this.listVerifyBillIds(billIds);
        for (ExtendedDataEntity extendedDataEntity2 : this.getDataEntities()) {
            long billId;
            DynamicObject bill = extendedDataEntity2.getDataEntity();
            boolean iswrittenoff = bill.getBoolean("iswrittenoff");
            if (!this.ar && iswrittenoff || !verifyBillIds.contains(billId = bill.getLong("id"))) continue;
            this.addErrorMessage(extendedDataEntity2, ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u6838\u9500\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"BillVerifyAndSettleRecordValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public BillVerifyAndSettleRecordValidator(boolean ar) {
        this.ar = ar;
    }

    private HashSet<Long> listVerifyBillIds(List<Long> billIds) {
        HashSet<Long> verifyBillIds = new HashSet<Long>(16);
        String verityEntityName = this.ar ? "ar_verifyrecord" : "ap_verifyrecord";
        DynamicObjectCollection verifyRecordList = QueryServiceHelper.query((String)verityEntityName, (String)"id,billid", (QFilter[])new QFilter("billid", "in", billIds).toArray());
        if (EmptyUtils.isNotEmpty(verifyRecordList)) {
            verifyRecordList.forEach(entity -> verifyBillIds.add(entity.getLong("billid")));
        }
        QFilter filter = new QFilter("entry.e_billid", "in", billIds);
        String entityName = this.ar ? "ar_revcfmbill" : "ap_finapbill";
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter(entityName, billIds.toArray(), this.ar);
        filter.and(commonFilter);
        DynamicObjectCollection verifyRecordAsstList = QueryServiceHelper.query((String)verityEntityName, (String)"id,entry.e_billid", (QFilter[])filter.toArray());
        if (EmptyUtils.isEmpty(verifyRecordAsstList)) {
            return verifyBillIds;
        }
        verifyRecordAsstList.forEach(entity -> verifyBillIds.add(entity.getLong("entry.e_billid")));
        return verifyBillIds;
    }

    private HashSet<Long> listSettleBillIds(List<Long> billIds) {
        DynamicObjectCollection settleRecordAsstList;
        HashSet<Long> settleBillIds = new HashSet<Long>(16);
        String verityEntityName = this.ar ? "ar_settlerecord" : "ap_settlerecord";
        DynamicObjectCollection settleRecordList = QueryServiceHelper.query((String)verityEntityName, (String)"id,mainbillid", (QFilter[])new QFilter("mainbillid", "in", billIds).toArray());
        if (EmptyUtils.isNotEmpty(settleRecordList)) {
            settleRecordList.forEach(entity -> settleBillIds.add(entity.getLong("mainbillid")));
        }
        if (EmptyUtils.isEmpty(settleRecordAsstList = QueryServiceHelper.query((String)verityEntityName, (String)"id,entry.billid", (QFilter[])new QFilter("entry.billid", "in", billIds).toArray()))) {
            return settleBillIds;
        }
        settleRecordAsstList.forEach(entity -> settleBillIds.add(entity.getLong("entry.billid")));
        return settleBillIds;
    }
}

