/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.ScmParamsHelper;
import kd.fi.arapcommon.util.CommonUtils;

public class BillVoucherSyncValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillVoucherSyncValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillVoucherSyncValidator", (String)"validate");){
            if (this.dataEntities == null || this.dataEntities.length <= 0) {
                return;
            }
            String entityKey = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
            List pkIds = Stream.of(this.dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
            if (!ScmParamsHelper.isEnable("INV0005")) {
                logger.info("\u542f\u7528\u4e1a\u8d22\u4e00\u4f53\u5316\u53c2\u6570\u672a\u542f\u7528, \u4e0d\u8c03\u7528\u751f\u6210\u51ed\u8bc1\uff1a" + entityKey + "|AUDIT|" + pkIds);
                return;
            }
            String requestId = RequestContext.get().getRequestId();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fbillid from t_ap_taskcollaborate where ", new Object[0]);
            sqlBuilder.appendIn("fbillid", pkIds.toArray());
            DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRouteConst.AP, (SqlBuilder)sqlBuilder);
            HashSet<Object> existBills = new HashSet<Object>(16);
            for (Row row : dataSet) {
                Object fBillId = row.get("fbillid");
                existBills.add(fBillId);
            }
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity2 = entity.getDataEntity();
                Object pkValue = dataEntity2.getPkValue();
                String billNum = dataEntity2.getString("billno");
                if (!existBills.contains(pkValue)) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"%s\u540c\u6b65\u51ed\u8bc1\u7684\u4e1a\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BillVoucherSyncValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), billNum), ErrorLevel.Error);
            }
            ValidateResult validateResult = this.getValidateResult();
            List allErrorInfo = validateResult.getAllErrorInfo();
            if (!allErrorInfo.isEmpty()) {
                return;
            }
            String insertSql = "insert into t_ap_taskcollaborate (fid, fbillid, fentitynum, frequestid, fcreatetime) values (?, ?, ?, ?, ?)";
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
            Date date = new Date();
            int count = pkIds.size();
            long[] ids = DB.genLongIds((String)"t_ap_taskcollaborate", (int)count);
            for (int i = 0; i < count; ++i) {
                Object[] param = new Object[]{ids[i], pkIds.get(i), entityKey, requestId, date};
                insertParams.add(param);
            }
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)insertSql, insertParams);
            try {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("ignoreValidation", "true");
                option.setVariableValue("skipCheckSpecialDataPermission", "true");
                option.setVariableValue("ignorebillstatus", "true");
                OperationResult result = OperationServiceHelper.executeOperate((String)"generatevoucher", (String)entityKey, (Object[])pkIds.toArray(), (OperateOption)option);
                if (!result.isSuccess()) {
                    logger.error("-- \u4e1a\u8d22\u4e00\u4f53\u5316 generatevoucher result," + CommonUtils.getOpErrorMsg(result));
                }
                OperationHelper.assertResult(result);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u751f\u6210\u51ed\u8bc1\u63a5\u53e3\u5931\u8d25\u3002", (String)"BillVoucherSyncValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }
}

