/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.validator.FinApQtyExcessValidator;

@Deprecated
public class BusApQtyExcessValidator
extends FinApQtyExcessValidator {
    private Set<Long> hadRevaluationPurInIds = new HashSet<Long>(64);

    public BusApQtyExcessValidator() {
        this.entityName = "ap_busbill";
        this.billModel = BillModelFactory.getModel(this.entityName);
    }

    @Override
    public Set<String> preparePropertys() {
        Set<String> selectors = super.preparePropertys();
        selectors.add("isrevaluation");
        selectors.add("e_srcentryid");
        return selectors;
    }

    @Override
    protected Map<Long, String> directBillValidator(List<ExtendedDataEntity> directPurInEntities) {
        for (ExtendedDataEntity entity : directPurInEntities) {
            DynamicObject bill = entity.getDataEntity();
            if (!bill.getBoolean("isrevaluation")) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject busRow : entry) {
                this.hadRevaluationPurInIds.add(busRow.getLong("e_srcentryid"));
            }
        }
        return super.directBillValidator(directPurInEntities);
    }

    @Override
    protected void calculateAllPurBillQtyMap(Map<Long, BigDecimal> calculatePurBillQtyMap, List<Long> purInEntryIds, Set<Long> orgIds, Set<Long> needRemoveFinApEntryIds) {
        HashMap<Long, BigDecimal> billEntryQtyMap;
        QFilter filter;
        ArrayList<String> selectors;
        Map<Long, Map<String, Set<Long>>> allTargetRowIdsMap = BOTPHelper.loadAllTargetRowIdsMap("im_purinbill", "billentry", purInEntryIds.toArray(new Long[0]));
        HashMap<Long, Set<Long>> targetBusRowIdsMap = new HashMap<Long, Set<Long>>(64);
        HashMap<Long, Set<Long>> targetFinRowIdsMap = new HashMap<Long, Set<Long>>(64);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : allTargetRowIdsMap.entrySet()) {
            Set targetEntryIds;
            Long purEntryId = entry.getKey();
            if (this.hadRevaluationPurInIds.contains(purEntryId)) {
                targetEntryIds = ((Map)entry.getValue()).getOrDefault("ap_finapbill", new HashSet(16));
                targetFinRowIdsMap.put(purEntryId, targetEntryIds);
                continue;
            }
            targetEntryIds = ((Map)entry.getValue()).getOrDefault("ap_busbill", new HashSet(16));
            targetBusRowIdsMap.put(purEntryId, targetEntryIds);
        }
        if (!targetBusRowIdsMap.isEmpty()) {
            ArrayList busEntryIds = new ArrayList(64);
            for (Map.Entry entrySet : targetBusRowIdsMap.entrySet()) {
                busEntryIds.addAll((Collection)entrySet.getValue());
            }
            busEntryIds.removeAll(needRemoveFinApEntryIds);
            if (ObjectUtils.isEmpty(busEntryIds)) {
                return;
            }
            selectors = new ArrayList<String>(8);
            selectors.add(this.billModel.ENTRY_PK);
            selectors.add(this.billModel.ENTRY + "." + this.billModel.E_BASEUNITQTY + " " + this.billModel.E_BASEUNITQTY);
            filter = new QFilter(this.billModel.HEAD_ORG, "in", orgIds);
            filter.and(new QFilter(this.billModel.ENTRY_PK, "in", busEntryIds));
            DataSet busBillDataSet = QueryServiceHelper.queryDataSet((String)"queryBill", (String)this.entityName, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, (String)"");
            billEntryQtyMap = new HashMap(64);
            for (Row busBill : busBillDataSet) {
                billEntryQtyMap.put(busBill.getLong(this.billModel.ENTRY_PK), busBill.getBigDecimal(this.billModel.E_BASEUNITQTY));
            }
            this.calculatePurBillQty(calculatePurBillQtyMap, targetBusRowIdsMap, billEntryQtyMap);
        }
        if (!targetFinRowIdsMap.isEmpty()) {
            ArrayList finApEntryIds = new ArrayList(64);
            for (Map.Entry entrySet : targetFinRowIdsMap.entrySet()) {
                finApEntryIds.addAll((Collection)entrySet.getValue());
            }
            if (ObjectUtils.isEmpty(finApEntryIds)) {
                return;
            }
            selectors = new ArrayList(8);
            selectors.add("detailentry.id");
            selectors.add("detailentry.e_baseunitqty e_baseunitqty");
            filter = new QFilter(this.billModel.HEAD_ORG, "in", orgIds);
            filter.and(new QFilter("detailentry.id", "in", finApEntryIds));
            DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"queryBill", (String)"ap_finapbill", (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, (String)"");
            billEntryQtyMap = new HashMap<Long, BigDecimal>(64);
            for (Row finApBill : finApDataSet) {
                billEntryQtyMap.put(finApBill.getLong("detailentry.id"), finApBill.getBigDecimal("e_baseunitqty"));
            }
            this.calculatePurBillQty(calculatePurBillQtyMap, targetFinRowIdsMap, billEntryQtyMap);
        }
    }

    private void calculatePurBillQty(Map<Long, BigDecimal> calculatePurBillQtyMap, Map<Long, Set<Long>> targetRowIdsMap, Map<Long, BigDecimal> billEntryQtyMap) {
        for (Map.Entry<Long, Set<Long>> entrySet : targetRowIdsMap.entrySet()) {
            Long purInEntryId = entrySet.getKey();
            Set<Long> apEntryIds = entrySet.getValue();
            BigDecimal calculatePurBillQty = calculatePurBillQtyMap.getOrDefault(purInEntryId, BigDecimal.ZERO);
            for (Long apEntryId : apEntryIds) {
                BigDecimal apEntryQty = billEntryQtyMap.getOrDefault(apEntryId, BigDecimal.ZERO);
                calculatePurBillQty = calculatePurBillQty.add(apEntryQty);
            }
            calculatePurBillQtyMap.put(purInEntryId, calculatePurBillQty);
        }
    }
}

