/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.validator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BusRedBlueUnVerifyValidator
extends AbstractValidator {
    public void validate() {
        if (this.isAr(this.dataEntities[0].getDataEntity())) {
            return;
        }
        List<Long> revalBusBills = this.prepareData();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject record = dataEntity.getDataEntity();
            DynamicObjectCollection entry = record.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long mainId = row.getLong("billid");
                Long asstId = row.getLong("assbillid");
                String mainBillNo = row.getString("billno");
                String asstBillNo = row.getString("assbillno");
                if (revalBusBills.contains(mainId)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u5df2\u91cd\u4f30\uff0c\u53cd\u6838\u9500\u5931\u8d25\uff0c\u8bf7\u5220\u9664\u91cd\u4f30\u5355\u540e\u91cd\u8bd5\u3002", (String)"BusRedBlueUnVerifyValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillNo));
                }
                if (!revalBusBills.contains(asstId)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u5df2\u91cd\u4f30\uff0c\u53cd\u6838\u9500\u5931\u8d25\uff0c\u8bf7\u5220\u9664\u91cd\u4f30\u5355\u540e\u91cd\u8bd5\u3002", (String)"BusRedBlueUnVerifyValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillNo));
            }
        }
    }

    private List<Long> prepareData() {
        DynamicObject[] busBills;
        ArrayList<Long> revalBusBill = new ArrayList<Long>(2);
        ArrayList<Long> busBillIds = new ArrayList<Long>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                busBillIds.add(row.getLong("billid"));
                busBillIds.add(row.getLong("assbillid"));
            }
        }
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", busBillIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)})) {
            revalBusBill.add(busBill.getLong("id"));
        }
        return revalBusBill;
    }

    private boolean isAr(DynamicObject recordBill) {
        String verifyRecordEntity = recordBill.getDataEntityType().getName();
        return !"ap_bus_verifyrecord".equals(verifyRecordEntity);
    }
}

